/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

public class Entry
implements Serializable {
    private static final long serialVersionUID = -3551501551331222546L;
    private Map<String, String> cacheHeaders = Collections.emptyMap();
    private Serializable data;
    private MultivaluedMap<String, String> headers;
    private long expiresValue;
    private long initialTimestamp = Entry.now();

    public Entry(Serializable data, MultivaluedMap<String, String> headers, Map<String, String> cacheHeaders, long expiresHeaderValue) {
        this.data = data;
        this.headers = headers;
        this.cacheHeaders = cacheHeaders;
        this.expiresValue = expiresHeaderValue;
    }

    public Entry() {
    }

    public boolean isOutDated() {
        return Entry.now() - this.initialTimestamp > this.expiresValue * 1000L;
    }

    public Map<String, String> getCacheHeaders() {
        return this.cacheHeaders;
    }

    public void setCacheHeaders(Map<String, String> cacheHeaders) {
        this.cacheHeaders = cacheHeaders;
    }

    public Serializable getData() {
        return this.data;
    }

    public void setData(Serializable data) {
        this.data = data;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public long getExpiresValue() {
        return this.expiresValue;
    }

    public void setExpiresValue(long expiresValue) {
        this.expiresValue = expiresValue;
    }

    public long getInitialTimestamp() {
        return this.initialTimestamp;
    }

    public void setInitialTimestamp(long initialTimestamp) {
        this.initialTimestamp = initialTimestamp;
    }

    private static long now() {
        return System.currentTimeMillis();
    }
}

