/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;

public class AbstractJweDecryptingFilter {
    private JweDecryptionProvider decryption;
    private String defaultMediaType;

    protected JweDecryptionOutput decrypt(InputStream is) throws IOException {
        JweCompactConsumer jwe = new JweCompactConsumer(new String(IOUtils.readBytesFromStream((InputStream)is), StandardCharsets.UTF_8));
        JweDecryptionProvider theDecryptor = this.getInitializedDecryptionProvider(jwe.getJweHeaders());
        JweDecryptionOutput out = new JweDecryptionOutput(jwe.getJweHeaders(), jwe.getDecryptedContent(theDecryptor));
        JoseUtils.traceHeaders((JoseHeaders)out.getHeaders());
        this.validateHeaders(out.getHeaders());
        return out;
    }

    protected void validateHeaders(JweHeaders headers) {
    }

    public void setDecryptionProvider(JweDecryptionProvider decryptor) {
        this.decryption = decryptor;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(JweHeaders headers) {
        if (this.decryption != null) {
            return this.decryption;
        }
        return JweUtils.loadDecryptionProvider((JweHeaders)headers, (boolean)true);
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }
}

