/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationCodeGrantHandler
extends AbstractGrantHandler {
    public AuthorizationCodeGrantHandler() {
        super("authorization_code");
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        this.checkIfGrantSupported(client);
        String codeValue = (String)params.getFirst((Object)"code");
        ServerAuthorizationCodeGrant grant = ((AuthorizationCodeDataProvider)this.getDataProvider()).removeCodeGrant(codeValue);
        if (grant == null) {
            return null;
        }
        if (OAuthUtils.isExpired(grant.getIssuedAt(), grant.getLifetime())) {
            throw new OAuthServiceException("invalid_grant");
        }
        if (!grant.getClient().getClientId().equals(client.getClientId())) {
            throw new OAuthServiceException("invalid_grant");
        }
        String expectedRedirectUri = grant.getRedirectUri();
        String providedRedirectUri = (String)params.getFirst((Object)"redirect_uri");
        if (providedRedirectUri != null ? expectedRedirectUri == null || !providedRedirectUri.equals(expectedRedirectUri) : expectedRedirectUri == null && !this.isCanSupportPublicClients() || expectedRedirectUri != null && (client.getRedirectUris().size() != 1 || !client.getRedirectUris().contains(expectedRedirectUri))) {
            throw new OAuthServiceException("invalid_request");
        }
        return this.doCreateAccessToken(client, grant.getSubject(), grant.getApprovedScopes());
    }
}

