/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rt.security.claims;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimBean;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.rt.security.claims.SAMLClaim;
import org.apache.cxf.rt.security.saml.SAMLSecurityContext;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.claims.authorization.ClaimMode;
import org.apache.cxf.security.claims.authorization.Claims;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;

public class ClaimsAuthorizingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(ClaimsAuthorizingInterceptor.class);
    private static final Set<String> SKIP_METHODS = new HashSet<String>();
    private Map<String, List<ClaimBean>> claims = new HashMap<String, List<ClaimBean>>();
    private Map<String, String> nameAliases = Collections.emptyMap();
    private Map<String, String> formatAliases = Collections.emptyMap();

    public ClaimsAuthorizingInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message message) throws Fault {
        SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
        if (!(sc instanceof SAMLSecurityContext)) {
            throw new AccessDeniedException("Security Context is unavailable or unrecognized");
        }
        Method method = this.getTargetMethod(message);
        if (this.authorize((SAMLSecurityContext)sc, method)) {
            return;
        }
        throw new AccessDeniedException("Unauthorized");
    }

    public void setClaims(Map<String, List<ClaimBean>> claimsMap) {
        this.claims.putAll(claimsMap);
    }

    protected Method getTargetMethod(Message m) {
        BindingOperationInfo bop = (BindingOperationInfo)m.getExchange().get(BindingOperationInfo.class);
        if (bop != null) {
            MethodDispatcher md = (MethodDispatcher)((Service)m.getExchange().get(Service.class)).get((Object)MethodDispatcher.class.getName());
            return md.getMethod(bop);
        }
        Method method = (Method)m.get((Object)"org.apache.cxf.resource.method");
        if (method != null) {
            return method;
        }
        throw new AccessDeniedException("Method is not available : Unauthorized");
    }

    protected boolean authorize(SAMLSecurityContext sc, Method method) {
        List<ClaimBean> list = this.claims.get(method.getName());
        ClaimCollection actualClaims = sc.getClaims();
        for (ClaimBean claimBean : list) {
            SAMLClaim claim = claimBean.getClaim();
            Claim matchingClaim = null;
            for (Claim cl : actualClaims) {
                if (!(cl instanceof SAMLClaim) || !((SAMLClaim)cl).getName().equals(claim.getName()) || !((SAMLClaim)cl).getNameFormat().equals(claim.getNameFormat())) continue;
                matchingClaim = cl;
                break;
            }
            if (matchingClaim == null) {
                if (claimBean.getClaimMode() != ClaimMode.STRICT) continue;
                return false;
            }
            List<Object> claimValues = claim.getValues();
            List<Object> matchingClaimValues = matchingClaim.getValues();
            if (claimBean.isMatchAll() && !matchingClaimValues.containsAll(claimValues)) {
                return false;
            }
            boolean matched = false;
            for (Object value : matchingClaimValues) {
                if (!claimValues.contains(value)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public void setSecuredObject(Object object) {
        Class cls = ClassHelper.getRealClass((Object)object);
        this.findClaims(cls);
        if (this.claims.isEmpty()) {
            LOG.warning("The claims list is empty, the service object is not protected");
        }
    }

    protected void findClaims(Class<?> cls) {
        if (cls == null || cls == Object.class) {
            return;
        }
        List<ClaimBean> clsClaims = this.getClaims(cls.getAnnotation(Claims.class), cls.getAnnotation(org.apache.cxf.security.claims.authorization.Claim.class));
        for (Method method : cls.getMethods()) {
            if (SKIP_METHODS.contains(method.getName())) continue;
            List<ClaimBean> methodClaims = this.getClaims(method.getAnnotation(Claims.class), method.getAnnotation(org.apache.cxf.security.claims.authorization.Claim.class));
            ArrayList<ClaimBean> allClaims = new ArrayList<ClaimBean>(methodClaims);
            for (ClaimBean bean : clsClaims) {
                if (ClaimsAuthorizingInterceptor.isClaimOverridden(bean, methodClaims)) continue;
                allClaims.add(bean);
            }
            this.claims.put(method.getName(), allClaims);
        }
        if (!this.claims.isEmpty()) {
            return;
        }
        this.findClaims(cls.getSuperclass());
        if (!this.claims.isEmpty()) {
            return;
        }
        for (GenericDeclaration genericDeclaration : cls.getInterfaces()) {
            this.findClaims((Class<?>)genericDeclaration);
        }
    }

    private static boolean isClaimOverridden(ClaimBean bean, List<ClaimBean> mClaims) {
        for (ClaimBean methodBean : mClaims) {
            if (!bean.getClaim().getName().equals(methodBean.getClaim().getName()) || !bean.getClaim().getNameFormat().equals(methodBean.getClaim().getNameFormat())) continue;
            return true;
        }
        return false;
    }

    private List<ClaimBean> getClaims(Claims claimsAnn, org.apache.cxf.security.claims.authorization.Claim claimAnn) {
        ArrayList<ClaimBean> claimsList = new ArrayList<ClaimBean>();
        ArrayList<org.apache.cxf.security.claims.authorization.Claim> annClaims = new ArrayList<org.apache.cxf.security.claims.authorization.Claim>();
        if (claimsAnn != null) {
            annClaims.addAll(Arrays.asList(claimsAnn.value()));
        } else if (claimAnn != null) {
            annClaims.add(claimAnn);
        }
        for (org.apache.cxf.security.claims.authorization.Claim ann : annClaims) {
            String claimFormat;
            SAMLClaim claim = new SAMLClaim();
            String claimName = ann.name();
            if (this.nameAliases.containsKey(claimName)) {
                claimName = this.nameAliases.get(claimName);
            }
            if (this.formatAliases.containsKey(claimFormat = ann.format())) {
                claimFormat = this.formatAliases.get(claimFormat);
            }
            claim.setName(claimName);
            claim.setNameFormat(claimFormat);
            for (String value : ann.value()) {
                claim.addValue(value);
            }
            claimsList.add(new ClaimBean(claim, ann.mode(), ann.matchAll()));
        }
        return claimsList;
    }

    public void setNameAliases(Map<String, String> nameAliases) {
        this.nameAliases = nameAliases;
    }

    public void setFormatAliases(Map<String, String> formatAliases) {
        this.formatAliases = formatAliases;
    }

    static {
        SKIP_METHODS.addAll(Arrays.asList("wait", "notify", "notifyAll", "equals", "toString", "hashCode"));
    }
}

