/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.cxf.ws.security.policy.model.AsymmetricBinding;
import org.apache.cxf.ws.security.policy.model.ContentEncryptedElements;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.RequiredElements;
import org.apache.cxf.ws.security.policy.model.RequiredParts;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedElements;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.policy.model.Wss11;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.CryptoCoverageUtil;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.handler.RequestData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyBasedWSS4JInInterceptor
extends WSS4JInInterceptor {
    public static final String PROPERTIES_CACHE = "ws-security.properties.cache";
    public static final PolicyBasedWSS4JInInterceptor INSTANCE = new PolicyBasedWSS4JInInterceptor();

    public PolicyBasedWSS4JInInterceptor() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<Object, Properties> getPropertiesCache(SoapMessage message) {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
        synchronized (endpointInfo) {
            ConcurrentHashMap<Object, Properties> o = CastUtils.cast((Map)((Map)message.getContextualProperty(PROPERTIES_CACHE)));
            if (o == null) {
                o = new ConcurrentHashMap<Object, Properties>();
                info.setProperty(PROPERTIES_CACHE, o);
            }
            return o;
        }
    }

    private static Properties getProps(Object o, SoapMessage message) {
        Properties properties = PolicyBasedWSS4JInInterceptor.getPropertiesCache(message).get(o);
        if (properties != null) {
            return properties;
        }
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (o instanceof String) {
            ResourceManager rm = (ResourceManager)((Bus)message.getExchange().get(Bus.class)).getExtension(ResourceManager.class);
            URL url = (URL)rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)((String)o), AbstractWSS4JInterceptor.class);
                }
                if (url != null) {
                    properties = new Properties();
                    InputStream ins = url.openStream();
                    properties.load(ins);
                    ins.close();
                }
            }
            catch (IOException e) {
                properties = null;
            }
        } else if (o instanceof URL) {
            properties = new Properties();
            try {
                InputStream ins = ((URL)o).openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                properties = null;
            }
        }
        if (properties != null) {
            PolicyBasedWSS4JInInterceptor.getPropertiesCache(message).put(o, properties);
        }
        return properties;
    }

    private boolean containsPolicy(AssertionInfoMap aim, QName n) {
        Collection ais = aim.getAssertionInfo(n);
        return ais != null && !ais.isEmpty();
    }

    private void handleWSS11(AssertionInfoMap aim, SoapMessage message) {
        if (!this.isRequestor(message)) {
            this.assertPolicy(aim, SP12Constants.WSS11);
            return;
        }
        message.put("enableSignatureConfirmation", (Object)"false");
        Collection ais = (Collection)aim.get((Object)SP12Constants.WSS11);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                Wss11 wss11 = (Wss11)ai.getAssertion();
                if (wss11.isRequireSignatureConfirmation()) {
                    message.put("enableSignatureConfirmation", (Object)"true");
                    continue;
                }
                ai.setAsserted(true);
            }
        }
    }

    private String addToAction(String action, String val, boolean pre) {
        if (action.contains(val)) {
            return action;
        }
        if (pre) {
            return val + " " + action;
        }
        return action + " " + val;
    }

    private boolean assertPolicy(AssertionInfoMap aim, QName q) {
        Collection ais = (Collection)aim.get((Object)q);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
            return true;
        }
        return false;
    }

    private void assertPolicy(AssertionInfoMap aim, Token token, boolean derived) {
        if (!derived && token instanceof X509Token && token.isDerivedKeys()) {
            this.notAssertPolicy(aim, token, "No derived keys found.");
        }
    }

    private void assertPolicy(AssertionInfoMap aim, PolicyAssertion token) {
        Collection ais = (Collection)aim.get((Object)token.getName());
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != token) continue;
                ai.setAsserted(true);
            }
        }
    }

    private void notAssertPolicy(AssertionInfoMap aim, PolicyAssertion token, String msg) {
        Collection ais = (Collection)aim.get((Object)token.getName());
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != token) continue;
                ai.setNotAsserted(msg);
            }
        }
    }

    private String checkAsymetricBinding(AssertionInfoMap aim, String action, SoapMessage message) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.ASYMMETRIC_BINDING);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                AsymmetricBinding abinding = (AsymmetricBinding)ai.getAssertion();
                if (abinding.getProtectionOrder() == SPConstants.ProtectionOrder.EncryptBeforeSigning) {
                    action = this.addToAction(action, "Signature", true);
                    action = this.addToAction(action, "Encrypt", true);
                } else {
                    action = this.addToAction(action, "Encrypt", true);
                    action = this.addToAction(action, "Signature", true);
                }
                Object s = message.getContextualProperty("ws-security.signature.properties");
                Object e = message.getContextualProperty("ws-security.encryption.properties");
                if (s != null) {
                    message.put("decryptionPropRefId", (Object)("RefId-" + s.toString()));
                    message.put("RefId-" + s.toString(), (Object)PolicyBasedWSS4JInInterceptor.getProps(s, message));
                    if (e == null) {
                        e = s;
                    }
                }
                if (e == null) continue;
                message.put("SignaturePropRefId", (Object)("RefId-" + e.toString()));
                message.put("RefId-" + e.toString(), (Object)PolicyBasedWSS4JInInterceptor.getProps(e, message));
            }
        }
        return action;
    }

    private String checkTransportBinding(AssertionInfoMap aim, String action, SoapMessage message) {
        if (this.isRequestor(message) && StringUtils.isEmpty((String)action)) {
            this.assertPolicy(aim, SP12Constants.TRANSPORT_BINDING);
            this.assertPolicy(aim, SP12Constants.TRANSPORT_TOKEN);
            this.assertPolicy(aim, SP12Constants.SUPPORTING_TOKENS);
        }
        return action;
    }

    private String checkSymetricBinding(AssertionInfoMap aim, String action, SoapMessage message) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.SYMMETRIC_BINDING);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                SymmetricBinding abinding = (SymmetricBinding)ai.getAssertion();
                if (abinding.getProtectionOrder() == SPConstants.ProtectionOrder.EncryptBeforeSigning) {
                    action = this.addToAction(action, "Signature", true);
                    action = this.addToAction(action, "Encrypt", true);
                } else {
                    action = this.addToAction(action, "Encrypt", true);
                    action = this.addToAction(action, "Signature", true);
                }
                Object s = message.getContextualProperty("ws-security.signature.properties");
                Object e = message.getContextualProperty("ws-security.encryption.properties");
                if (abinding.getProtectionToken() != null) {
                    if (e != null && s == null) {
                        s = e;
                    } else if (s != null && e == null) {
                        e = s;
                    }
                }
                if (this.isRequestor(message)) {
                    if (e != null) {
                        message.put("SignaturePropRefId", (Object)("RefId-" + e.toString()));
                        message.put("RefId-" + e.toString(), (Object)PolicyBasedWSS4JInInterceptor.getProps(e, message));
                    }
                    if (s == null) continue;
                    message.put("decryptionPropRefId", (Object)("RefId-" + s.toString()));
                    message.put("RefId-" + s.toString(), (Object)PolicyBasedWSS4JInInterceptor.getProps(s, message));
                    continue;
                }
                if (s != null) {
                    message.put("SignaturePropRefId", (Object)("RefId-" + s.toString()));
                    message.put("RefId-" + s.toString(), (Object)PolicyBasedWSS4JInInterceptor.getProps(s, message));
                }
                if (e == null) continue;
                message.put("decryptionPropRefId", (Object)("RefId-" + e.toString()));
                message.put("RefId-" + e.toString(), (Object)PolicyBasedWSS4JInInterceptor.getProps(e, message));
            }
        }
        return action;
    }

    private void assertXPathTokens(AssertionInfoMap aim, QName name, Collection<WSDataRef> refs, SoapMessage msg, SOAPMessage doc, CryptoCoverageUtil.CoverageType type, CryptoCoverageUtil.CoverageScope scope) throws SOAPException {
        Collection ais = (Collection)aim.get((Object)name);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                AbstractSecurityAssertion p;
                ai.setAsserted(true);
                Map<String, String> namespaces = null;
                List<String> xpaths = null;
                if (CryptoCoverageUtil.CoverageScope.CONTENT.equals((Object)scope)) {
                    p = (ContentEncryptedElements)ai.getAssertion();
                    namespaces = ((ContentEncryptedElements)p).getDeclaredNamespaces();
                    xpaths = ((ContentEncryptedElements)p).getXPathExpressions();
                } else {
                    p = (SignedEncryptedElements)ai.getAssertion();
                    namespaces = ((SignedEncryptedElements)p).getDeclaredNamespaces();
                    xpaths = ((SignedEncryptedElements)p).getXPathExpressions();
                }
                if (xpaths == null) continue;
                for (String xPath : xpaths) {
                    try {
                        CryptoCoverageUtil.checkCoverage(doc, refs, namespaces, xPath, type, scope);
                    }
                    catch (WSSecurityException e) {
                        ai.setNotAsserted("No " + (Object)((Object)type) + " element found matching XPath " + xPath);
                    }
                }
            }
        }
    }

    private void assertTokens(AssertionInfoMap aim, QName name, Collection<WSDataRef> signed, SoapMessage msg, SOAPMessage doc, CryptoCoverageUtil.CoverageType type) throws SOAPException {
        Collection ais = (Collection)aim.get((Object)name);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
                SignedEncryptedParts p = (SignedEncryptedParts)ai.getAssertion();
                if (p.isBody()) {
                    try {
                        if (CryptoCoverageUtil.CoverageType.SIGNED.equals((Object)type)) {
                            CryptoCoverageUtil.checkBodyCoverage(doc, signed, type, CryptoCoverageUtil.CoverageScope.ELEMENT);
                        } else {
                            CryptoCoverageUtil.checkBodyCoverage(doc, signed, type, CryptoCoverageUtil.CoverageScope.CONTENT);
                        }
                    }
                    catch (WSSecurityException e) {
                        ai.setNotAsserted(msg.getVersion().getBody() + " not " + (Object)((Object)type));
                    }
                }
                for (Header h : p.getHeaders()) {
                    try {
                        CryptoCoverageUtil.checkHeaderCoverage(doc, signed, h.getNamespace(), h.getName(), type, CryptoCoverageUtil.CoverageScope.ELEMENT);
                    }
                    catch (WSSecurityException e) {
                        ai.setNotAsserted(h.getQName() + " not + " + (Object)((Object)type));
                    }
                }
            }
        }
    }

    @Override
    protected void computeAction(SoapMessage message, RequestData data) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        String action = this.getString("action", message);
        if (action == null) {
            action = "";
        }
        if (aim != null) {
            if (this.containsPolicy(aim, SP12Constants.INCLUDE_TIMESTAMP)) {
                action = this.addToAction(action, "Timestamp", true);
            }
            if (this.containsPolicy(aim, SP12Constants.USERNAME_TOKEN)) {
                if (this.isRequestor(message)) {
                    this.assertPolicy(aim, SP12Constants.USERNAME_TOKEN);
                } else {
                    action = this.addToAction(action, "UsernameToken", true);
                }
            }
            this.assertPolicy(aim, SP12Constants.LAYOUT);
            this.assertPolicy(aim, SP12Constants.WSS10);
            this.assertPolicy(aim, SP12Constants.TRUST_13);
            this.assertPolicy(aim, SP11Constants.TRUST_10);
            this.handleWSS11(aim, message);
            action = this.checkAsymetricBinding(aim, action, message);
            action = this.checkSymetricBinding(aim, action, message);
            action = this.checkTransportBinding(aim, action, message);
            this.assertPolicy(aim, SP12Constants.KEYVALUE_TOKEN);
            this.assertPolicy(aim, SP12Constants.X509_TOKEN);
            message.put("action", (Object)action.trim());
        }
    }

    private Protections addSign(Protections prots) {
        if (prots == Protections.NONE) {
            return Protections.SIGN;
        }
        if (prots == Protections.ENCRYPT) {
            return Protections.ENCRYPT_SIGN;
        }
        return prots;
    }

    private Protections addEncrypt(Protections prots) {
        if (prots == Protections.NONE) {
            return Protections.ENCRYPT;
        }
        if (prots == Protections.SIGN) {
            return Protections.SIGN_ENCRYPT;
        }
        if (prots == Protections.ENCRYPT_SIGN || prots == Protections.SIGN_ENCRYPT) {
            return Protections.ENCRYPT_SIGN_PROTECT;
        }
        return prots;
    }

    @Override
    protected void doResults(SoapMessage msg, String actor, SOAPMessage doc, Vector results) throws SOAPException, XMLStreamException, WSSecurityException {
        AssertionInfoMap aim = (AssertionInfoMap)msg.get(AssertionInfoMap.class);
        HashSet<WSDataRef> signed = new HashSet<WSDataRef>();
        HashSet<WSDataRef> encrypted = new HashSet<WSDataRef>();
        boolean hasDerivedKeys = false;
        boolean hasEndorsement = false;
        Protections prots = Protections.NONE;
        block8: for (int j = 0; j < results.size(); ++j) {
            WSSecurityEngineResult wser = (WSSecurityEngineResult)results.get(j);
            Integer actInt = (Integer)wser.get((Object)"action");
            switch (actInt) {
                case 2: {
                    List sl = CastUtils.cast((List)((List)wser.get((Object)"data-ref-uris")));
                    if (sl == null) continue block8;
                    if (sl.size() == 1 && ((WSDataRef)sl.get(0)).getName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"))) {
                        hasEndorsement = true;
                        continue block8;
                    }
                    for (WSDataRef r : sl) {
                        signed.add(r);
                    }
                    prots = this.addSign(prots);
                    continue block8;
                }
                case 4: {
                    List el = CastUtils.cast((List)((List)wser.get((Object)"data-ref-uris")));
                    if (el == null) continue block8;
                    for (WSDataRef r : el) {
                        encrypted.add(r);
                    }
                    prots = this.addEncrypt(prots);
                    continue block8;
                }
                case 1: {
                    Collection ais = (Collection)aim.get((Object)SP12Constants.USERNAME_TOKEN);
                    if (ais == null) continue block8;
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                    WSUsernameTokenPrincipal princ = (WSUsernameTokenPrincipal)wser.get((Object)"principal");
                    for (AssertionInfo ai : ais) {
                        UsernameToken tok = (UsernameToken)ai.getAssertion();
                        if (tok.isHashPassword() == princ.isPasswordDigest()) continue;
                        ai.setNotAsserted("Password hashing policy not enforced");
                    }
                    continue block8;
                }
                case 32: {
                    this.assertPolicy(aim, SP12Constants.INCLUDE_TIMESTAMP);
                    continue block8;
                }
                case 2048: {
                    hasDerivedKeys = true;
                    continue block8;
                }
                case 128: {
                    this.assertPolicy(aim, SP12Constants.WSS11);
                    continue block8;
                }
            }
        }
        CryptoCoverageUtil.reconcileEncryptedSignedRefs(signed, encrypted);
        this.assertTokens(aim, SP12Constants.SIGNED_PARTS, signed, msg, doc, CryptoCoverageUtil.CoverageType.SIGNED);
        this.assertTokens(aim, SP12Constants.ENCRYPTED_PARTS, encrypted, msg, doc, CryptoCoverageUtil.CoverageType.ENCRYPTED);
        this.assertXPathTokens(aim, SP12Constants.SIGNED_ELEMENTS, signed, msg, doc, CryptoCoverageUtil.CoverageType.SIGNED, CryptoCoverageUtil.CoverageScope.ELEMENT);
        this.assertXPathTokens(aim, SP12Constants.ENCRYPTED_ELEMENTS, encrypted, msg, doc, CryptoCoverageUtil.CoverageType.ENCRYPTED, CryptoCoverageUtil.CoverageScope.ELEMENT);
        this.assertXPathTokens(aim, SP12Constants.CONTENT_ENCRYPTED_ELEMENTS, encrypted, msg, doc, CryptoCoverageUtil.CoverageType.ENCRYPTED, CryptoCoverageUtil.CoverageScope.CONTENT);
        this.assertHeadersExists(aim, msg, doc);
        this.assertAsymetricBinding(aim, msg, doc, prots, hasDerivedKeys);
        this.assertSymetricBinding(aim, msg, doc, prots, hasDerivedKeys);
        this.assertTransportBinding(aim);
        this.assertPolicy(aim, SP12Constants.SIGNED_SUPPORTING_TOKENS);
        this.assertPolicy(aim, SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS);
        this.assertPolicy(aim, SP12Constants.SUPPORTING_TOKENS);
        this.assertPolicy(aim, SP12Constants.ENCRYPTED_SUPPORTING_TOKENS);
        if (hasEndorsement || this.isRequestor(msg)) {
            this.assertPolicy(aim, SP12Constants.ENDORSING_SUPPORTING_TOKENS);
            this.assertPolicy(aim, SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS);
            this.assertPolicy(aim, SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS);
            this.assertPolicy(aim, SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS);
        }
        super.doResults(msg, actor, doc, results);
    }

    private void assertHeadersExists(AssertionInfoMap aim, SoapMessage msg, SOAPMessage doc) throws SOAPException {
        AbstractSecurityAssertion rp;
        SOAPHeader header = doc.getSOAPHeader();
        Collection ais = (Collection)aim.get((Object)SP12Constants.REQUIRED_PARTS);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                rp = (RequiredParts)ai.getAssertion();
                ai.setAsserted(true);
                for (Header h : ((RequiredParts)rp).getHeaders()) {
                    if (header != null && DOMUtils.getFirstChildWithName((Element)header, (QName)h.getQName()) != null) continue;
                    ai.setNotAsserted("No header element of name " + h.getQName() + " found.");
                }
            }
        }
        if ((ais = (Collection)aim.get((Object)SP12Constants.REQUIRED_ELEMENTS)) != null) {
            for (AssertionInfo ai : ais) {
                rp = (RequiredElements)ai.getAssertion();
                ai.setAsserted(true);
                Map<String, String> namespaces = ((RequiredElements)rp).getDeclaredNamespaces();
                XPathFactory factory = XPathFactory.newInstance();
                for (String expression : ((RequiredElements)rp).getXPathExpressions()) {
                    XPath xpath = factory.newXPath();
                    if (namespaces != null) {
                        xpath.setNamespaceContext((NamespaceContext)new MapNamespaceContext(namespaces));
                    }
                    try {
                        NodeList list = (NodeList)xpath.evaluate(expression, header, XPathConstants.NODESET);
                        if (list.getLength() != 0) continue;
                        ai.setNotAsserted("No header element matching XPath " + expression + " found.");
                    }
                    catch (XPathExpressionException e) {
                        ai.setNotAsserted("Invalid XPath expression " + expression + " " + e.getMessage());
                    }
                }
            }
        }
    }

    private boolean assertSymetricBinding(AssertionInfoMap aim, SoapMessage message, SOAPMessage doc, Protections prots, boolean derived) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.SYMMETRIC_BINDING);
        if (ais == null) {
            return true;
        }
        for (AssertionInfo ai : ais) {
            SymmetricBinding abinding = (SymmetricBinding)ai.getAssertion();
            ai.setAsserted(true);
            if (abinding.getProtectionOrder() == SPConstants.ProtectionOrder.EncryptBeforeSigning) {
                if (abinding.isSignatureProtection()) {
                    if (prots == Protections.ENCRYPT_SIGN || prots == Protections.SIGN_ENCRYPT) {
                        ai.setNotAsserted("Not encrypted before signed and then protected");
                    }
                } else if (prots == Protections.SIGN_ENCRYPT) {
                    ai.setNotAsserted("Not encrypted before signed");
                }
            } else if (prots == Protections.ENCRYPT_SIGN) {
                ai.setNotAsserted("Not signed before encrypted");
            }
            if (abinding.getEncryptionToken() != null) {
                this.assertPolicy(aim, abinding.getEncryptionToken());
                this.assertPolicy(aim, abinding.getEncryptionToken().getToken(), derived);
            }
            if (abinding.getSignatureToken() != null) {
                this.assertPolicy(aim, abinding.getSignatureToken());
                this.assertPolicy(aim, abinding.getSignatureToken().getToken(), derived);
            }
            if (abinding.getProtectionToken() == null) continue;
            this.assertPolicy(aim, abinding.getProtectionToken());
            this.assertPolicy(aim, abinding.getProtectionToken().getToken(), derived);
        }
        return true;
    }

    private boolean assertAsymetricBinding(AssertionInfoMap aim, SoapMessage message, SOAPMessage doc, Protections prots, boolean derived) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.ASYMMETRIC_BINDING);
        if (ais == null) {
            return true;
        }
        for (AssertionInfo ai : ais) {
            AsymmetricBinding abinding = (AsymmetricBinding)ai.getAssertion();
            ai.setAsserted(true);
            if (abinding.getProtectionOrder() == SPConstants.ProtectionOrder.EncryptBeforeSigning) {
                if (abinding.isSignatureProtection()) {
                    if (prots == Protections.ENCRYPT_SIGN || prots == Protections.SIGN_ENCRYPT) {
                        ai.setNotAsserted("Not encrypted before signed and then protected");
                    }
                } else if (prots == Protections.SIGN_ENCRYPT) {
                    ai.setNotAsserted("Not encrypted before signed");
                }
            } else if (prots == Protections.ENCRYPT_SIGN) {
                ai.setNotAsserted("Not signed before encrypted");
            }
            this.assertPolicy(aim, abinding.getInitiatorToken());
            this.assertPolicy(aim, abinding.getRecipientToken());
            this.assertPolicy(aim, abinding.getInitiatorToken().getToken(), derived);
            this.assertPolicy(aim, abinding.getRecipientToken().getToken(), derived);
        }
        return true;
    }

    private boolean assertTransportBinding(AssertionInfoMap aim) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.TRANSPORT_BINDING);
        if (ais == null) {
            return true;
        }
        this.assertPolicy(aim, SP12Constants.TRANSPORT_TOKEN);
        this.assertPolicy(aim, SP12Constants.ENCRYPTED_PARTS);
        this.assertPolicy(aim, SP12Constants.SIGNED_PARTS);
        return !this.assertPolicy(aim, SP12Constants.TRANSPORT_BINDING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Protections {
        NONE,
        SIGN,
        ENCRYPT,
        SIGN_ENCRYPT,
        ENCRYPT_SIGN,
        ENCRYPT_SIGN_PROTECT;

    }
}

