/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.interceptors.SecureConversationTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.ProtectionToken;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStore;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecureConversationInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    static final Logger LOG = LogUtils.getL7dLogger(SecureConversationInInterceptor.class);

    public SecureConversationInInterceptor() {
        super("pre-protocol");
    }

    private Binding getBinding(AssertionInfoMap aim) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.SYMMETRIC_BINDING);
        if (ais != null && !ais.isEmpty()) {
            return (Binding)((AssertionInfo)ais.iterator().next()).getAssertion();
        }
        ais = (Collection)aim.get((Object)SP12Constants.ASYMMETRIC_BINDING);
        if (ais != null && !ais.isEmpty()) {
            return (Binding)((AssertionInfo)ais.iterator().next()).getAssertion();
        }
        ais = (Collection)aim.get((Object)SP12Constants.TRANSPORT_BINDING);
        if (ais != null && !ais.isEmpty()) {
            return (Binding)((AssertionInfo)ais.iterator().next()).getAssertion();
        }
        return null;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null) {
            Collection ais = (Collection)aim.get((Object)SP12Constants.SECURE_CONVERSATION_TOKEN);
            if (ais == null || ais.isEmpty()) {
                return;
            }
            if (this.isRequestor((Message)message)) {
                for (AssertionInfo ai : ais) {
                    ai.setAsserted(true);
                }
                Object s = message.getContextualProperty("ws-security.sts.token.do.cancel");
                if (s != null && (Boolean.TRUE.equals(s) || "true".equalsIgnoreCase(s.toString()))) {
                    message.getInterceptorChain().add((Interceptor)SecureConversationCancelInterceptor.INSTANCE);
                }
                return;
            }
            String s = (String)message.get((Object)"SOAPAction");
            String addNs = null;
            AddressingProperties inProps = (AddressingProperties)message.getContextualProperty("javax.xml.ws.addressing.context.inbound");
            if (inProps != null) {
                addNs = inProps.getNamespaceURI();
                if (s == null) {
                    s = inProps.getAction().getValue();
                }
            }
            if (s != null && s.contains("/RST/SCT") && (s.startsWith("http://schemas.xmlsoap.org/ws/2005/02/trust") || s.startsWith("http://docs.oasis-open.org/ws-sx/ws-trust/200512"))) {
                Policy p;
                SecureConversationToken tok = (SecureConversationToken)((AssertionInfo)ais.iterator().next()).getAssertion();
                Policy pol = tok.getBootstrapPolicy();
                if (s.endsWith("Cancel") || s.endsWith("/Renew")) {
                    p = new Policy();
                    ExactlyOne ea = new ExactlyOne();
                    p.addPolicyComponent((PolicyComponent)ea);
                    All all = new All();
                    PolicyAssertion ass = SecureConversationTokenInterceptorProvider.getAddressingPolicy(aim, false);
                    all.addPolicyComponent((PolicyComponent)ass);
                    ea.addPolicyComponent((PolicyComponent)all);
                    SymmetricBinding binding = new SymmetricBinding(SP12Constants.INSTANCE);
                    binding.setIncludeTimestamp(true);
                    ProtectionToken token = new ProtectionToken(SP12Constants.INSTANCE);
                    token.setToken(new SecureConversationToken(SP12Constants.INSTANCE));
                    binding.setProtectionToken(token);
                    binding.setEntireHeadersAndBodySignatures(true);
                    Binding origBinding = this.getBinding(aim);
                    binding.setAlgorithmSuite(origBinding.getAlgorithmSuite());
                    all.addPolicyComponent((PolicyComponent)binding);
                    SignedEncryptedParts parts = new SignedEncryptedParts(true, SP12Constants.INSTANCE);
                    parts.setBody(true);
                    if (addNs != null) {
                        parts.addHeader(new Header("To", addNs));
                        parts.addHeader(new Header("From", addNs));
                        parts.addHeader(new Header("FaultTo", addNs));
                        parts.addHeader(new Header("ReplyTO", addNs));
                        parts.addHeader(new Header("MessageID", addNs));
                        parts.addHeader(new Header("RelatesTo", addNs));
                        parts.addHeader(new Header("Action", addNs));
                    }
                    all.addPolicyComponent((PolicyComponent)parts);
                    pol = p;
                    message.getInterceptorChain().add((Interceptor)SecureConversationTokenFinderInterceptor.INSTANCE);
                } else {
                    p = new Policy();
                    ExactlyOne ea = new ExactlyOne();
                    p.addPolicyComponent((PolicyComponent)ea);
                    All all = new All();
                    PolicyAssertion ass = SecureConversationTokenInterceptorProvider.getAddressingPolicy(aim, false);
                    all.addPolicyComponent((PolicyComponent)ass);
                    ea.addPolicyComponent((PolicyComponent)all);
                    pol = p.merge(pol);
                }
                this.unmapSecurityProps((Message)message);
                String ns = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
                if (s.startsWith("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
                    ns = "http://schemas.xmlsoap.org/ws/2005/02/trust";
                }
                this.recalcEffectivePolicy(message, ns, pol);
            } else {
                message.getInterceptorChain().add((Interceptor)SecureConversationTokenFinderInterceptor.INSTANCE);
            }
        }
    }

    private void recalcEffectivePolicy(SoapMessage message, String namespace, Policy policy) {
        Exchange ex = message.getExchange();
        Bus bus = (Bus)ex.get(Bus.class);
        PolicyEngine pe = (PolicyEngine)bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        Destination destination = ex.getDestination();
        try {
            Endpoint endpoint = (Endpoint)message.getExchange().get(Endpoint.class);
            TokenStore store = (TokenStore)message.getContextualProperty(TokenStore.class.getName());
            if (store == null) {
                store = new MemoryTokenStore();
                endpoint.getEndpointInfo().setProperty(TokenStore.class.getName(), (Object)store);
            }
            endpoint = STSUtils.createSTSEndpoint(bus, namespace, null, destination.getAddress().getAddress().getValue(), message.getVersion().getBindingId(), policy, null);
            endpoint.getEndpointInfo().setProperty(TokenStore.class.getName(), (Object)store);
            EndpointPolicy ep = pe.getServerEndpointPolicy(endpoint.getEndpointInfo(), destination);
            List interceptors = ep.getInterceptors();
            for (Interceptor i : interceptors) {
                message.getInterceptorChain().add(i);
            }
            Collection assertions = ep.getVocabulary();
            if (null != assertions) {
                message.put(AssertionInfoMap.class, (Object)new AssertionInfoMap(assertions));
            }
            endpoint.getService().setInvoker((Invoker)new STSInvoker());
            ex.put(Endpoint.class, (Object)endpoint);
            ex.put(Service.class, (Object)endpoint.getService());
        }
        catch (Exception exc) {
            throw new Fault((Throwable)exc);
        }
    }

    private void unmapSecurityProps(Message message) {
        Exchange ex = message.getExchange();
        for (String s : SecurityConstants.ALL_PROPERTIES) {
            Object v = message.getContextualProperty(s + ".sct");
            if (v == null) continue;
            ex.put((Object)s, v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SecureConversationCancelInterceptor
    extends AbstractPhaseInterceptor<SoapMessage> {
        static final SecureConversationCancelInterceptor INSTANCE = new SecureConversationCancelInterceptor();

        public SecureConversationCancelInterceptor() {
            super("post-logical");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim == null) {
                return;
            }
            Collection ais = (Collection)aim.get((Object)SP12Constants.SECURE_CONVERSATION_TOKEN);
            if (ais == null || ais.isEmpty()) {
                return;
            }
            SecureConversationToken tok = (SecureConversationToken)((AssertionInfo)ais.iterator().next()).getAssertion();
            this.doCancel(message, aim, tok);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCancel(SoapMessage message, AssertionInfoMap aim, SecureConversationToken itok) {
            String tokId;
            Message m2 = message.getExchange().getOutMessage();
            SecurityToken tok = (SecurityToken)m2.getContextualProperty("ws-security.token");
            if (tok == null && (tokId = (String)m2.getContextualProperty("ws-security.token.id")) != null) {
                tok = SecureConversationTokenInterceptorProvider.getTokenStore(m2).getToken(tokId);
            }
            STSClient client = SecureConversationTokenInterceptorProvider.getClient(m2);
            AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.inbound");
            if (maps == null) {
                maps = (AddressingProperties)m2.get((Object)"javax.xml.ws.addressing.context");
            }
            STSClient sTSClient = client;
            synchronized (sTSClient) {
                try {
                    SecureConversationTokenInterceptorProvider.setupClient(client, message, aim, itok, true);
                    if (maps != null) {
                        client.setAddressingNamespace(maps.getNamespaceURI());
                    }
                    client.cancelSecurityToken(tok);
                    SecureConversationTokenInterceptorProvider.getTokenStore(m2).remove(tok);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
                finally {
                    client.setTrust((Trust10)null);
                    client.setTrust((Trust13)null);
                    client.setTemplate(null);
                    client.setLocation(null);
                    client.setAddressingNamespace(null);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SecureConversationTokenFinderInterceptor
    extends AbstractPhaseInterceptor<SoapMessage> {
        static final SecureConversationTokenFinderInterceptor INSTANCE = new SecureConversationTokenFinderInterceptor();

        private SecureConversationTokenFinderInterceptor() {
            super("pre-protocol");
            this.addAfter(WSS4JInInterceptor.class.getName());
        }

        public void handleMessage(SoapMessage message) throws Fault {
            boolean found = false;
            List results = (List)message.get((Object)"RECV_RESULTS");
            for (int i = 0; i < results.size(); ++i) {
                WSHandlerResult rResult = (WSHandlerResult)results.get(i);
                Vector wsSecEngineResults = rResult.getResults();
                for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                    WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                    Integer actInt = (Integer)wser.get((Object)"action");
                    if (actInt != 1024) continue;
                    SecurityContextToken tok = (SecurityContextToken)wser.get((Object)"security-context-token");
                    message.getExchange().put((Object)"ws-security.token.id", (Object)tok.getID());
                    found = true;
                }
            }
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get((Object)SP12Constants.SECURE_CONVERSATION_TOKEN);
                if (ais == null || ais.isEmpty()) {
                    return;
                }
                for (AssertionInfo inf : ais) {
                    if (found) {
                        inf.setAsserted(true);
                        continue;
                    }
                    inf.setNotAsserted("No SecureConversation token found in message.");
                }
            }
        }
    }

    public class STSInvoker
    implements Invoker {
        public Object invoke(Exchange exchange, Object o) {
            AddressingProperties inProps = (AddressingProperties)exchange.getInMessage().getContextualProperty("javax.xml.ws.addressing.context.inbound");
            if (inProps != null) {
                AddressingPropertiesImpl props = new AddressingPropertiesImpl(inProps.getNamespaceURI());
                AttributedURIType action = new AttributedURIType();
                action.setValue(inProps.getAction().getValue().replace("/RST/", "/RSTR/"));
                props.setAction(action);
                exchange.getOutMessage().put((Object)"javax.xml.ws.addressing.context.outbound", (Object)props);
            }
            MessageContentsList lst = (MessageContentsList)o;
            DOMSource src = (DOMSource)lst.get(0);
            Node nd = src.getNode();
            Element requestEl = null;
            requestEl = nd instanceof Document ? ((Document)nd).getDocumentElement() : (Element)nd;
            String namespace = requestEl.getNamespaceURI();
            String prefix = requestEl.getPrefix();
            SecurityToken cancelToken = null;
            if ("RequestSecurityToken".equals(requestEl.getLocalName())) {
                try {
                    W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
                    writer.setNsRepairing(true);
                    if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace)) {
                        writer.writeStartElement(prefix, "RequestSecurityTokenResponseCollection", namespace);
                    }
                    writer.writeStartElement(prefix, "RequestSecurityTokenResponse", namespace);
                    String requestType = null;
                    Element el = DOMUtils.getFirstElement((Node)requestEl);
                    while (el != null) {
                        String localName = el.getLocalName();
                        if (namespace.equals(el.getNamespaceURI())) {
                            if ("RequestType".equals(localName)) {
                                requestType = el.getTextContent();
                            } else if ("CancelTarget".equals(localName)) {
                                cancelToken = this.findCancelToken(exchange, el);
                            }
                        }
                        el = DOMUtils.getNextElement((Element)el);
                    }
                    if (requestType == null) {
                        requestType = "/Issue";
                    }
                    if (requestType.endsWith("/Issue")) {
                        this.doIssue(requestEl, exchange, writer, prefix, namespace);
                    } else if (requestType.endsWith("/Cancel")) {
                        TokenStore store = (TokenStore)((Endpoint)exchange.get(Endpoint.class)).getEndpointInfo().getProperty(TokenStore.class.getName());
                        cancelToken.setState(SecurityToken.State.CANCELLED);
                        store.update(cancelToken);
                        writer.writeEmptyElement(prefix, "RequestedTokenCancelled", namespace);
                        exchange.put((Object)"ws-security.token", (Object)cancelToken);
                    } else if (requestType.endsWith("/Renew")) {
                        // empty if block
                    }
                    writer.writeEndElement();
                    if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace)) {
                        writer.writeEndElement();
                    }
                    return new MessageContentsList(new Object[]{new DOMSource(writer.getDocument())});
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new Fault((Throwable)ex);
                }
            }
            throw new Fault("Unknown SecureConversation element: " + requestEl.getLocalName(), LOG);
        }

        private void doIssue(Element requestEl, Exchange exchange, W3CDOMStreamWriter writer, String prefix, String namespace) throws Exception {
            byte[] clientEntropy = null;
            int keySize = 256;
            int ttl = 300000;
            String tokenType = null;
            Element el = DOMUtils.getFirstElement((Node)requestEl);
            while (el != null) {
                String localName = el.getLocalName();
                if (namespace.equals(el.getNamespaceURI())) {
                    if ("Entropy".equals(localName)) {
                        Element bs = DOMUtils.getFirstElement((Node)el);
                        if (bs != null) {
                            clientEntropy = Base64.decode((String)bs.getTextContent());
                        }
                    } else if ("KeySize".equals(localName)) {
                        keySize = Integer.parseInt(el.getTextContent());
                    } else if ("TokenType".equals(localName)) {
                        tokenType = el.getTextContent();
                    }
                }
                el = DOMUtils.getNextElement((Element)el);
            }
            writer.writeStartElement(prefix, "RequestedSecurityToken", namespace);
            SecurityContextToken sct = new SecurityContextToken(SecureConversationTokenInterceptorProvider.getWSCVersion(tokenType), writer.getDocument());
            Calendar created = Calendar.getInstance();
            Calendar expires = Calendar.getInstance();
            expires.setTimeInMillis(System.currentTimeMillis() + (long)ttl);
            SecurityToken token = new SecurityToken(sct.getIdentifier(), created, expires);
            token.setToken(sct.getElement());
            token.setTokenType("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            writer.getCurrentNode().appendChild(sct.getElement());
            writer.writeEndElement();
            writer.writeStartElement(prefix, "RequestedAttachedReference", namespace);
            token.setAttachedReference(SecureConversationTokenInterceptorProvider.writeSecurityTokenReference(writer, "#" + sct.getID(), tokenType));
            writer.writeEndElement();
            writer.writeStartElement(prefix, "RequestedUnattachedReference", namespace);
            token.setUnattachedReference(SecureConversationTokenInterceptorProvider.writeSecurityTokenReference(writer, sct.getIdentifier(), tokenType));
            writer.writeEndElement();
            XmlSchemaDateFormat fmt = new XmlSchemaDateFormat();
            writer.writeStartElement(prefix, "Lifetime", namespace);
            writer.writeNamespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            writer.writeStartElement("wsu", "Created", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            writer.writeCharacters(fmt.format(created.getTime()));
            writer.writeEndElement();
            writer.writeStartElement("wsu", "Expires", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            writer.writeCharacters(fmt.format(expires.getTime()));
            writer.writeEndElement();
            writer.writeEndElement();
            byte[] secret = SecureConversationTokenInterceptorProvider.writeProofToken(prefix, namespace, writer, clientEntropy, keySize);
            token.setSecret(secret);
            ((TokenStore)((Endpoint)exchange.get(Endpoint.class)).getEndpointInfo().getProperty(TokenStore.class.getName())).add(token);
        }

        private SecurityToken findCancelToken(Exchange exchange, Element el) throws WSSecurityException {
            SecurityTokenReference ref = new SecurityTokenReference(DOMUtils.getFirstElement((Node)el));
            String uri = ref.getReference().getURI();
            TokenStore store = (TokenStore)((Endpoint)exchange.get(Endpoint.class)).getEndpointInfo().getProperty(TokenStore.class.getName());
            return store.getToken(uri);
        }
    }
}

