/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.spi.invocation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InterceptorBinding;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;

@ApplicationScoped
class DeltaSpikeProxyInterceptorLookup {
    private final Map<Method, List<Interceptor<?>>> cache = new HashMap();

    DeltaSpikeProxyInterceptorLookup() {
    }

    public List<Interceptor<?>> lookup(Object instance, Method method) {
        List<Interceptor<?>> interceptors = this.cache.get(method);
        if (interceptors == null) {
            interceptors = this.resolveInterceptors(instance, method);
            this.cache.put(method, interceptors);
        }
        return interceptors;
    }

    private List<Interceptor<?>> resolveInterceptors(Object instance, Method method) {
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        Annotation[] interceptorBindings = this.extractInterceptorBindings(beanManager, instance, method);
        if (interceptorBindings.length > 0) {
            return beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, interceptorBindings);
        }
        return new ArrayList();
    }

    private Annotation[] extractInterceptorBindings(BeanManager beanManager, Object instance, Method method) {
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        this.addInterceptorBindings(beanManager, bindings, instance.getClass().getDeclaredAnnotations());
        this.addInterceptorBindings(beanManager, bindings, method.getDeclaredAnnotations());
        return bindings.toArray(new Annotation[bindings.size()]);
    }

    private void addInterceptorBindings(BeanManager beanManager, ArrayList<Annotation> bindings, Annotation[] declaredAnnotations) {
        for (Annotation annotation : declaredAnnotations) {
            if (bindings.contains(annotation)) continue;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType.isAnnotationPresent(InterceptorBinding.class)) {
                bindings.add(annotation);
            }
            if (!beanManager.isStereotype(annotationType)) continue;
            for (Annotation subAnnotation : annotationType.getDeclaredAnnotations()) {
                if (bindings.contains(subAnnotation) || !subAnnotation.annotationType().isAnnotationPresent(InterceptorBinding.class)) continue;
                bindings.add(subAnnotation);
            }
        }
    }
}

