/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.proxy.asm.AnnotationVisitor;
import org.apache.deltaspike.proxy.asm.ClassReader;
import org.apache.deltaspike.proxy.asm.ClassVisitor;
import org.apache.deltaspike.proxy.asm.ClassWriter;
import org.apache.deltaspike.proxy.asm.Label;
import org.apache.deltaspike.proxy.asm.Type;
import org.apache.deltaspike.proxy.asm.commons.GeneratorAdapter;
import org.apache.deltaspike.proxy.asm.commons.Method;
import org.apache.deltaspike.proxy.impl.CopyAnnotationVisitorAdapter;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxy;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxyClassGenerator;
import org.apache.deltaspike.proxy.spi.invocation.DeltaSpikeProxyInvocationHandler;

@Typed
public class AsmDeltaSpikeProxyClassGenerator
implements DeltaSpikeProxyClassGenerator {
    private static final String FIELDNAME_INVOCATION_HANDLER = "invocationHandler";
    private static final String FIELDNAME_DELEGATE_INVOCATION_HANDLER = "delegateInvocationHandler";
    private static final String FIELDNAME_DELEGATE_METHODS = "delegateMethods";
    private static final Type TYPE_CLASS = Type.getType(Class.class);
    private static final Type TYPE_OBJECT = Type.getType(Object.class);
    private static final Type TYPE_DELTA_SPIKE_PROXY_INVOCATION_HANDLER = Type.getType(DeltaSpikeProxyInvocationHandler.class);
    private static final Type TYPE_METHOD_ARRAY = Type.getType(java.lang.reflect.Method[].class);
    private static final Type TYPE_INVOCATION_HANDLER = Type.getType(InvocationHandler.class);

    public <T> Class<T> generateProxyClass(ClassLoader classLoader, Class<T> targetClass, String suffix, String superAccessorMethodSuffix, Class<?>[] additionalInterfaces, java.lang.reflect.Method[] delegateMethods, java.lang.reflect.Method[] interceptMethods) {
        String proxyName = targetClass.getName() + suffix;
        String classFileName = proxyName.replace('.', '/');
        byte[] proxyBytes = AsmDeltaSpikeProxyClassGenerator.generateProxyClassBytes(targetClass, classFileName, superAccessorMethodSuffix, additionalInterfaces, delegateMethods, interceptMethods);
        Class<?> proxyClass = AsmDeltaSpikeProxyClassGenerator.loadClass(classLoader, proxyName, proxyBytes, targetClass.getProtectionDomain());
        return proxyClass;
    }

    private static byte[] generateProxyClassBytes(Class<?> targetClass, String proxyName, String superAccessorMethodSuffix, Class<?>[] additionalInterfaces, java.lang.reflect.Method[] delegateMethods, java.lang.reflect.Method[] interceptMethods) {
        Class<Object> superClass = targetClass;
        String[] interfaces = new String[]{};
        if (targetClass.isInterface()) {
            superClass = Object.class;
            interfaces = new String[]{Type.getInternalName(targetClass)};
        }
        interfaces = Arrays.copyOf(interfaces, interfaces.length + 1);
        interfaces[interfaces.length - 1] = Type.getInternalName(DeltaSpikeProxy.class);
        if (additionalInterfaces != null && additionalInterfaces.length > 0) {
            interfaces = Arrays.copyOf(interfaces, interfaces.length + additionalInterfaces.length);
            for (int i = 0; i < additionalInterfaces.length; ++i) {
                interfaces[interfaces.length - 1 + i] = Type.getInternalName(additionalInterfaces[i]);
            }
        }
        Type superType = Type.getType(superClass);
        Type proxyType = Type.getObjectType(proxyName);
        final ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 33, proxyType.getInternalName(), null, superType.getInternalName(), interfaces);
        AsmDeltaSpikeProxyClassGenerator.defineDefaultConstructor(cw, proxyType, superType);
        AsmDeltaSpikeProxyClassGenerator.defineDeltaSpikeProxyFields(cw);
        AsmDeltaSpikeProxyClassGenerator.defineDeltaSpikeProxyMethods(cw, proxyType);
        if (delegateMethods != null) {
            for (java.lang.reflect.Method method : delegateMethods) {
                AsmDeltaSpikeProxyClassGenerator.defineMethod(cw, method, proxyType);
            }
        }
        if (interceptMethods != null) {
            for (java.lang.reflect.Method method : interceptMethods) {
                AsmDeltaSpikeProxyClassGenerator.defineSuperAccessorMethod(cw, method, superType, superAccessorMethodSuffix);
                AsmDeltaSpikeProxyClassGenerator.defineMethod(cw, method, proxyType);
            }
        }
        try {
            ClassVisitor cv = new ClassVisitor(327680){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return new CopyAnnotationVisitorAdapter(super.visitAnnotation(desc, visible), cw.visitAnnotation(desc, visible));
                }
            };
            String sourceClassFilename = targetClass.getName().replace('.', '/') + ".class";
            ClassReader cr = new ClassReader(targetClass.getClassLoader().getResourceAsStream(sourceClassFilename));
            cr.accept(cv, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cw.toByteArray();
    }

    private static void defineDefaultConstructor(ClassWriter cw, Type proxyType, Type superType) {
        GeneratorAdapter mg = new GeneratorAdapter(1, new Method("<init>", Type.VOID_TYPE, new Type[0]), null, null, cw);
        mg.visitCode();
        mg.loadThis();
        mg.invokeConstructor(superType, Method.getMethod("void <init> ()"));
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void defineDeltaSpikeProxyFields(ClassWriter cw) {
        cw.visitField(2, FIELDNAME_INVOCATION_HANDLER, TYPE_DELTA_SPIKE_PROXY_INVOCATION_HANDLER.getDescriptor(), null, null).visitEnd();
        cw.visitField(2, FIELDNAME_DELEGATE_INVOCATION_HANDLER, TYPE_INVOCATION_HANDLER.getDescriptor(), null, null).visitEnd();
        cw.visitField(2, FIELDNAME_DELEGATE_METHODS, TYPE_METHOD_ARRAY.getDescriptor(), null, null).visitEnd();
    }

    private static void defineDeltaSpikeProxyMethods(ClassWriter cw, Type proxyType) {
        try {
            Method asmMethod = Method.getMethod(DeltaSpikeProxy.class.getDeclaredMethod("setInvocationHandler", DeltaSpikeProxyInvocationHandler.class));
            GeneratorAdapter mg = new GeneratorAdapter(1, asmMethod, null, null, cw);
            mg.visitCode();
            mg.loadThis();
            mg.loadArg(0);
            mg.checkCast(TYPE_DELTA_SPIKE_PROXY_INVOCATION_HANDLER);
            mg.putField(proxyType, FIELDNAME_INVOCATION_HANDLER, TYPE_DELTA_SPIKE_PROXY_INVOCATION_HANDLER);
            mg.returnValue();
            mg.visitMaxs(2, 1);
            mg.visitEnd();
            asmMethod = Method.getMethod(DeltaSpikeProxy.class.getDeclaredMethod("getInvocationHandler", new Class[0]));
            mg = new GeneratorAdapter(1, asmMethod, null, null, cw);
            mg.visitCode();
            mg.loadThis();
            mg.getField(proxyType, FIELDNAME_INVOCATION_HANDLER, TYPE_DELTA_SPIKE_PROXY_INVOCATION_HANDLER);
            mg.returnValue();
            mg.visitMaxs(2, 1);
            mg.visitEnd();
            asmMethod = Method.getMethod(DeltaSpikeProxy.class.getDeclaredMethod("setDelegateInvocationHandler", InvocationHandler.class));
            mg = new GeneratorAdapter(1, asmMethod, null, null, cw);
            mg.visitCode();
            mg.loadThis();
            mg.loadArg(0);
            mg.checkCast(TYPE_INVOCATION_HANDLER);
            mg.putField(proxyType, FIELDNAME_DELEGATE_INVOCATION_HANDLER, TYPE_INVOCATION_HANDLER);
            mg.returnValue();
            mg.visitMaxs(2, 1);
            mg.visitEnd();
            asmMethod = Method.getMethod(DeltaSpikeProxy.class.getDeclaredMethod("getDelegateInvocationHandler", new Class[0]));
            mg = new GeneratorAdapter(1, asmMethod, null, null, cw);
            mg.visitCode();
            mg.loadThis();
            mg.getField(proxyType, FIELDNAME_DELEGATE_INVOCATION_HANDLER, TYPE_INVOCATION_HANDLER);
            mg.returnValue();
            mg.visitMaxs(2, 1);
            mg.visitEnd();
            asmMethod = Method.getMethod(DeltaSpikeProxy.class.getDeclaredMethod("setDelegateMethods", java.lang.reflect.Method[].class));
            mg = new GeneratorAdapter(1, asmMethod, null, null, cw);
            mg.visitCode();
            mg.loadThis();
            mg.loadArg(0);
            mg.checkCast(TYPE_METHOD_ARRAY);
            mg.putField(proxyType, FIELDNAME_DELEGATE_METHODS, TYPE_METHOD_ARRAY);
            mg.returnValue();
            mg.visitMaxs(2, 1);
            mg.visitEnd();
            asmMethod = Method.getMethod(DeltaSpikeProxy.class.getDeclaredMethod("getDelegateMethods", new Class[0]));
            mg = new GeneratorAdapter(1, asmMethod, null, null, cw);
            mg.visitCode();
            mg.loadThis();
            mg.getField(proxyType, FIELDNAME_DELEGATE_METHODS, TYPE_METHOD_ARRAY);
            mg.returnValue();
            mg.visitMaxs(2, 1);
            mg.visitEnd();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to implement " + DeltaSpikeProxy.class.getName(), e);
        }
    }

    private static void defineSuperAccessorMethod(ClassWriter cw, java.lang.reflect.Method method, Type superType, String superAccessorMethodSuffix) {
        Method originalAsmMethod = Method.getMethod(method);
        Method newAsmMethod = new Method(method.getName() + superAccessorMethodSuffix, originalAsmMethod.getReturnType(), originalAsmMethod.getArgumentTypes());
        GeneratorAdapter mg = new GeneratorAdapter(1, newAsmMethod, null, null, cw);
        mg.visitCode();
        mg.loadThis();
        mg.loadArgs();
        mg.visitMethodInsn(183, superType.getInternalName(), method.getName(), Type.getMethodDescriptor(method), false);
        mg.returnValue();
        mg.endMethod();
        mg.visitMaxs(10, 10);
        mg.visitEnd();
    }

    private static void defineMethod(ClassWriter cw, java.lang.reflect.Method method, Type proxyType) {
        Type methodType = Type.getType(method);
        ArrayList<Type> exceptionsToCatch = new ArrayList<Type>();
        for (Class<?> clazz : method.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(clazz)) continue;
            exceptionsToCatch.add(Type.getType(clazz));
        }
        int modifiers = 5 & method.getModifiers();
        Method asmMethod = Method.getMethod(method);
        GeneratorAdapter mg = new GeneratorAdapter(modifiers, asmMethod, null, AsmDeltaSpikeProxyClassGenerator.getTypes(method.getExceptionTypes()), cw);
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            mg.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true).visitEnd();
        }
        mg.visitCode();
        Label label = mg.mark();
        mg.loadThis();
        mg.getField(proxyType, FIELDNAME_INVOCATION_HANDLER, TYPE_DELTA_SPIKE_PROXY_INVOCATION_HANDLER);
        mg.loadThis();
        AsmDeltaSpikeProxyClassGenerator.loadCurrentMethod(mg, method, methodType);
        AsmDeltaSpikeProxyClassGenerator.loadArguments(mg, method, methodType);
        mg.invokeVirtual(TYPE_DELTA_SPIKE_PROXY_INVOCATION_HANDLER, Method.getMethod("Object invoke(Object, java.lang.reflect.Method, Object[])"));
        mg.unbox(methodType.getReturnType());
        Label tryBlockEnd = mg.mark();
        mg.returnValue();
        Label rethrow = mg.mark();
        mg.visitVarInsn(58, 1);
        mg.visitVarInsn(25, 1);
        mg.throwException();
        mg.visitTryCatchBlock(label, tryBlockEnd, rethrow, Type.getInternalName(RuntimeException.class));
        boolean throwableCatched = false;
        if (!exceptionsToCatch.isEmpty()) {
            rethrow = mg.mark();
            mg.visitVarInsn(58, 1);
            mg.visitVarInsn(25, 1);
            mg.throwException();
            for (Type exceptionType : exceptionsToCatch) {
                if (exceptionType.getClassName().equals(Throwable.class.getName())) {
                    throwableCatched = true;
                }
                mg.visitTryCatchBlock(label, tryBlockEnd, rethrow, exceptionType.getInternalName());
            }
        }
        if (!throwableCatched) {
            Type uteType = Type.getType(UndeclaredThrowableException.class);
            Label wrapAndRethrow = mg.mark();
            mg.visitVarInsn(58, 1);
            mg.newInstance(uteType);
            mg.dup();
            mg.visitVarInsn(25, 1);
            mg.invokeConstructor(uteType, Method.getMethod("void <init>(java.lang.Throwable)"));
            mg.throwException();
            mg.visitTryCatchBlock(label, tryBlockEnd, wrapAndRethrow, Type.getInternalName(Throwable.class));
        }
        mg.endMethod();
        mg.visitMaxs(12, 12);
        mg.visitEnd();
    }

    private static void loadCurrentMethod(GeneratorAdapter mg, java.lang.reflect.Method method, Type methodType) {
        mg.push(Type.getType(method.getDeclaringClass()));
        mg.push(method.getName());
        mg.push(methodType.getArgumentTypes().length);
        mg.newArray(TYPE_CLASS);
        for (int i = 0; i < methodType.getArgumentTypes().length; ++i) {
            mg.dup();
            mg.push(i);
            mg.push(methodType.getArgumentTypes()[i]);
            mg.arrayStore(TYPE_CLASS);
        }
        mg.invokeVirtual(TYPE_CLASS, Method.getMethod("java.lang.reflect.Method getDeclaredMethod(String, Class[])"));
    }

    private static void loadArguments(GeneratorAdapter mg, java.lang.reflect.Method method, Type methodType) {
        mg.push(methodType.getArgumentTypes().length);
        mg.newArray(TYPE_OBJECT);
        for (int i = 0; i < methodType.getArgumentTypes().length; ++i) {
            mg.dup();
            mg.push(i);
            mg.loadArg(i);
            mg.valueOf(methodType.getArgumentTypes()[i]);
            mg.arrayStore(TYPE_OBJECT);
        }
    }

    private static Type[] getTypes(Class<?> ... src) {
        Type[] result = new Type[src.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Type.getType(src[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> loadClass(ClassLoader loader, String className, byte[] b, ProtectionDomain protectionDomain) {
        java.lang.reflect.Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
        boolean accessible = method.isAccessible();
        if (!accessible) {
            method.setAccessible(true);
        }
        try {
            Class clazz = (Class)method.invoke((Object)loader, className, b, 0, b.length, protectionDomain);
            if (!accessible) {
                method.setAccessible(false);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                if (!accessible) {
                    method.setAccessible(false);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        }
    }
}

