/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.DescriptionUtils;
import org.apache.directory.shared.ldap.schema.SchemaObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DITStructureRule
extends AbstractSchemaObject {
    private static final long serialVersionUID = 1L;
    private int ruleId;
    private String form;
    private List<Integer> superRules;

    public DITStructureRule(int ruleId) {
        super(SchemaObjectType.DIT_STRUCTURE_RULE, null);
        this.ruleId = ruleId;
        this.form = null;
        this.superRules = new ArrayList<Integer>();
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((String)"ERR_04441", (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.form = form;
        }
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(int ruleId) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((String)"ERR_04441", (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.ruleId = ruleId;
        }
    }

    public List<Integer> getSuperRules() {
        return this.superRules;
    }

    public void setSuperRules(List<Integer> superRules) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((String)"ERR_04441", (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.superRules = superRules;
        }
    }

    public void addSuperRule(Integer superRule) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((String)"ERR_04441", (Object[])new Object[]{this.getName()}));
        }
        this.superRules.add(superRule);
    }

    @Override
    public String getOid() {
        throw new NotImplementedException();
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    @Override
    public DITStructureRule copy() {
        DITStructureRule copy = new DITStructureRule(this.ruleId);
        copy.copy(this);
        copy.superRules = new ArrayList<Integer>();
        copy.form = this.form;
        for (int ruleId : this.superRules) {
            copy.superRules.add(ruleId);
        }
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof DITStructureRule)) {
            return false;
        }
        DITStructureRule that = (DITStructureRule)o;
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.superRules.clear();
    }
}

