/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.DescriptionUtils;
import org.apache.directory.shared.ldap.schema.LoadableSchemaObject;
import org.apache.directory.shared.ldap.schema.SchemaObjectType;

public abstract class SyntaxChecker
extends LoadableSchemaObject {
    private static final long serialVersionUID = 1L;

    protected SyntaxChecker(String oid) {
        super(SchemaObjectType.SYNTAX_CHECKER, oid);
    }

    protected SyntaxChecker() {
        super(SchemaObjectType.SYNTAX_CHECKER);
    }

    public abstract boolean isValidSyntax(Object var1);

    public void assertSyntax(Object value) throws LdapException {
        if (!this.isValidSyntax(value)) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return o instanceof SyntaxChecker;
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }
}

