/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(IntegerSyntaxChecker.class);
    private static final long serialVersionUID = 1L;

    public IntegerSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.27");
    }

    public boolean isValidSyntax(Object value) {
        boolean result;
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int pos = 0;
        char c = strValue.charAt(pos);
        if (c == '-') {
            pos = 1;
        } else {
            if (!StringTools.isDigit(c)) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            if (c == '0') {
                if (strValue.length() > 1) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                LOG.debug("Syntax valid for '{}'", value);
                return true;
            }
        }
        if (!StringTools.isDigit(strValue, pos)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (StringTools.isCharASCII(strValue, pos, '0')) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        ++pos;
        while (StringTools.isDigit(strValue, pos)) {
            ++pos;
        }
        boolean bl = result = pos == strValue.length();
        if (result) {
            LOG.debug("Syntax valid for '{}'", value);
        } else {
            LOG.debug("Syntax invalid for '{}'", value);
        }
        return result;
    }
}

