/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FormatDescriptorValidator;

@Internal
public class AvroValidator
extends FormatDescriptorValidator {
    public static final String FORMAT_TYPE_VALUE = "avro";
    public static final String FORMAT_RECORD_CLASS = "format.record-class";
    public static final String FORMAT_AVRO_SCHEMA = "format.avro-schema";

    public void validate(DescriptorProperties properties) {
        super.validate(properties);
        boolean hasRecordClass = properties.containsKey(FORMAT_RECORD_CLASS);
        boolean hasAvroSchema = properties.containsKey(FORMAT_AVRO_SCHEMA);
        if (hasRecordClass && hasAvroSchema) {
            throw new ValidationException("A definition of both a schema and Avro schema is not allowed.");
        }
        if (hasRecordClass) {
            properties.validateString(FORMAT_RECORD_CLASS, false, 1);
        } else if (hasAvroSchema) {
            properties.validateString(FORMAT_AVRO_SCHEMA, false, 1);
        } else {
            throw new ValidationException("A definition of an Avro specific record class or Avro schema is required.");
        }
    }
}

