/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.util.Preconditions;

@Internal
public final class ComparableTypeStrategy
implements InputTypeStrategy {
    private final StructuredType.StructuredComparison requiredComparison;
    private final ConstantArgumentCount argumentCount;

    public ComparableTypeStrategy(ConstantArgumentCount argumentCount, StructuredType.StructuredComparison requiredComparison) {
        Preconditions.checkArgument((boolean)argumentCount.getMinCount().map(c -> c >= 1).orElse(false), (String)"Comparable type strategy requires at least one argument. Actual minimal argument count: %s", (Object[])new Object[]{argumentCount.getMinCount().map(Objects::toString).orElse("<None>")});
        Preconditions.checkArgument((requiredComparison != StructuredType.StructuredComparison.NONE ? 1 : 0) != 0);
        this.requiredComparison = requiredComparison;
        this.argumentCount = argumentCount;
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return this.argumentCount;
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (argumentDataTypes.size() == 1) {
            LogicalType argType = argumentDataTypes.get(0).getLogicalType();
            if (!this.areComparable(argType, argType)) {
                return callContext.fail(throwOnFailure, "Type '%s' should support %s comparison with itself.", argType, this.comparisonToString());
            }
        } else {
            for (int i = 0; i < argumentDataTypes.size() - 1; ++i) {
                LogicalType secondType;
                LogicalType firstType = argumentDataTypes.get(i).getLogicalType();
                if (this.areComparable(firstType, secondType = argumentDataTypes.get(i + 1).getLogicalType())) continue;
                return callContext.fail(throwOnFailure, "All types in a comparison should support %s comparison with each other. Can not compare %s with %s", this.comparisonToString(), firstType, secondType);
            }
        }
        return Optional.of(argumentDataTypes);
    }

    private String comparisonToString() {
        return this.requiredComparison == StructuredType.StructuredComparison.EQUALS ? "'EQUALS'" : "both 'EQUALS' and 'ORDER'";
    }

    private boolean areComparable(LogicalType firstType, LogicalType secondType) {
        return this.areComparableWithNormalizedNullability(firstType.copy(true), secondType.copy(true));
    }

    private boolean areComparableWithNormalizedNullability(LogicalType firstType, LogicalType secondType) {
        if (firstType instanceof LegacyTypeInformationType || secondType instanceof LegacyTypeInformationType) {
            return true;
        }
        if (firstType.is(LogicalTypeRoot.NULL) || secondType.is(LogicalTypeRoot.NULL)) {
            return true;
        }
        if (firstType.getTypeRoot() == secondType.getTypeRoot()) {
            return this.areTypesOfSameRootComparable(firstType, secondType);
        }
        if (firstType.is(LogicalTypeFamily.NUMERIC) && secondType.is(LogicalTypeFamily.NUMERIC)) {
            return true;
        }
        if (firstType.is(LogicalTypeFamily.DATETIME) && secondType.is(LogicalTypeFamily.DATETIME)) {
            return true;
        }
        if (firstType.is(LogicalTypeFamily.CHARACTER_STRING) && secondType.is(LogicalTypeFamily.CHARACTER_STRING)) {
            return true;
        }
        return firstType.is(LogicalTypeFamily.BINARY_STRING) && secondType.is(LogicalTypeFamily.BINARY_STRING);
    }

    private boolean areTypesOfSameRootComparable(LogicalType firstType, LogicalType secondType) {
        switch (firstType.getTypeRoot()) {
            case ARRAY: 
            case MULTISET: 
            case MAP: 
            case ROW: {
                return this.areConstructedTypesComparable(firstType, secondType);
            }
            case DISTINCT_TYPE: {
                return this.areDistinctTypesComparable(firstType, secondType);
            }
            case STRUCTURED_TYPE: {
                return this.areStructuredTypesComparable(firstType, secondType);
            }
            case RAW: {
                return this.areRawTypesComparable(firstType, secondType);
            }
        }
        return true;
    }

    private boolean areRawTypesComparable(LogicalType firstType, LogicalType secondType) {
        return firstType.equals(secondType) && Comparable.class.isAssignableFrom(((RawType)firstType).getOriginatingClass());
    }

    private boolean areDistinctTypesComparable(LogicalType firstType, LogicalType secondType) {
        DistinctType firstDistinctType = (DistinctType)firstType;
        DistinctType secondDistinctType = (DistinctType)secondType;
        return firstType.equals(secondType) && this.areComparable(firstDistinctType.getSourceType(), secondDistinctType.getSourceType());
    }

    private boolean areStructuredTypesComparable(LogicalType firstType, LogicalType secondType) {
        return firstType.equals(secondType) && this.hasRequiredComparison((StructuredType)firstType) != false;
    }

    private boolean areConstructedTypesComparable(LogicalType firstType, LogicalType secondType) {
        List<LogicalType> firstChildren = firstType.getChildren();
        List<LogicalType> secondChildren = secondType.getChildren();
        if (firstChildren.size() != secondChildren.size()) {
            return false;
        }
        for (int i = 0; i < firstChildren.size(); ++i) {
            if (this.areComparable(firstChildren.get(i), secondChildren.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.ofGroupVarying("COMPARABLE")));
    }

    private Boolean hasRequiredComparison(StructuredType structuredType) {
        switch (this.requiredComparison) {
            case EQUALS: {
                return structuredType.getComparison().isEquality();
            }
            case FULL: {
                return structuredType.getComparison().isComparison();
            }
        }
        return true;
    }
}

