/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFormXObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public abstract class AbstractPDFBoxHandler {
    protected static Log log = LogFactory.getLog((Class)AbstractPDFBoxHandler.class);
    private static Map objectCaches = Collections.synchronizedMap(new WeakHashMap());

    protected PDFFormXObject createFormForPDF(ImagePDF image, PDFPage targetPage) throws IOException {
        int selectedPage = ImageUtil.needPageIndexFromURI((String)image.getInfo().getOriginalURI());
        PDDocument pddoc = image.getPDDocument();
        float pdfVersion = pddoc.getDocument().getVersion();
        if (pdfVersion > 1.4f) {
            log.warn((Object)("The version of the loaded PDF is " + pdfVersion + ". PDF Versions beyond 1.4 might not create correct results."));
        }
        if (pddoc.isEncrypted() && pddoc.getCurrentAccessPermission().isOwnerPermission()) {
            log.error((Object)"PDF to be embedded must not be encrypted! Alternative: provide authentication via interceptor.");
            return null;
        }
        PDFDocument pdfDoc = targetPage.getDocument();
        if (pdfDoc.getProfile().isPDFAActive()) {
            log.warn((Object)"PDF/A mode is active. Embedding a PDF file may result in a non-compliant file!");
        }
        if (pdfDoc.getProfile().isPDFXActive()) {
            log.warn((Object)"PDF/X mode is active. Embedding a PDF file may result in a non-compliant file!");
        }
        PDPage page = (PDPage)pddoc.getDocumentCatalog().getAllPages().get(selectedPage);
        MapKey key = new MapKey(pddoc, pdfDoc);
        HashMap objectCache = (HashMap)objectCaches.get(key);
        if (objectCache == null) {
            objectCache = new HashMap();
            objectCaches.put(key, objectCache);
        }
        PDFBoxAdapter adapter = new PDFBoxAdapter(targetPage, objectCache);
        PDFFormXObject form = adapter.createFormFromPDFBoxPage(pddoc, page, image.getInfo().getOriginalURI());
        return form;
    }

    private static final class MapKey {
        private PDDocument sourceDocument;
        private PDFDocument targetDocument;

        public MapKey(PDDocument source, PDFDocument target) {
            this.sourceDocument = source;
            this.targetDocument = target;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.sourceDocument.hashCode();
            result = 31 * result + this.targetDocument.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapKey other = (MapKey)obj;
            return this.sourceDocument == other.sourceDocument && this.targetDocument == other.targetDocument;
        }
    }
}

