/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFormXObject;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.pdf.pdfbox.PDFBoolean;
import org.apache.fop.render.pdf.pdfbox.PDFString;
import org.apache.fop.render.pdf.pdfbox.PDFUtil;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageNode;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.COSStreamArray;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

class PDFBoxAdapter {
    protected static Log log = LogFactory.getLog((Class)PDFBoxAdapter.class);
    private static final Set filterFilter = new HashSet<String>(Arrays.asList("Filter", "DecodeParms"));
    private static final Set page2form = new HashSet<String>(Arrays.asList("Group", "LastModified", "Metadata"));
    private final PDFPage targetPage;
    private final PDFDocument pdfDoc;
    private final Map clonedVersion;

    public PDFBoxAdapter(PDFPage targetPage, Map objectCache) {
        this.targetPage = targetPage;
        this.pdfDoc = this.targetPage.getDocument();
        this.clonedVersion = objectCache;
    }

    private Object cloneForNewDocument(Object base) throws IOException {
        return this.cloneForNewDocument(base, base);
    }

    private Object cloneForNewDocument(Object base, Object keyBase) throws IOException {
        return this.cloneForNewDocument(base, keyBase, Collections.EMPTY_LIST);
    }

    private Object cloneForNewDocument(Object base, Object keyBase, Collection exclude) throws IOException {
        if (base == null) {
            return null;
        }
        Object cached = this.getCachedClone(keyBase);
        if (cached != null) {
            return cached;
        }
        if (base instanceof List) {
            PDFArray array = new PDFArray();
            this.cacheClonedObject(keyBase, array);
            List list = (List)base;
            for (int i = 0; i < list.size(); ++i) {
                array.add(this.cloneForNewDocument(list.get(i)));
            }
            return array;
        }
        if (base instanceof COSObjectable && !(base instanceof COSBase)) {
            COSBase o = ((COSObjectable)base).getCOSObject();
            Object retval = this.cloneForNewDocument(o, o, exclude);
            return this.cacheClonedObject(keyBase, retval);
        }
        if (base instanceof COSObject) {
            Object obj;
            COSObject object = (COSObject)base;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Cloning indirect object: " + object.getObjectNumber().longValue() + " " + object.getGenerationNumber().longValue()));
            }
            if ((obj = this.cloneForNewDocument(object.getObject(), object)) instanceof PDFObject) {
                PDFObject pdfobj = (PDFObject)obj;
                if (!pdfobj.hasObjectNumber()) {
                    throw new IllegalStateException("PDF object was not registered!");
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Object registered: " + pdfobj.getObjectNumber() + " " + pdfobj.getGeneration() + " for COSObject: " + object.getObjectNumber().longValue() + " " + object.getGenerationNumber().longValue()));
                }
            } else {
                throw new IllegalStateException("Expected to get a PDFObject but got" + (obj != null ? " a " + obj.getClass().getName() : " null") + " for " + object);
            }
            if (this.getCachedClone(keyBase) == null) {
                throw new IllegalStateException("Object must be cached at this point: " + keyBase);
            }
            return obj;
        }
        if (base instanceof COSArray) {
            PDFArray newArray = new PDFArray();
            this.cacheClonedObject(keyBase, newArray);
            COSArray array = (COSArray)base;
            for (int i = 0; i < array.size(); ++i) {
                newArray.add(this.cloneForNewDocument(array.get(i)));
            }
            return newArray;
        }
        if (base instanceof COSStreamArray) {
            COSStreamArray array = (COSStreamArray)base;
            PDFArray newArray = new PDFArray();
            this.cacheClonedObject(keyBase, newArray);
            int c = array.getStreamCount();
            for (int i = 0; i < c; ++i) {
                newArray.add(this.cloneForNewDocument(array.get(i)));
            }
            return newArray;
        }
        if (base instanceof COSStream) {
            Set filter;
            InputStream in;
            COSStream originalStream = (COSStream)base;
            PDFStream stream = new PDFStream();
            if (this.pdfDoc.isEncryptionActive()) {
                in = originalStream.getUnfilteredStream();
                filter = filterFilter;
            } else {
                in = originalStream.getFilteredStream();
                filter = Collections.EMPTY_SET;
            }
            OutputStream out = stream.getBufferOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            this.transferDict((COSDictionary)originalStream, (PDFDictionary)stream, filter);
            return this.cacheClonedObject(keyBase, stream);
        }
        if (base instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)base;
            PDFDictionary newDict = new PDFDictionary();
            this.cacheClonedObject(keyBase, newDict);
            Iterator iter = dic.keySet().iterator();
            while (iter.hasNext()) {
                COSName key = (COSName)iter.next();
                if (exclude.contains(key)) continue;
                newDict.put(key.getName(), this.cloneForNewDocument(dic.getItem(key)));
            }
            return newDict;
        }
        if (base instanceof COSName) {
            PDFName newName = new PDFName(((COSName)base).getName());
            return this.cacheClonedObject(keyBase, newName);
        }
        if (base instanceof COSInteger) {
            PDFNumber number = new PDFNumber();
            number.setNumber((Number)new Long(((COSInteger)base).longValue()));
            return this.cacheClonedObject(keyBase, number);
        }
        if (base instanceof COSFloat) {
            PDFNumber number = new PDFNumber();
            number.setNumber((Number)new Float(((COSFloat)base).floatValue()));
            return this.cacheClonedObject(keyBase, number);
        }
        if (base instanceof COSBoolean) {
            Boolean retval = ((COSBoolean)base).getValueAsObject();
            if (keyBase instanceof COSObject) {
                return this.cacheClonedObject(keyBase, (Object)new PDFBoolean(retval));
            }
            return this.cacheClonedObject(keyBase, retval);
        }
        if (base instanceof COSString) {
            COSString string = (COSString)base;
            byte[] bytes = string.getBytes();
            if (keyBase instanceof COSObject) {
                return this.cacheClonedObject(keyBase, (Object)new PDFString(bytes));
            }
            if (PDFString.isUSASCII(bytes)) {
                return this.cacheClonedObject(keyBase, string.getString());
            }
            return this.cacheClonedObject(keyBase, bytes);
        }
        if (base instanceof COSNull) {
            return this.cacheClonedObject(keyBase, null);
        }
        throw new UnsupportedOperationException("NYI: " + base.getClass().getName());
    }

    private Object getCachedClone(Object base) {
        return this.clonedVersion.get(this.getBaseKey(base));
    }

    private Object cacheClonedObject(Object base, Object cloned) {
        Object key = this.getBaseKey(base);
        if (base instanceof COSObject) {
            PDFObject pdfobj = (PDFObject)cloned;
            if (!pdfobj.hasObjectNumber()) {
                this.pdfDoc.registerObject(pdfobj);
                if (log.isTraceEnabled()) {
                    log.trace((Object)(key + ": " + pdfobj.getClass().getName() + " registered as " + pdfobj.getObjectNumber() + " " + pdfobj.getGeneration()));
                }
            }
        } else if (log.isTraceEnabled()) {
            // empty if block
        }
        this.clonedVersion.put(key, cloned);
        return cloned;
    }

    private Object getBaseKey(Object base) {
        if (base instanceof COSObject) {
            COSObject obj = (COSObject)base;
            return obj.getObjectNumber().intValue() + " " + obj.getGenerationNumber().intValue();
        }
        return base;
    }

    private void transferDict(COSDictionary orgDict, PDFDictionary targetDict, Set filter) throws IOException {
        this.transferDict(orgDict, targetDict, filter, false);
    }

    private void transferDict(COSDictionary orgDict, PDFDictionary targetDict, Set filter, boolean inclusive) throws IOException {
        Iterator iter = orgDict.keySet().iterator();
        while (iter.hasNext()) {
            COSName key = (COSName)iter.next();
            if (inclusive && !filter.contains(key.getName()) || !inclusive && filter.contains(key.getName())) continue;
            targetDict.put(key.getName(), this.cloneForNewDocument(orgDict.getItem(key)));
        }
    }

    public PDFFormXObject createFormFromPDFBoxPage(PDDocument sourceDoc, PDPage page, String key) throws IOException {
        Set filter;
        PDFStream pageStream;
        this.handleAcroForm(sourceDoc, page);
        PDResources sourcePageResources = page.findResources();
        PDFDictionary pageResources = null;
        if (sourcePageResources != null) {
            pageResources = (PDFDictionary)this.cloneForNewDocument(sourcePageResources.getCOSDictionary());
            this.pdfDoc.registerObject((PDFObject)pageResources);
        }
        COSStream originalPageContents = null;
        PDStream pdStream = page.getContents();
        if (pdStream != null) {
            originalPageContents = (COSStream)pdStream.getCOSObject();
        }
        if (originalPageContents instanceof COSStreamArray) {
            COSStreamArray array = (COSStreamArray)originalPageContents;
            pageStream = new PDFStream();
            InputStream in = array.getUnfilteredStream();
            OutputStream out = pageStream.getBufferOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            filter = filterFilter;
        } else {
            pageStream = (PDFStream)this.cloneForNewDocument(originalPageContents);
            filter = Collections.EMPTY_SET;
        }
        if (pageStream == null) {
            pageStream = new PDFStream();
        }
        PDFFormXObject form = this.pdfDoc.addFormXObject(null, pageStream, pageResources != null ? pageResources.makeReference() : null, key);
        if (originalPageContents != null) {
            this.transferDict((COSDictionary)originalPageContents, (PDFDictionary)form, filter);
        }
        this.transferDict(page.getCOSDictionary(), (PDFDictionary)form, page2form, true);
        AffineTransform at = form.getMatrix();
        PDRectangle mediaBox = page.findMediaBox();
        PDRectangle cropBox = page.findCropBox();
        PDRectangle viewBox = cropBox != null ? cropBox : mediaBox;
        int rotation = PDFUtil.getNormalizedRotation(page);
        at.scale(1.0f / viewBox.getWidth(), 1.0f / viewBox.getHeight());
        at.translate(mediaBox.getLowerLeftX() - viewBox.getLowerLeftX(), mediaBox.getLowerLeftY() - viewBox.getLowerLeftY());
        switch (rotation) {
            case 90: {
                at.scale(viewBox.getWidth() / viewBox.getHeight(), viewBox.getHeight() / viewBox.getWidth());
                at.translate(0.0, viewBox.getWidth());
                at.rotate(-1.5707963267948966);
                break;
            }
            case 180: {
                at.translate(viewBox.getWidth(), viewBox.getHeight());
                at.rotate(-Math.PI);
                break;
            }
            case 270: {
                at.scale(viewBox.getWidth() / viewBox.getHeight(), viewBox.getHeight() / viewBox.getWidth());
                at.translate(viewBox.getHeight(), 0.0);
                at.rotate(-4.71238898038469);
            }
        }
        at.translate(-viewBox.getLowerLeftX(), -viewBox.getLowerLeftY());
        form.setMatrix(at);
        form.setBBox((Rectangle2D)new Rectangle2D.Float(viewBox.getLowerLeftX(), viewBox.getLowerLeftY(), viewBox.getUpperRightX(), viewBox.getUpperRightY()));
        return form;
    }

    private List getWidgets(PDPage page) throws IOException {
        List annots = page.getAnnotations();
        ArrayList<PDAnnotation> widgets = new ArrayList<PDAnnotation>();
        Iterator iter = annots.iterator();
        while (iter.hasNext()) {
            PDAnnotation annot = (PDAnnotation)iter.next();
            if (!annot.getSubtype().equals("Widget")) continue;
            widgets.add(annot);
        }
        return widgets;
    }

    private void handleAcroForm(PDDocument sourceDoc, PDPage page) throws IOException {
        PDFArray clonedFields;
        Iterator iter;
        PDDocumentCatalog srcCatalog = sourceDoc.getDocumentCatalog();
        PDAcroForm srcAcroForm = srcCatalog.getAcroForm();
        List pageWidgets = this.getWidgets(page);
        if (srcAcroForm == null && pageWidgets.isEmpty()) {
            return;
        }
        COSObject cosPage = null;
        if (page.getCOSObject() instanceof COSObject) {
            cosPage = (COSObject)page.getCOSObject();
        } else {
            PDPageNode pageNode = page.getParent();
            COSArray kids = (COSArray)pageNode.getDictionary().getDictionaryObject(COSName.KIDS);
            iter = kids.iterator();
            while (iter.hasNext()) {
                COSObject kid = (COSObject)iter.next();
                if (kid.getObject() != page.getCOSObject()) continue;
                cosPage = kid;
                break;
            }
            if (cosPage == null) {
                throw new IOException("Illegal PDF. Page not part of parent page node.");
            }
        }
        this.cacheClonedObject(cosPage, this.targetPage);
        COSArray annots = (COSArray)page.getCOSDictionary().getDictionaryObject(COSName.ANNOTS);
        HashSet<COSDictionary> fields = Collections.EMPTY_SET;
        if (annots != null) {
            fields = new HashSet<COSDictionary>();
            iter = annots.iterator();
            while (iter.hasNext()) {
                COSDictionary parent;
                COSBase annot = (COSBase)iter.next();
                COSObject cosAnnot = (COSObject)annot.getCOSObject();
                COSDictionary field = (COSDictionary)cosAnnot.getObject();
                if (!"Widget".equals(field.getNameAsString(COSName.SUBTYPE))) continue;
                while ((parent = (COSDictionary)field.getDictionaryObject(COSName.PARENT)) != null) {
                    field = parent;
                }
                fields.add(field);
                List<COSName> exclude = Collections.singletonList(COSName.P);
                PDFObject clonedAnnot = (PDFObject)this.cloneForNewDocument(cosAnnot.getObject(), cosAnnot, exclude);
                this.targetPage.addAnnotation(clonedAnnot);
            }
        }
        boolean formAlreadyCopied = this.getCachedClone(srcAcroForm) != null;
        PDFRoot catalog = this.pdfDoc.getRoot();
        PDFDictionary destAcroForm = (PDFDictionary)catalog.get(COSName.ACRO_FORM.getName());
        if (!formAlreadyCopied && destAcroForm == null) {
            if (srcAcroForm != null) {
                List<COSName> exclude = Collections.singletonList(COSName.FIELDS);
                destAcroForm = (PDFDictionary)this.cloneForNewDocument(srcAcroForm, srcAcroForm, exclude);
            } else {
                destAcroForm = new PDFDictionary((PDFObject)this.pdfDoc.getRoot());
            }
            this.pdfDoc.registerObject((PDFObject)destAcroForm);
            catalog.put(COSName.ACRO_FORM.getName(), (Object)destAcroForm);
        }
        if ((clonedFields = (PDFArray)destAcroForm.get(COSName.FIELDS.getName())) == null) {
            clonedFields = new PDFArray();
            destAcroForm.put(COSName.FIELDS.getName(), (Object)clonedFields);
        }
        Iterator iter2 = fields.iterator();
        while (iter2.hasNext()) {
            COSDictionary field = (COSDictionary)iter2.next();
            PDFDictionary clone = (PDFDictionary)this.cloneForNewDocument(field);
            this.pdfDoc.registerObject((PDFObject)clone);
            clonedFields.add((Object)clone);
        }
    }
}

