/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Rectangle;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFFormXObject;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.fop.render.pdf.pdfbox.AbstractPDFBoxHandler;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;

public class PDFBoxImageHandler
extends AbstractPDFBoxHandler
implements ImageHandler {
    protected static Log log = LogFactory.getLog((Class)PDFBoxImageHandler.class);
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImagePDF.PDFBOX_IMAGE};

    public void handleImage(RenderingContext context, Image image, Rectangle pos) throws IOException {
        PDFRenderingContext pdfContext = (PDFRenderingContext)context;
        PDFContentGenerator generator = pdfContext.getGenerator();
        ImagePDF pdfImage = (ImagePDF)image;
        PDFFormXObject form = this.createFormForPDF(pdfImage, pdfContext.getPage());
        if (form == null) {
            return;
        }
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        generator.placeImage(x, y, w, h, (PDFXObject)form);
    }

    public boolean isCompatible(RenderingContext targetContext, Image image) {
        return (image == null || image instanceof ImagePDF) && targetContext instanceof PDFRenderingContext;
    }

    public int getPriority() {
        return 50;
    }

    public Class getSupportedImageClass() {
        return ImagePDF.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }
}

