/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMapFile {
    private static final Path TEST_DIR = new Path(GenericTestUtils.getTempPath(TestMapFile.class.getSimpleName()));
    private static Configuration conf = new Configuration();
    private static final Progressable defaultProgressable = new Progressable(){

        public void progress() {
        }
    };
    private static final CompressionCodec defaultCodec = new CompressionCodec(){

        public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
            return (CompressionOutputStream)Mockito.mock(CompressionOutputStream.class);
        }

        public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
            return (CompressionOutputStream)Mockito.mock(CompressionOutputStream.class);
        }

        public Class<? extends Compressor> getCompressorType() {
            return null;
        }

        public Compressor createCompressor() {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in) throws IOException {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
            return null;
        }

        public Class<? extends Decompressor> getDecompressorType() {
            return null;
        }

        public Decompressor createDecompressor() {
            return null;
        }

        public String getDefaultExtension() {
            return null;
        }
    };

    @Before
    public void setup() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(TEST_DIR) && !fs.delete(TEST_DIR, true)) {
            Assert.fail((String)"Can't clean up test root dir");
        }
        fs.mkdirs(TEST_DIR);
    }

    private MapFile.Writer createWriter(String fileName, Class<? extends WritableComparable<?>> keyClass, Class<? extends Writable> valueClass) throws IOException {
        Path dirName = new Path(TEST_DIR, fileName);
        MapFile.Writer.setIndexInterval((Configuration)conf, (int)4);
        return new MapFile.Writer(conf, dirName, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(keyClass), MapFile.Writer.valueClass(valueClass)});
    }

    private MapFile.Reader createReader(String fileName, Class<? extends WritableComparable<?>> keyClass) throws IOException {
        Path dirName = new Path(TEST_DIR, fileName);
        return new MapFile.Reader(dirName, conf, new SequenceFile.Reader.Option[]{MapFile.Reader.comparator((WritableComparator)new WritableComparator(keyClass))});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetClosestOnCurrentApi() throws Exception {
        String TEST_PREFIX = "testGetClosestOnCurrentApi.mapfile";
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            int FIRST_KEY;
            writer = this.createWriter("testGetClosestOnCurrentApi.mapfile", Text.class, Text.class);
            for (int i = FIRST_KEY = 1; i < 100; i += 10) {
                Text t = new Text(Integer.toString(i));
                writer.append((WritableComparable)t, (Writable)t);
            }
            writer.close();
            reader = this.createReader("testGetClosestOnCurrentApi.mapfile", Text.class);
            Text key = new Text("55");
            Text value = new Text();
            Text closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assert.assertEquals((Object)new Text("61"), (Object)closest);
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
            Assert.assertEquals((Object)new Text("51"), (Object)closest);
            Text explicitKey = new Text("21");
            closest = (Text)reader.getClosest((WritableComparable)explicitKey, (Writable)value);
            Assert.assertEquals((Object)new Text("21"), (Object)explicitKey);
            key = new Text("00");
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assert.assertEquals((long)FIRST_KEY, (long)Integer.parseInt(closest.toString()));
            key = new Text("92");
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assert.assertNull((String)"Not null key in testGetClosestWithNewCode", (Object)closest);
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
            Assert.assertEquals((Object)new Text("91"), (Object)closest);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMidKeyOnCurrentApi() throws Exception {
        String TEST_PREFIX = "testMidKeyOnCurrentApi.mapfile";
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = this.createWriter("testMidKeyOnCurrentApi.mapfile", IntWritable.class, IntWritable.class);
            int SIZE = 10;
            for (int i = 0; i < SIZE; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new IntWritable(i));
            }
            writer.close();
            reader = this.createReader("testMidKeyOnCurrentApi.mapfile", IntWritable.class);
            Assert.assertEquals((Object)new IntWritable((SIZE - 1) / 2), (Object)reader.midKey());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRename() {
        String NEW_FILE_NAME = "test-new.mapfile";
        String OLD_FILE_NAME = "test-old.mapfile";
        MapFile.Writer writer = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            writer = this.createWriter("test-old.mapfile", IntWritable.class, IntWritable.class);
            writer.close();
            MapFile.rename((FileSystem)fs, (String)new Path(TEST_DIR, "test-old.mapfile").toString(), (String)new Path(TEST_DIR, "test-new.mapfile").toString());
            MapFile.delete((FileSystem)fs, (String)new Path(TEST_DIR, "test-new.mapfile").toString());
        }
        catch (IOException ex) {
            try {
                Assert.fail((String)("testRename error " + ex));
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithException() {
        String ERROR_MESSAGE = "Can't rename file";
        String NEW_FILE_NAME = "test-new.mapfile";
        String OLD_FILE_NAME = "test-old.mapfile";
        MapFile.Writer writer = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            FileSystem spyFs = (FileSystem)Mockito.spy((Object)fs);
            writer = this.createWriter("test-old.mapfile", IntWritable.class, IntWritable.class);
            writer.close();
            Path oldDir = new Path(TEST_DIR, "test-old.mapfile");
            Path newDir = new Path(TEST_DIR, "test-new.mapfile");
            Mockito.when((Object)spyFs.rename(oldDir, newDir)).thenThrow(new Throwable[]{new IOException("Can't rename file")});
            MapFile.rename((FileSystem)spyFs, (String)oldDir.toString(), (String)newDir.toString());
            Assert.fail((String)"testRenameWithException no exception error !!!");
        }
        catch (IOException ex) {
            try {
                Assert.assertEquals((String)"testRenameWithException invalid IOExceptionMessage !!!", (Object)ex.getMessage(), (Object)"Can't rename file");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithFalse() {
        String ERROR_MESSAGE = "Could not rename";
        String NEW_FILE_NAME = "test-new.mapfile";
        String OLD_FILE_NAME = "test-old.mapfile";
        MapFile.Writer writer = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            FileSystem spyFs = (FileSystem)Mockito.spy((Object)fs);
            writer = this.createWriter("test-old.mapfile", IntWritable.class, IntWritable.class);
            writer.close();
            Path oldDir = new Path(TEST_DIR, "test-old.mapfile");
            Path newDir = new Path(TEST_DIR, "test-new.mapfile");
            Mockito.when((Object)spyFs.rename(oldDir, newDir)).thenReturn((Object)false);
            MapFile.rename((FileSystem)spyFs, (String)oldDir.toString(), (String)newDir.toString());
            Assert.fail((String)"testRenameWithException no exception error !!!");
        }
        catch (IOException ex) {
            try {
                Assert.assertTrue((String)"testRenameWithFalse invalid IOExceptionMessage error !!!", (boolean)ex.getMessage().startsWith("Could not rename"));
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteWithFailDirCreation() {
        String ERROR_MESSAGE = "Mkdirs failed to create directory";
        Path dirName = new Path(TEST_DIR, "fail.mapfile");
        MapFile.Writer writer = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            FileSystem spyFs = (FileSystem)Mockito.spy((Object)fs);
            Path pathSpy = (Path)Mockito.spy((Object)dirName);
            Mockito.when((Object)pathSpy.getFileSystem(conf)).thenReturn((Object)spyFs);
            Mockito.when((Object)spyFs.mkdirs(dirName)).thenReturn((Object)false);
            writer = new MapFile.Writer(conf, pathSpy, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class)});
            Assert.fail((String)"testWriteWithFailDirCreation error !!!");
        }
        catch (IOException ex) {
            try {
                Assert.assertTrue((String)"testWriteWithFailDirCreation ex error !!!", (boolean)ex.getMessage().startsWith(ERROR_MESSAGE));
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnFinalKey() {
        String TEST_METHOD_KEY = "testOnFinalKey.mapfile";
        int SIZE = 10;
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = this.createWriter("testOnFinalKey.mapfile", IntWritable.class, IntWritable.class);
            for (int i = 0; i < SIZE; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new IntWritable(i));
            }
            writer.close();
            reader = this.createReader("testOnFinalKey.mapfile", IntWritable.class);
            IntWritable expectedKey = new IntWritable(0);
            reader.finalKey((WritableComparable)expectedKey);
            Assert.assertEquals((String)"testOnFinalKey not same !!!", (Object)expectedKey, (Object)new IntWritable(9));
        }
        catch (IOException ex) {
            try {
                Assert.fail((String)"testOnFinalKey error !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    @Test
    public void testKeyValueClasses() {
        Class<IntWritable> keyClass = IntWritable.class;
        Class<Text> valueClass = Text.class;
        try {
            this.createWriter("testKeyValueClasses.mapfile", IntWritable.class, Text.class).close();
            Assert.assertNotNull((String)"writer key class null error !!!", (Object)MapFile.Writer.keyClass(keyClass));
            Assert.assertNotNull((String)"writer value class null error !!!", (Object)MapFile.Writer.valueClass(valueClass));
        }
        catch (IOException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testReaderGetClosest() throws Exception {
        String TEST_METHOD_KEY = "testReaderWithWrongKeyClass.mapfile";
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = this.createWriter("testReaderWithWrongKeyClass.mapfile", IntWritable.class, Text.class);
            for (int i = 0; i < 10; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new Text("value" + i));
            }
            writer.close();
            reader = this.createReader("testReaderWithWrongKeyClass.mapfile", Text.class);
            reader.getClosest((WritableComparable)new Text("2"), (Writable)new Text(""));
            Assert.fail((String)"no excepted exception in testReaderWithWrongKeyClass !!!");
        }
        catch (IOException iOException) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
                throw throwable;
            }
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testReaderWithWrongValueClass() {
        String TEST_METHOD_KEY = "testReaderWithWrongValueClass.mapfile";
        MapFile.Writer writer = null;
        try {
            writer = this.createWriter("testReaderWithWrongValueClass.mapfile", IntWritable.class, Text.class);
            writer.append((WritableComparable)new IntWritable(0), (Writable)new IntWritable(0));
            Assert.fail((String)"no excepted exception in testReaderWithWrongKeyClass !!!");
        }
        catch (IOException iOException) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderKeyIteration() {
        String TEST_METHOD_KEY = "testReaderKeyIteration.mapfile";
        int SIZE = 10;
        int ITERATIONS = 5;
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = this.createWriter("testReaderKeyIteration.mapfile", IntWritable.class, Text.class);
            int start = 0;
            for (int i = 0; i < SIZE; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new Text("Value:" + i));
            }
            writer.close();
            reader = this.createReader("testReaderKeyIteration.mapfile", IntWritable.class);
            Text startValue = new Text("Value:" + start);
            int i = 0;
            while (i++ < ITERATIONS) {
                IntWritable key = new IntWritable(start);
                Text value = startValue;
                while (reader.next((WritableComparable)key, (Writable)value)) {
                    Assert.assertNotNull((Object)key);
                    Assert.assertNotNull((Object)value);
                }
                reader.reset();
            }
            Assert.assertTrue((String)"reader seek error !!!", (boolean)reader.seek((WritableComparable)new IntWritable(SIZE / 2)));
            Assert.assertFalse((String)"reader seek error !!!", (boolean)reader.seek((WritableComparable)new IntWritable(SIZE * 2)));
        }
        catch (IOException ex) {
            try {
                Assert.fail((String)"reader seek error !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFix() {
        MapFile.Writer writer;
        block6: {
            String INDEX_LESS_MAP_FILE = "testFix.mapfile";
            int PAIR_SIZE = 20;
            writer = null;
            try {
                LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
                Path dir = new Path(TEST_DIR, "testFix.mapfile");
                writer = this.createWriter("testFix.mapfile", IntWritable.class, Text.class);
                for (int i = 0; i < PAIR_SIZE; ++i) {
                    writer.append((WritableComparable)new IntWritable(0), (Writable)new Text("value"));
                }
                writer.close();
                File indexFile = new File(".", ".testFix.mapfile/index");
                boolean isDeleted = false;
                if (indexFile.exists()) {
                    isDeleted = indexFile.delete();
                }
                if (!isDeleted) break block6;
                Assert.assertTrue((String)"testFix error !!!", (MapFile.fix((FileSystem)fs, (Path)dir, IntWritable.class, Text.class, (boolean)true, (Configuration)conf) == (long)PAIR_SIZE ? 1 : 0) != 0);
            }
            catch (Exception ex) {
                try {
                    Assert.fail((String)"testFix error !!!");
                }
                catch (Throwable throwable) {
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                    throw throwable;
                }
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
            }
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeprecatedConstructors() {
        String path = new Path(TEST_DIR, "writes.mapfile").toString();
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD);
            Assert.assertNotNull((Object)writer);
            writer.close();
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD, defaultProgressable);
            Assert.assertNotNull((Object)writer);
            writer.close();
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD, defaultCodec, defaultProgressable);
            Assert.assertNotNull((Object)writer);
            writer.close();
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, WritableComparator.get(Text.class), Text.class);
            Assert.assertNotNull((Object)writer);
            writer.close();
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, WritableComparator.get(Text.class), Text.class, SequenceFile.CompressionType.RECORD);
            Assert.assertNotNull((Object)writer);
            writer.close();
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, WritableComparator.get(Text.class), Text.class, SequenceFile.CompressionType.RECORD, defaultProgressable);
            Assert.assertNotNull((Object)writer);
            writer.close();
            reader = new MapFile.Reader((FileSystem)fs, path, WritableComparator.get(IntWritable.class), conf);
            Assert.assertNotNull((Object)reader);
            Assert.assertNotNull((String)"reader key is null !!!", (Object)reader.getKeyClass());
            Assert.assertNotNull((String)"reader value in null", (Object)reader.getValueClass());
        }
        catch (IOException e) {
            try {
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testKeyLessWriterCreation() {
        MapFile.Writer writer = null;
        try {
            writer = new MapFile.Writer(conf, TEST_DIR, new SequenceFile.Writer.Option[0]);
            Assert.fail((String)"fail in testKeyLessWriterCreation !!!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        catch (Exception e) {
            Assert.fail((String)"fail in testKeyLessWriterCreation. Other ex !!!");
            {
                catch (Throwable throwable) {
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                    throw throwable;
                }
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testPathExplosionWriterCreation() {
        Path path = new Path(TEST_DIR, "testPathExplosionWriterCreation.mapfile");
        String TEST_ERROR_MESSAGE = "Mkdirs failed to create directory " + path.getName();
        MapFile.Writer writer = null;
        try {
            FileSystem fsSpy = (FileSystem)Mockito.spy((Object)FileSystem.get((Configuration)conf));
            Path pathSpy = (Path)Mockito.spy((Object)path);
            Mockito.when((Object)fsSpy.mkdirs(path)).thenThrow(new Throwable[]{new IOException(TEST_ERROR_MESSAGE)});
            Mockito.when((Object)pathSpy.getFileSystem(conf)).thenReturn((Object)fsSpy);
            writer = new MapFile.Writer(conf, pathSpy, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(IntWritable.class)});
            Assert.fail((String)"fail in testPathExplosionWriterCreation !!!");
        }
        catch (IOException ex) {
            Assert.assertEquals((String)"testPathExplosionWriterCreation ex message error !!!", (Object)ex.getMessage(), (Object)TEST_ERROR_MESSAGE);
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        catch (Exception e) {
            Assert.fail((String)"fail in testPathExplosionWriterCreation. Other ex !!!");
            {
                catch (Throwable throwable) {
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                    throw throwable;
                }
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testDescOrderWithThrowExceptionWriterAppend() {
        MapFile.Writer writer = null;
        try {
            writer = this.createWriter(".mapfile", IntWritable.class, Text.class);
            writer.append((WritableComparable)new IntWritable(2), (Writable)new Text("value: 1"));
            writer.append((WritableComparable)new IntWritable(2), (Writable)new Text("value: 2"));
            writer.append((WritableComparable)new IntWritable(2), (Writable)new Text("value: 4"));
            writer.append((WritableComparable)new IntWritable(1), (Writable)new Text("value: 3"));
            Assert.fail((String)"testDescOrderWithThrowExceptionWriterAppend not expected exception error !!!");
        }
        catch (IOException iOException) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        catch (Exception e) {
            Assert.fail((String)"testDescOrderWithThrowExceptionWriterAppend other ex throw !!!");
            {
                catch (Throwable throwable) {
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                    throw throwable;
                }
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainMethodMapFile() {
        String inFile = "mainMethodMapFile.mapfile";
        String path = new Path(TEST_DIR, inFile).toString();
        String[] args = new String[]{path, path};
        MapFile.Writer writer = null;
        try {
            writer = this.createWriter(inFile, IntWritable.class, Text.class);
            writer.append((WritableComparable)new IntWritable(1), (Writable)new Text("test_text1"));
            writer.append((WritableComparable)new IntWritable(2), (Writable)new Text("test_text2"));
            writer.close();
            MapFile.main((String[])args);
        }
        catch (Exception ex) {
            try {
                Assert.fail((String)"testMainMethodMapFile error !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetClosest() throws Exception {
        Path dirName = new Path(TEST_DIR, "testGetClosest.mapfile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(dirName);
        MapFile.Writer.setIndexInterval((Configuration)conf, (int)3);
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = new MapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), Text.class, Text.class);
            Assert.assertEquals((long)3L, (long)writer.getIndexInterval());
            int FIRST_KEY = 10;
            for (int i = 10; i < 100; i += 10) {
                String iStr = Integer.toString(i);
                Text t = new Text("00".substring(iStr.length()) + iStr);
                writer.append((WritableComparable)t, (Writable)t);
            }
            writer.close();
            reader = new MapFile.Reader(qualifiedDirName, conf, new SequenceFile.Reader.Option[0]);
            Text key = new Text("55");
            Text value = new Text();
            Text closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assert.assertEquals((Object)new Text("60"), (Object)closest);
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
            Assert.assertEquals((Object)new Text("50"), (Object)closest);
            Text TWENTY = new Text("20");
            closest = (Text)reader.getClosest((WritableComparable)TWENTY, (Writable)value);
            Assert.assertEquals((Object)TWENTY, (Object)closest);
            closest = (Text)reader.getClosest((WritableComparable)TWENTY, (Writable)value, true);
            Assert.assertEquals((Object)TWENTY, (Object)closest);
            key = new Text("00");
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assert.assertEquals((long)10L, (long)Integer.parseInt(closest.toString()));
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
            Assert.assertNull((Object)closest);
            key = new Text("99");
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assert.assertNull((Object)closest);
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
            Assert.assertEquals((Object)new Text("90"), (Object)closest);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMidKey() throws Exception {
        Path dirName = new Path(TEST_DIR, "testMidKey.mapfile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(dirName);
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = new MapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), IntWritable.class, IntWritable.class);
            writer.append((WritableComparable)new IntWritable(1), (Writable)new IntWritable(1));
            writer.close();
            reader = new MapFile.Reader(qualifiedDirName, conf, new SequenceFile.Reader.Option[0]);
            Assert.assertEquals((Object)new IntWritable(1), (Object)reader.midKey());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMidKeyEmpty() throws Exception {
        Path dirName = new Path(TEST_DIR, "testMidKeyEmpty.mapfile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(dirName);
        MapFile.Writer writer = new MapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), IntWritable.class, IntWritable.class);
        writer.close();
        try (MapFile.Reader reader = new MapFile.Reader(qualifiedDirName, conf, new SequenceFile.Reader.Option[0]);){
            Assert.assertEquals(null, (Object)reader.midKey());
        }
    }

    @Test
    public void testMerge() throws Exception {
        Throwable throwable;
        String TEST_METHOD_KEY = "testMerge.mapfile";
        int SIZE = 10;
        int ITERATIONS = 5;
        Path[] in = new Path[5];
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (int j = 0; j < 5; ++j) {
            throwable = null;
            try (MapFile.Writer writer = this.createWriter("testMerge.mapfile." + j, IntWritable.class, Text.class);){
                in[j] = new Path(TEST_DIR, "testMerge.mapfile." + j);
                for (int i = 0; i < SIZE; ++i) {
                    expected.add(i + j);
                    writer.append((WritableComparable)new IntWritable(i + j), (Writable)new Text("Value:" + (i + j)));
                }
                continue;
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        Collections.sort(expected);
        MapFile.Merger merger = new MapFile.Merger(conf);
        merger.merge(in, true, new Path(TEST_DIR, "testMerge.mapfile"));
        throwable = null;
        try (MapFile.Reader reader = this.createReader("testMerge.mapfile", IntWritable.class);){
            int start = 0;
            Text startValue = new Text("Value:" + start);
            int i = 0;
            while (i++ < ITERATIONS) {
                Iterator expectedIterator = expected.iterator();
                IntWritable key = new IntWritable(start);
                Text value = startValue;
                IntWritable prev = new IntWritable(start);
                while (reader.next((WritableComparable)key, (Writable)value)) {
                    Assert.assertTrue((String)"Next key should be always equal or more", (prev.get() <= key.get() ? 1 : 0) != 0);
                    Assert.assertEquals((long)((Integer)expectedIterator.next()).intValue(), (long)key.get());
                    prev.set(key.get());
                }
                reader.reset();
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        for (int j = 0; j < in.length; ++j) {
            Path path = in[j];
            Assert.assertFalse((String)"inputs should be deleted", (boolean)path.getFileSystem(conf).exists(path));
        }
    }
}

