/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRawLocalFileSystemContract
extends FileSystemContractBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestRawLocalFileSystemContract.class);
    private static final Path TEST_BASE_DIR = new Path(GenericTestUtils.getTempPath(""));

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)conf).getRawFileSystem();
    }

    @Override
    protected boolean renameSupported() {
        return false;
    }

    @Override
    protected boolean rootDirTestEnabled() {
        return false;
    }

    @Override
    public String getDefaultWorkingDirectory() {
        return this.fs.getWorkingDirectory().toUri().getPath();
    }

    @Override
    protected Path getTestBaseDir() {
        return TEST_BASE_DIR;
    }

    @Override
    protected boolean filesystemIsCaseSensitive() {
        return !Shell.WINDOWS && !Shell.MAC;
    }
}

