/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.junit.Assert;
import org.junit.Test;

public class TestXAttrFeature {
    static final String name1 = "system.a1";
    static final byte[] value1 = new byte[]{49, 50, 51};
    static final String name2 = "security.a2";
    static final byte[] value2 = new byte[]{55, 56, 57};
    static final String name3 = "trusted.a3";
    static final String name4 = "user.a4";
    static final byte[] value4 = new byte[]{1, 2, 3};
    static final String name5 = "user.a5";
    static final byte[] value5 = TestXAttrFeature.randomBytes(2000);
    static final String name6 = "user.a6";
    static final byte[] value6 = TestXAttrFeature.randomBytes(1800);
    static final String name7 = "raw.a7";
    static final byte[] value7 = new byte[]{17, 18, 19};
    static final String name8 = "user.a8";
    static final String bigXattrKey = "user.big.xattr.key";
    static final byte[] bigXattrValue = new byte[128];

    static byte[] randomBytes(int len) {
        Random rand = new Random();
        byte[] bytes = new byte[len];
        rand.nextBytes(bytes);
        return bytes;
    }

    @Test
    public void testXAttrFeature() throws Exception {
        ArrayList<XAttr> xAttrs = new ArrayList<XAttr>();
        XAttrFeature feature = new XAttrFeature(xAttrs);
        Assert.assertTrue((boolean)feature.getXAttrs().isEmpty());
        XAttr a1 = XAttrHelper.buildXAttr((String)name1, (byte[])value1);
        xAttrs.add(a1);
        feature = new XAttrFeature(xAttrs);
        XAttr r1 = feature.getXAttr(name1);
        Assert.assertTrue((boolean)a1.equals((Object)r1));
        Assert.assertEquals((long)feature.getXAttrs().size(), (long)1L);
        XAttr a2 = XAttrHelper.buildXAttr((String)name2, (byte[])value2);
        XAttr a3 = XAttrHelper.buildXAttr((String)name3);
        XAttr a4 = XAttrHelper.buildXAttr((String)name4, (byte[])value4);
        XAttr a5 = XAttrHelper.buildXAttr((String)name5, (byte[])value5);
        XAttr a6 = XAttrHelper.buildXAttr((String)name6, (byte[])value6);
        XAttr a7 = XAttrHelper.buildXAttr((String)name7, (byte[])value7);
        XAttr bigXattr = XAttrHelper.buildXAttr((String)bigXattrKey, (byte[])bigXattrValue);
        xAttrs.add(a2);
        xAttrs.add(a3);
        xAttrs.add(a4);
        xAttrs.add(a5);
        xAttrs.add(a6);
        xAttrs.add(a7);
        xAttrs.add(bigXattr);
        feature = new XAttrFeature(xAttrs);
        XAttr r2 = feature.getXAttr(name2);
        Assert.assertTrue((boolean)a2.equals((Object)r2));
        XAttr r3 = feature.getXAttr(name3);
        Assert.assertTrue((boolean)a3.equals((Object)r3));
        XAttr r4 = feature.getXAttr(name4);
        Assert.assertTrue((boolean)a4.equals((Object)r4));
        XAttr r5 = feature.getXAttr(name5);
        Assert.assertTrue((boolean)a5.equals((Object)r5));
        XAttr r6 = feature.getXAttr(name6);
        Assert.assertTrue((boolean)a6.equals((Object)r6));
        XAttr r7 = feature.getXAttr(name7);
        Assert.assertTrue((boolean)a7.equals((Object)r7));
        XAttr rBigXattr = feature.getXAttr(bigXattrKey);
        Assert.assertTrue((boolean)bigXattr.equals((Object)rBigXattr));
        List rs = feature.getXAttrs();
        Assert.assertEquals((long)rs.size(), (long)xAttrs.size());
        for (int i = 0; i < rs.size(); ++i) {
            Assert.assertTrue((boolean)xAttrs.contains(rs.get(i)));
        }
        XAttr r8 = feature.getXAttr(name8);
        Assert.assertTrue((r8 == null ? 1 : 0) != 0);
    }

    static {
        for (int i = 0; i < bigXattrValue.length; ++i) {
            TestXAttrFeature.bigXattrValue[i] = (byte)(i & 0xFF);
        }
    }
}

