/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestINodeAttributeProvider {
    private MiniDFSCluster miniDFS;
    private static final Set<String> CALLED = new HashSet<String>();

    @Before
    public void setUp() throws IOException {
        CALLED.clear();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.inode.attributes.provider.class", MyAuthorizationProvider.class.getName());
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        this.miniDFS = new MiniDFSCluster.Builder((Configuration)conf).build();
    }

    @After
    public void cleanUp() throws IOException {
        CALLED.clear();
        if (this.miniDFS != null) {
            this.miniDFS.shutdown();
            this.miniDFS = null;
        }
        Assert.assertTrue((boolean)CALLED.contains("stop"));
    }

    @Test
    public void testDelegationToProvider() throws Exception {
        Assert.assertTrue((boolean)CALLED.contains("start"));
        FileSystem fs = FileSystem.get((Configuration)this.miniDFS.getConfiguration(0));
        fs.mkdirs(new Path("/tmp"));
        fs.setPermission(new Path("/tmp"), new FsPermission(511));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"u1", (String[])new String[]{"g1"});
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)TestINodeAttributeProvider.this.miniDFS.getConfiguration(0));
                CALLED.clear();
                fs.mkdirs(new Path("/tmp/foo"));
                Assert.assertTrue((boolean)CALLED.contains("getAttributes"));
                Assert.assertTrue((boolean)CALLED.contains("checkPermission|null|null|null"));
                Assert.assertTrue((boolean)CALLED.contains("checkPermission|WRITE|null|null"));
                CALLED.clear();
                fs.listStatus(new Path("/tmp/foo"));
                Assert.assertTrue((boolean)CALLED.contains("getAttributes"));
                Assert.assertTrue((boolean)CALLED.contains("checkPermission|null|null|READ_EXECUTE"));
                CALLED.clear();
                fs.getAclStatus(new Path("/tmp/foo"));
                Assert.assertTrue((boolean)CALLED.contains("getAttributes"));
                Assert.assertTrue((boolean)CALLED.contains("checkPermission|null|null|null"));
                return null;
            }
        });
    }

    private void verifyFileStatus(UserGroupInformation ugi) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.miniDFS.getConfiguration(0));
        FileStatus status = fs.getFileStatus(new Path("/"));
        Path userDir = new Path("/user/" + ugi.getShortUserName());
        fs.mkdirs(userDir);
        status = fs.getFileStatus(userDir);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)status.getOwner());
        Assert.assertEquals((Object)"supergroup", (Object)status.getGroup());
        Assert.assertEquals((Object)new FsPermission(493), (Object)status.getPermission());
        Path authzDir = new Path("/user/authz");
        fs.mkdirs(authzDir);
        status = fs.getFileStatus(authzDir);
        Assert.assertEquals((Object)"foo", (Object)status.getOwner());
        Assert.assertEquals((Object)"bar", (Object)status.getGroup());
        Assert.assertEquals((Object)new FsPermission(504), (Object)status.getPermission());
        AclStatus aclStatus = fs.getAclStatus(authzDir);
        Assert.assertEquals((long)1L, (long)aclStatus.getEntries().size());
        Assert.assertEquals((Object)AclEntryType.GROUP, (Object)((AclEntry)aclStatus.getEntries().get(0)).getType());
        Assert.assertEquals((Object)"xxx", (Object)((AclEntry)aclStatus.getEntries().get(0)).getName());
        Assert.assertEquals((Object)FsAction.ALL, (Object)((AclEntry)aclStatus.getEntries().get(0)).getPermission());
        Map xAttrs = fs.getXAttrs(authzDir);
        Assert.assertTrue((boolean)xAttrs.containsKey("user.test"));
        Assert.assertEquals((long)2L, (long)((byte[])xAttrs.get("user.test")).length);
    }

    @Test
    public void testCustomProvider() throws Exception {
        UserGroupInformation[] users;
        for (final UserGroupInformation user : users = new UserGroupInformation[]{UserGroupInformation.createUserForTesting((String)System.getProperty("user.name"), (String[])new String[]{"supergroup"}), UserGroupInformation.createUserForTesting((String)"normaluser", (String[])new String[]{"normalusergroup"})}) {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestINodeAttributeProvider.this.verifyFileStatus(user);
                    return null;
                }
            });
        }
    }

    public static class MyAuthorizationProvider
    extends INodeAttributeProvider {
        public void start() {
            CALLED.add("start");
        }

        public void stop() {
            CALLED.add("stop");
        }

        public INodeAttributes getAttributes(String[] pathElements, final INodeAttributes inode) {
            CALLED.add("getAttributes");
            final boolean useDefault = this.useDefault(pathElements);
            return new INodeAttributes(){

                public boolean isDirectory() {
                    return inode.isDirectory();
                }

                public byte[] getLocalNameBytes() {
                    return inode.getLocalNameBytes();
                }

                public String getUserName() {
                    return useDefault ? inode.getUserName() : "foo";
                }

                public String getGroupName() {
                    return useDefault ? inode.getGroupName() : "bar";
                }

                public FsPermission getFsPermission() {
                    return useDefault ? inode.getFsPermission() : new FsPermission(this.getFsPermissionShort());
                }

                public short getFsPermissionShort() {
                    return useDefault ? inode.getFsPermissionShort() : (short)this.getPermissionLong();
                }

                public long getPermissionLong() {
                    return useDefault ? inode.getPermissionLong() : 504L;
                }

                public AclFeature getAclFeature() {
                    AclFeature f;
                    if (useDefault) {
                        f = inode.getAclFeature();
                    } else {
                        AclEntry acl = new AclEntry.Builder().setType(AclEntryType.GROUP).setPermission(FsAction.ALL).setName("xxx").build();
                        f = new AclFeature(AclEntryStatusFormat.toInt((List)Lists.newArrayList((Object[])new AclEntry[]{acl})));
                    }
                    return f;
                }

                public XAttrFeature getXAttrFeature() {
                    XAttrFeature x = useDefault ? inode.getXAttrFeature() : new XAttrFeature((List)ImmutableList.copyOf((Collection)Lists.newArrayList((Object[])new XAttr[]{new XAttr.Builder().setName("test").setValue(new byte[]{1, 2}).build()})));
                    return x;
                }

                public long getModificationTime() {
                    return useDefault ? inode.getModificationTime() : 0L;
                }

                public long getAccessTime() {
                    return useDefault ? inode.getAccessTime() : 0L;
                }
            };
        }

        public INodeAttributeProvider.AccessControlEnforcer getExternalAccessControlEnforcer(INodeAttributeProvider.AccessControlEnforcer deafultEnforcer) {
            return new MyAccessControlEnforcer();
        }

        private boolean useDefault(String[] pathElements) {
            return pathElements.length < 2 || !pathElements[0].equals("user") || !pathElements[1].equals("authz");
        }

        public static class MyAccessControlEnforcer
        implements INodeAttributeProvider.AccessControlEnforcer {
            public void checkPermission(String fsOwner, String supergroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
                CALLED.add("checkPermission|" + ancestorAccess + "|" + parentAccess + "|" + access);
            }
        }
    }
}

