/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.hdfs.server.balancer.BalancerParameters;
import org.apache.hadoop.hdfs.server.balancer.BalancingPolicy;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithUpgradeDomain;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestBalancerLongRunningTasks {
    private static final Logger LOG = LoggerFactory.getLogger(TestBalancerLongRunningTasks.class);
    private static final long CAPACITY = 5000L;
    private static final String RACK0 = "/rack0";
    private static final String RACK1 = "/rack1";
    private static final String RACK2 = "/rack2";
    private static final String FILE_NAME = "/tmp.txt";
    private static final Path FILE_PATH;
    private MiniDFSCluster cluster;
    private ClientProtocol client;
    static final int DEFAULT_BLOCK_SIZE = 100;
    static final int DEFAULT_RAM_DISK_BLOCK_SIZE = 0x500000;

    @After
    public void shutdown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    public static void initTestSetup() {
        NameNodeConnector.setWrite2IdFile((boolean)false);
    }

    static void initConf(Configuration conf) {
        conf.setLong("dfs.blocksize", 100L);
        conf.setInt("dfs.bytes-per-checksum", 100);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        SimulatedFSDataset.setFactory(conf);
        conf.setLong("dfs.balancer.movedWinWidth", 2000L);
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 1L);
        conf.setInt("dfs.balancer.max-no-move-interval", 5000);
    }

    static void initConfWithRamDisk(Configuration conf, long ramDiskCapacity) {
        conf.setLong("dfs.blocksize", 0x500000L);
        conf.setLong("dfs.datanode.max.locked.memory", ramDiskCapacity);
        conf.setInt("dfs.namenode.lazypersist.file.scrub.interval.sec", 3);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setInt("dfs.datanode.lazywriter.interval.sec", 1);
        conf.setInt("dfs.balancer.max-no-move-interval", 5000);
        LazyPersistTestCase.initCacheManipulator();
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 1L);
    }

    @Test(timeout=100000L)
    public void testTwoReplicaShouldNotInSameDN() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int blockSize = 0x500000;
        conf.setLong("dfs.blocksize", (long)blockSize);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 1L);
        int numOfDatanodes = 2;
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).racks(new String[]{"/default/rack0", "/default/rack0"}).storagesPerDatanode(2).storageTypes(new StorageType[][]{{StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}}).storageCapacities(new long[][]{{100 * blockSize, 20 * blockSize}, {20 * blockSize, 100 * blockSize}}).build();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path barDir = new Path("/bar");
        fs.mkdir(barDir, new FsPermission(777));
        fs.setStoragePolicy(barDir, "ONE_SSD");
        long fileLen = 30 * blockSize;
        Path fooFile = new Path(barDir, "foo");
        TestBalancer.createFile(this.cluster, fooFile, fileLen, (short)numOfDatanodes, 0);
        this.cluster.triggerHeartbeats();
        BalancerParameters p = BalancerParameters.DEFAULT;
        Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        int r = Balancer.run((Collection)namenodes, (BalancerParameters)p, (Configuration)conf);
        Assert.assertEquals((long)ExitStatus.NO_MOVE_PROGRESS.getExitCode(), (long)r);
    }

    @Test(timeout=300000L)
    public void testBalancerWithRamDisk() throws Exception {
        int seed = 1027565;
        boolean replicationFactor = true;
        Configuration conf = new Configuration();
        int defaultRamDiskCapacity = 10;
        long ramDiskStorageLimit = 0x36FFFFFL;
        long diskStorageLimit = 0x36FFFFFL;
        TestBalancerLongRunningTasks.initConfWithRamDisk(conf, 0x36FFFFFL);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).storageCapacities(new long[]{0x36FFFFFL, 0x36FFFFFL}).storageTypes(new StorageType[]{StorageType.RAM_DISK, StorageType.DEFAULT}).build();
        this.cluster.waitActive();
        String methodName = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + methodName + ".01.dat");
        Path path2 = new Path("/" + methodName + ".02.dat");
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DFSClient dfsClient = fs.getClient();
        DFSTestUtil.createFile((FileSystem)fs, path1, true, 0x500000, 0x1400000L, 0x500000L, (short)1, 1027565L, true);
        DFSTestUtil.createFile((FileSystem)fs, path2, true, 0x500000, 0x500000L, 0x500000L, (short)1, 1027565L, true);
        Thread.sleep(6000L);
        StorageType[][] storageTypes = new StorageType[][]{{StorageType.RAM_DISK, StorageType.DEFAULT}};
        long[][] storageCapacities = new long[][]{{0x36FFFFFL, 0x36FFFFFL}};
        this.cluster.startDataNodes(conf, 1, storageTypes, true, null, null, null, storageCapacities, null, false, false, false, null);
        this.cluster.triggerHeartbeats();
        Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        BalancerParameters p = BalancerParameters.DEFAULT;
        int r = Balancer.run((Collection)namenodes, (BalancerParameters)p, (Configuration)conf);
        Assert.assertEquals((long)ExitStatus.NO_MOVE_PROGRESS.getExitCode(), (long)r);
        DFSTestUtil.verifyFileReplicasOnStorageType((FileSystem)fs, dfsClient, path1, StorageType.RAM_DISK);
        DFSTestUtil.verifyFileReplicasOnStorageType((FileSystem)fs, dfsClient, path2, StorageType.RAM_DISK);
    }

    @Test(timeout=60000L)
    public void testMinBlockSizeAndSourceNodes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancerLongRunningTasks.initConf((Configuration)conf);
        int replication = 3;
        long[] lengths = new long[]{10L, 10L, 10L, 10L};
        long[] capacities = new long[3];
        long totalUsed = (long)capacities.length * TestBalancer.sum(lengths);
        Arrays.fill(capacities, 1000L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(capacities.length).simulatedCapacities(capacities).build();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        this.cluster.waitActive();
        this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)dfs.getUri(), ClientProtocol.class).getProxy();
        for (int i = 0; i < lengths.length; ++i) {
            long size = lengths[i];
            Path p = new Path("/file" + i + "_size" + size);
            try (FSDataOutputStream out = dfs.create(p);){
                int j = 0;
                while ((long)j < size) {
                    out.write(j);
                    ++j;
                }
                continue;
            }
        }
        this.cluster.startDataNodes((Configuration)conf, capacities.length, true, null, null, capacities);
        LOG.info("capacities    = " + Arrays.toString(capacities));
        LOG.info("totalUsedSpace= " + totalUsed);
        LOG.info("lengths       = " + Arrays.toString(lengths) + ", #=" + lengths.length);
        TestBalancer.waitForHeartBeat(totalUsed, 2L * capacities[0] * (long)capacities.length, this.client, this.cluster);
        Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        BalancerParameters p = Balancer.Cli.parse((String[])new String[]{"-policy", BalancingPolicy.Node.INSTANCE.getName(), "-threshold", "1"});
        Assert.assertEquals((Object)p.getBalancingPolicy(), (Object)BalancingPolicy.Node.INSTANCE);
        Assert.assertEquals((double)p.getThreshold(), (double)1.0, (double)0.001);
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 50L);
        int r = Balancer.run((Collection)namenodes, (BalancerParameters)p, (Configuration)conf);
        Assert.assertEquals((long)ExitStatus.NO_MOVE_PROGRESS.getExitCode(), (long)r);
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 1L);
        HashSet<String> sourceNodes = new HashSet<String>();
        ArrayList<DataNode> datanodes = this.cluster.getDataNodes();
        for (int i = capacities.length; i < datanodes.size(); ++i) {
            sourceNodes.add(((DataNode)datanodes.get(i)).getDisplayName());
        }
        BalancerParameters p2 = Balancer.Cli.parse((String[])new String[]{"-policy", BalancingPolicy.Node.INSTANCE.getName(), "-threshold", "1", "-source", StringUtils.join(sourceNodes, (char)',')});
        Assert.assertEquals((Object)p2.getBalancingPolicy(), (Object)BalancingPolicy.Node.INSTANCE);
        Assert.assertEquals((double)p2.getThreshold(), (double)1.0, (double)0.001);
        Assert.assertEquals((Object)p2.getSourceNodes(), sourceNodes);
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 50L);
        int r2 = Balancer.run((Collection)namenodes, (BalancerParameters)p2, (Configuration)conf);
        Assert.assertEquals((long)ExitStatus.NO_MOVE_BLOCK.getExitCode(), (long)r2);
        sourceNodes = new HashSet();
        datanodes = this.cluster.getDataNodes();
        sourceNodes.add(((DataNode)datanodes.get(0)).getDisplayName());
        p2 = Balancer.Cli.parse((String[])new String[]{"-policy", BalancingPolicy.Node.INSTANCE.getName(), "-threshold", "1", "-source", StringUtils.join(sourceNodes, (char)',')});
        Assert.assertEquals((Object)p2.getBalancingPolicy(), (Object)BalancingPolicy.Node.INSTANCE);
        Assert.assertEquals((double)p2.getThreshold(), (double)1.0, (double)0.001);
        Assert.assertEquals((Object)p2.getSourceNodes(), sourceNodes);
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 1L);
        r2 = Balancer.run((Collection)namenodes, (BalancerParameters)p2, (Configuration)conf);
        Assert.assertEquals((long)ExitStatus.NO_MOVE_BLOCK.getExitCode(), (long)r2);
        sourceNodes = new HashSet();
        datanodes = this.cluster.getDataNodes();
        for (int i = 0; i < capacities.length; ++i) {
            sourceNodes.add(((DataNode)datanodes.get(i)).getDisplayName());
        }
        p = Balancer.Cli.parse((String[])new String[]{"-policy", BalancingPolicy.Node.INSTANCE.getName(), "-threshold", "1", "-source", StringUtils.join(sourceNodes, (char)',')});
        Assert.assertEquals((Object)p.getBalancingPolicy(), (Object)BalancingPolicy.Node.INSTANCE);
        Assert.assertEquals((double)p.getThreshold(), (double)1.0, (double)0.001);
        Assert.assertEquals((Object)p.getSourceNodes(), sourceNodes);
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 1L);
        r2 = Balancer.run((Collection)namenodes, (BalancerParameters)p, (Configuration)conf);
        Assert.assertEquals((long)ExitStatus.SUCCESS.getExitCode(), (long)r2);
    }

    @Test(timeout=100000L)
    public void testUpgradeDomainPolicyAfterBalance() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancerLongRunningTasks.initConf((Configuration)conf);
        conf.setClass("dfs.block.replicator.classname", BlockPlacementPolicyWithUpgradeDomain.class, BlockPlacementPolicy.class);
        long[] capacities = new long[]{5000L, 5000L, 5000L};
        String[] hosts = new String[]{"host0", "host1", "host2"};
        String[] racks = new String[]{RACK0, RACK1, RACK1};
        String[] uds = new String[]{"ud0", "ud1", "ud2"};
        this.runBalancerAndVerifyBlockPlacmentPolicy((Configuration)conf, capacities, hosts, racks, uds, 5000L, "host3", RACK2, "ud2");
    }

    @Test(timeout=100000L)
    public void testRackPolicyAfterBalance() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancerLongRunningTasks.initConf((Configuration)conf);
        long[] capacities = new long[]{5000L, 5000L};
        String[] hosts = new String[]{"host0", "host1"};
        String[] racks = new String[]{RACK0, RACK1};
        this.runBalancerAndVerifyBlockPlacmentPolicy((Configuration)conf, capacities, hosts, racks, null, 5000L, "host2", RACK1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBalancerAndVerifyBlockPlacmentPolicy(Configuration conf, long[] capacities, String[] hosts, String[] racks, String[] UDs, long newCapacity, String newHost, String newRack, String newUD) throws Exception {
        int numOfDatanodes = capacities.length;
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(capacities.length).hosts(hosts).racks(racks).simulatedCapacities(capacities).build();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        if (UDs != null) {
            for (int i = 0; i < UDs.length; ++i) {
                DatanodeID datanodeId = this.cluster.getDataNodes().get(i).getDatanodeId();
                dm.getDatanode(datanodeId).setUpgradeDomain(UDs[i]);
            }
        }
        try {
            this.cluster.waitActive();
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            long totalCapacity = TestBalancer.sum(capacities);
            long totalUsedSpace = totalCapacity * 8L / 10L;
            long fileSize = totalUsedSpace / (long)numOfDatanodes;
            DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(0), FILE_PATH, false, 1024, fileSize, 100L, (short)numOfDatanodes, 0L, false);
            this.cluster.startDataNodes(conf, 1, true, null, new String[]{newRack}, new String[]{newHost}, new long[]{newCapacity});
            if (newUD != null) {
                DatanodeID newId = this.cluster.getDataNodes().get(numOfDatanodes).getDatanodeId();
                dm.getDatanode(newId).setUpgradeDomain(newUD);
            }
            TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity += newCapacity, this.client, this.cluster);
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Balancer.run((Collection)namenodes, (BalancerParameters)BalancerParameters.DEFAULT, (Configuration)conf);
            BlockPlacementPolicy placementPolicy = this.cluster.getNamesystem().getBlockManager().getBlockPlacementPolicy();
            List locatedBlocks = this.client.getBlockLocations(FILE_NAME, 0L, fileSize).getLocatedBlocks();
            for (LocatedBlock locatedBlock : locatedBlocks) {
                BlockPlacementStatus status = placementPolicy.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), numOfDatanodes);
                Assert.assertTrue((boolean)status.isPlacementPolicySatisfied());
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=100000L)
    public void testBalancerWithPinnedBlocks() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancerLongRunningTasks.initConf((Configuration)conf);
        conf.setBoolean("dfs.datanode.block-pinning.enabled", true);
        long[] capacities = new long[]{5000L, 5000L};
        String[] hosts = new String[]{"host0", "host1"};
        String[] racks = new String[]{RACK0, RACK1};
        int numOfDatanodes = capacities.length;
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(capacities.length).hosts(hosts).racks(racks).simulatedCapacities(capacities).build();
        this.cluster.waitActive();
        this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
        long totalCapacity = TestBalancer.sum(capacities);
        long totalUsedSpace = totalCapacity * 8L / 10L;
        InetSocketAddress[] favoredNodes = new InetSocketAddress[numOfDatanodes];
        for (int i = 0; i < favoredNodes.length; ++i) {
            int port = this.cluster.getDataNodes().get(i).getXferAddress().getPort();
            favoredNodes[i] = new InetSocketAddress(hosts[i], port);
        }
        DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(0), FILE_PATH, false, 1024, totalUsedSpace / (long)numOfDatanodes, 100L, (short)numOfDatanodes, 0L, false, favoredNodes);
        this.cluster.startDataNodes((Configuration)conf, 1, true, null, new String[]{RACK2}, new long[]{5000L});
        TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity += 5000L, this.client, this.cluster);
        Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        int r = Balancer.run((Collection)namenodes, (BalancerParameters)BalancerParameters.DEFAULT, (Configuration)conf);
        Assert.assertEquals((long)ExitStatus.NO_MOVE_PROGRESS.getExitCode(), (long)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testMaxIterationTime() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancerLongRunningTasks.initConf((Configuration)conf);
        int blockSize = 0xA00000;
        conf.setLong("dfs.blocksize", (long)blockSize);
        conf.setInt("dfs.bytes-per-checksum", blockSize);
        conf.setInt("dfs.balancer.moverThreads", 1);
        conf.setLong("dfs.datanode.balance.bandwidthPerSec", 0x400000L);
        conf.setLong("dfs.client.socket-timeout", 2000L);
        conf.setLong("dfs.balancer.max-iteration-time", 500L);
        long capacity = 10L * (long)blockSize;
        long[] dnCapacities = new long[]{capacity, capacity};
        boolean rep = true;
        long seed = 0xFAFAFAL;
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        try {
            this.cluster.getConfiguration(0).setInt("dfs.replication", 1);
            conf.setInt("dfs.replication", 1);
            this.cluster.startDataNodes((Configuration)conf, 1, true, null, null, dnCapacities);
            this.cluster.waitClusterUp();
            this.cluster.waitActive();
            Path path = new Path("/testMaxIterationTime.dat");
            DistributedFileSystem fs = this.cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, path, 4L * (long)blockSize, (short)1, 0xFAFAFAL);
            this.cluster.startDataNodes((Configuration)conf, 1, true, null, null, dnCapacities);
            this.cluster.triggerHeartbeats();
            List connectors = Collections.emptyList();
            try {
                BalancerParameters bParams = BalancerParameters.DEFAULT;
                connectors = NameNodeConnector.newNameNodeConnectors((Collection)DFSUtil.getInternalNsRpcUris((Configuration)conf), (String)Balancer.class.getSimpleName(), (Path)Balancer.BALANCER_ID_PATH, (Configuration)conf, (int)1);
                for (NameNodeConnector nnc : connectors) {
                    LOG.info("NNC to work on: " + nnc);
                    Balancer b = new Balancer(nnc, bParams, (Configuration)conf);
                    Balancer.Result r = b.runOneIteration();
                    Assert.assertEquals((String)"We expect ExitStatus.NO_MOVE_PROGRESS to be reported.", (Object)ExitStatus.NO_MOVE_PROGRESS, (Object)r.getExitStatus());
                    Assert.assertEquals((long)0L, (long)r.getBlocksMoved());
                }
            }
            catch (Throwable throwable) {
                for (NameNodeConnector nnc : connectors) {
                    IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{nnc});
                }
                throw throwable;
            }
            for (NameNodeConnector nnc : connectors) {
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{nnc});
            }
        }
        finally {
            this.cluster.shutdown(true, true);
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)Balancer.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)Dispatcher.LOG, (Level)Level.DEBUG);
        FILE_PATH = new Path(FILE_NAME);
        TestBalancerLongRunningTasks.initTestSetup();
    }
}

