/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSOpsCountStatistics;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSClientRetries;
import org.apache.hadoop.hdfs.TestDistributedFileSystem;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.server.namenode.sps.Context;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.sps.ExternalSPSContext;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.NoRedirectParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.util.DataChecksum;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestWebHDFS {
    static final Logger LOG = LoggerFactory.getLogger(TestWebHDFS.class);
    static final Random RANDOM = new Random();
    static final long systemStartTime = System.nanoTime();
    private static MiniDFSCluster cluster = null;
    public boolean attemptedRetry;

    @After
    public void tearDown() {
        if (null != cluster) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test(timeout=300000L)
    public void testLargeFile() throws Exception {
        TestWebHDFS.largeFileTest(0xC800000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void largeFileTest(long fileLength) throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Path dir = new Path("/test/largeFile");
        Assert.assertTrue((boolean)fs.mkdirs(dir));
        byte[] data = new byte[0x100000];
        RANDOM.nextBytes(data);
        byte[] expected = new byte[2 * data.length];
        System.arraycopy(data, 0, expected, 0, data.length);
        System.arraycopy(data, 0, expected, data.length, data.length);
        Path p = new Path(dir, "file");
        Ticker t = new Ticker("WRITE", "fileLength=" + fileLength, new Object[0]);
        try (FSDataOutputStream out = fs.create(p);){
            int n;
            for (long remaining = fileLength; remaining > 0L; remaining -= (long)n) {
                t.tick(fileLength - remaining, "remaining=%d", remaining);
                n = (int)Math.min(remaining, (long)data.length);
                out.write(data, 0, n);
            }
        }
        t.end(fileLength);
        Assert.assertEquals((long)fileLength, (long)fs.getFileStatus(p).getLen());
        long smallOffset = RANDOM.nextInt(0x100000) + 0x100000;
        long largeOffset = fileLength - smallOffset;
        byte[] buf = new byte[data.length];
        TestWebHDFS.verifySeek((FileSystem)fs, p, largeOffset, fileLength, buf, expected);
        TestWebHDFS.verifySeek((FileSystem)fs, p, smallOffset, fileLength, buf, expected);
        TestWebHDFS.verifyPread((FileSystem)fs, p, largeOffset, fileLength, buf, expected);
    }

    static void checkData(long offset, long remaining, int n, byte[] actual, byte[] expected) {
        if (RANDOM.nextInt(100) == 0) {
            int j = (int)(offset % (long)actual.length);
            for (int i = 0; i < n; ++i) {
                if (expected[j] != actual[i]) {
                    Assert.fail((String)("expected[" + j + "]=" + expected[j] + " != actual[" + i + "]=" + actual[i] + ", offset=" + offset + ", remaining=" + remaining + ", n=" + n));
                }
                ++j;
            }
        }
    }

    static void verifySeek(FileSystem fs, Path p, long offset, long length, byte[] buf, byte[] expected) throws IOException {
        long remaining = length - offset;
        long checked = 0L;
        LOG.info("XXX SEEK: offset=" + offset + ", remaining=" + remaining);
        Ticker t = new Ticker("SEEK", "offset=%d, remaining=%d", offset, remaining);
        FSDataInputStream in = fs.open(p, 65536);
        in.seek(offset);
        while (remaining > 0L) {
            t.tick(checked, "offset=%d, remaining=%d", offset, remaining);
            int n = (int)Math.min(remaining, (long)buf.length);
            in.readFully(buf, 0, n);
            TestWebHDFS.checkData(offset, remaining, n, buf, expected);
            offset += (long)n;
            remaining -= (long)n;
            checked += (long)n;
        }
        in.close();
        t.end(checked);
    }

    static void verifyPread(FileSystem fs, Path p, long offset, long length, byte[] buf, byte[] expected) throws IOException {
        long remaining = length - offset;
        long checked = 0L;
        LOG.info("XXX PREAD: offset=" + offset + ", remaining=" + remaining);
        Ticker t = new Ticker("PREAD", "offset=%d, remaining=%d", offset, remaining);
        FSDataInputStream in = fs.open(p, 65536);
        while (remaining > 0L) {
            t.tick(checked, "offset=%d, remaining=%d", offset, remaining);
            int n = (int)Math.min(remaining, (long)buf.length);
            in.readFully(offset, buf, 0, n);
            TestWebHDFS.checkData(offset, remaining, n, buf, expected);
            offset += (long)n;
            remaining -= (long)n;
            checked += (long)n;
        }
        in.close();
        t.end(checked);
    }

    @Test(timeout=300000L)
    public void testNamenodeRestart() throws Exception {
        GenericTestUtils.setLogLevel((Logger)NamenodeWebHdfsMethods.LOG, (Level)Level.TRACE);
        Configuration conf = WebHdfsTestUtil.createConf();
        TestDFSClientRetries.namenodeRestartTest(conf, true);
    }

    @Test(timeout=300000L)
    public void testLargeDirectory() throws Exception {
        final Configuration conf = WebHdfsTestUtil.createConf();
        int listLimit = 2;
        conf.setInt("dfs.ls.limit", 2);
        FsPermission.setUMask((Configuration)conf, (FsPermission)new FsPermission(63));
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs").setPermission(new Path("/"), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"not-superuser", (String[])new String[]{"not-supergroup"}));
        UserGroupInformation.createUserForTesting((String)"me", (String[])new String[]{"my-group"}).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException, URISyntaxException {
                WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
                Path d = new Path("/my-dir");
                Assert.assertTrue((boolean)fs.mkdirs(d));
                RemoteIterator it = fs.listStatusIterator(d);
                Assert.assertFalse((boolean)it.hasNext());
                Path p = new Path(d, "file-0");
                Assert.assertTrue((boolean)fs.createNewFile(p));
                it = fs.listStatusIterator(d);
                Assert.assertTrue((boolean)it.hasNext());
                it.next();
                Assert.assertFalse((boolean)it.hasNext());
                for (int i = 1; i < 6; ++i) {
                    p = new Path(d, "file-" + i);
                    Assert.assertTrue((boolean)fs.createNewFile(p));
                }
                FileStatus[] statuses = fs.listStatus(d);
                Assert.assertEquals((long)6L, (long)statuses.length);
                GenericTestUtils.setLogLevel((Logger)WebHdfsFileSystem.LOG, (Level)Level.TRACE);
                GenericTestUtils.setLogLevel((Logger)NamenodeWebHdfsMethods.LOG, (Level)Level.TRACE);
                it = fs.listStatusIterator(d);
                int count = 0;
                while (it.hasNext()) {
                    FileStatus stat = (FileStatus)it.next();
                    Assert.assertEquals((String)"FileStatuses not equal", (Object)statuses[count], (Object)stat);
                    ++count;
                }
                Assert.assertEquals((String)"Different # of statuses!", (long)statuses.length, (long)count);
                it = fs.listStatusIterator(d);
                for (int i = 0; i < statuses.length; ++i) {
                    FileStatus stat = (FileStatus)it.next();
                    Assert.assertEquals((String)"FileStatuses not equal", (Object)statuses[i], (Object)stat);
                }
                Assert.assertFalse((String)"No more items expected", (boolean)it.hasNext());
                try {
                    it.next();
                    Assert.fail((String)"Iterator should error if out of elements.");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceedingFileSpaceQuota() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        long spaceQuota = 0x3200000L;
        long fileLength = 0x5000000L;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Path dir = new Path("/test/largeFile");
        Assert.assertTrue((boolean)fs.mkdirs(dir));
        byte[] data = new byte[0x100000];
        RANDOM.nextBytes(data);
        cluster.getFileSystem().setQuota(dir, Long.MAX_VALUE, spaceQuota);
        Path p = new Path(dir, "file");
        FSDataOutputStream out = fs.create(p);
        try {
            int n;
            for (long remaining = fileLength; remaining > 0L; remaining -= (long)n) {
                n = (int)Math.min(remaining, (long)data.length);
                out.write(data, 0, n);
            }
            Assert.fail((String)"should have thrown exception during the write");
        }
        catch (DSQuotaExceededException dSQuotaExceededException) {
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    @Test(timeout=300000L)
    public void testCustomizedUserAndGroupNames() throws Exception {
        final Configuration conf = WebHdfsTestUtil.createConf();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.set("dfs.webhdfs.user.provider.user.pattern", "^[A-Za-z0-9_][A-Za-z0-9._-]*[$]?$");
        conf.set("dfs.webhdfs.acl.provider.permission.pattern", "^(default:)?(user|group|mask|other):[[0-9A-Za-z_][@A-Za-z0-9._-]]*:([rwx-]{3})?(,(default:)?(user|group|mask|other):[[0-9A-Za-z_][@A-Za-z0-9._-]]*:([rwx-]{3})?)*$");
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs").setPermission(new Path("/"), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        UserGroupInformation.createUserForTesting((String)"123", (String[])new String[]{"my-group"}).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException, URISyntaxException {
                WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
                Path d = new Path("/my-dir");
                Assert.assertTrue((boolean)fs.mkdirs(d));
                fs.modifyAclEntries(d, (List)ImmutableList.of((Object)new AclEntry.Builder().setPermission(FsAction.READ).setScope(AclEntryScope.DEFAULT).setType(AclEntryType.USER).setName("11010").build(), (Object)new AclEntry.Builder().setPermission(FsAction.READ_WRITE).setType(AclEntryType.GROUP).setName("foo@bar").build()));
                return null;
            }
        });
    }

    @Test(timeout=300000L)
    public void testCreateWithNoDN() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            conf.setInt("dfs.replication", 1);
            cluster.waitActive();
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            fs.create(new Path("/testnodatanode"));
            Assert.fail((String)"No exception was thrown");
        }
        catch (IOException ex) {
            GenericTestUtils.assertExceptionContains((String)"Failed to find datanode", (Throwable)ex);
        }
    }

    @Test
    public void testWebHdfsAllowandDisallowSnapshots() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Path bar = new Path("/bar");
        dfs.mkdirs(bar);
        webHdfs.allowSnapshot(bar);
        Assert.assertTrue((boolean)dfs.getFileStatus(bar).isSnapshotEnabled());
        Assert.assertTrue((boolean)webHdfs.getFileStatus(bar).isSnapshotEnabled());
        webHdfs.createSnapshot(bar, "s1");
        Path s1path = SnapshotTestHelper.getSnapshotRoot(bar, "s1");
        Assert.assertTrue((boolean)webHdfs.exists(s1path));
        SnapshottableDirectoryStatus[] snapshottableDirs = dfs.getSnapshottableDirListing();
        Assert.assertEquals((long)1L, (long)snapshottableDirs.length);
        Assert.assertEquals((Object)bar, (Object)snapshottableDirs[0].getFullPath());
        dfs.deleteSnapshot(bar, "s1");
        dfs.disallowSnapshot(bar);
        Assert.assertFalse((boolean)dfs.getFileStatus(bar).isSnapshotEnabled());
        Assert.assertFalse((boolean)webHdfs.getFileStatus(bar).isSnapshotEnabled());
        snapshottableDirs = dfs.getSnapshottableDirListing();
        Assert.assertNull((Object)snapshottableDirs);
        dfs.allowSnapshot(bar);
        Assert.assertTrue((boolean)dfs.getFileStatus(bar).isSnapshotEnabled());
        Assert.assertTrue((boolean)webHdfs.getFileStatus(bar).isSnapshotEnabled());
        snapshottableDirs = dfs.getSnapshottableDirListing();
        Assert.assertEquals((long)1L, (long)snapshottableDirs.length);
        Assert.assertEquals((Object)bar, (Object)snapshottableDirs[0].getFullPath());
        webHdfs.disallowSnapshot(bar);
        Assert.assertFalse((boolean)dfs.getFileStatus(bar).isSnapshotEnabled());
        Assert.assertFalse((boolean)webHdfs.getFileStatus(bar).isSnapshotEnabled());
        snapshottableDirs = dfs.getSnapshottableDirListing();
        Assert.assertNull((Object)snapshottableDirs);
        try {
            webHdfs.createSnapshot(bar);
            Assert.fail((String)"Cannot create snapshot on a non-snapshottable directory");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"Directory is not a snapshottable directory", (Throwable)e);
        }
    }

    @Test(timeout=60000L)
    public void testWebHdfsErasureCodingFiles() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        dfs.enableErasureCodingPolicy(SystemErasureCodingPolicies.getByID((byte)4).getName());
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Path ecDir = new Path("/ec");
        dfs.mkdirs(ecDir);
        dfs.setErasureCodingPolicy(ecDir, SystemErasureCodingPolicies.getByID((byte)4).getName());
        Path ecFile = new Path(ecDir, "ec-file.log");
        DFSTestUtil.createFile((FileSystem)dfs, ecFile, 10240L, (short)1, 65261L);
        Path normalDir = new Path("/dir");
        dfs.mkdirs(normalDir);
        Path normalFile = new Path(normalDir, "file.log");
        DFSTestUtil.createFile((FileSystem)dfs, normalFile, 10240L, (short)1, 65261L);
        FileStatus expectedECDirStatus = dfs.getFileStatus(ecDir);
        FileStatus actualECDirStatus = webHdfs.getFileStatus(ecDir);
        Assert.assertEquals((Object)expectedECDirStatus.isErasureCoded(), (Object)actualECDirStatus.isErasureCoded());
        ContractTestUtils.assertErasureCoded((FileSystem)dfs, (Path)ecDir);
        Assert.assertTrue((String)(ecDir + " should have erasure coding set in FileStatus#toString(): " + actualECDirStatus), (boolean)actualECDirStatus.toString().contains("isErasureCoded=true"));
        FileStatus expectedECFileStatus = dfs.getFileStatus(ecFile);
        FileStatus actualECFileStatus = webHdfs.getFileStatus(ecFile);
        Assert.assertEquals((Object)expectedECFileStatus.isErasureCoded(), (Object)actualECFileStatus.isErasureCoded());
        ContractTestUtils.assertErasureCoded((FileSystem)dfs, (Path)ecFile);
        Assert.assertTrue((String)(ecFile + " should have erasure coding set in FileStatus#toString(): " + actualECFileStatus), (boolean)actualECFileStatus.toString().contains("isErasureCoded=true"));
        FileStatus expectedNormalDirStatus = dfs.getFileStatus(normalDir);
        FileStatus actualNormalDirStatus = webHdfs.getFileStatus(normalDir);
        Assert.assertEquals((Object)expectedNormalDirStatus.isErasureCoded(), (Object)actualNormalDirStatus.isErasureCoded());
        ContractTestUtils.assertNotErasureCoded((FileSystem)dfs, (Path)normalDir);
        Assert.assertTrue((String)(normalDir + " should have erasure coding unset in FileStatus#toString(): " + actualNormalDirStatus), (boolean)actualNormalDirStatus.toString().contains("isErasureCoded=false"));
        FileStatus expectedNormalFileStatus = dfs.getFileStatus(normalFile);
        FileStatus actualNormalFileStatus = webHdfs.getFileStatus(normalDir);
        Assert.assertEquals((Object)expectedNormalFileStatus.isErasureCoded(), (Object)actualNormalFileStatus.isErasureCoded());
        ContractTestUtils.assertNotErasureCoded((FileSystem)dfs, (Path)normalFile);
        Assert.assertTrue((String)(normalFile + " should have erasure coding unset in FileStatus#toString(): " + actualNormalFileStatus), (boolean)actualNormalFileStatus.toString().contains("isErasureCoded=false"));
    }

    @Test
    public void testWebHdfsCreateSnapshot() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Path foo = new Path("/foo");
        dfs.mkdirs(foo);
        try {
            webHdfs.createSnapshot(foo);
            Assert.fail((String)"Cannot create snapshot on a non-snapshottable directory");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"Directory is not a snapshottable directory", (Throwable)e);
        }
        dfs.allowSnapshot(foo);
        webHdfs.createSnapshot(foo, "s1");
        Path spath = webHdfs.createSnapshot(foo, null);
        Assert.assertTrue((boolean)webHdfs.exists(spath));
        Path s1path = SnapshotTestHelper.getSnapshotRoot(foo, "s1");
        Assert.assertTrue((boolean)webHdfs.exists(s1path));
    }

    @Test
    public void testWebHdfsDeleteSnapshot() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Path foo = new Path("/foo");
        dfs.mkdirs(foo);
        dfs.allowSnapshot(foo);
        webHdfs.createSnapshot(foo, "s1");
        Path spath = webHdfs.createSnapshot(foo, null);
        Assert.assertTrue((boolean)webHdfs.exists(spath));
        Path s1path = SnapshotTestHelper.getSnapshotRoot(foo, "s1");
        Assert.assertTrue((boolean)webHdfs.exists(s1path));
        try {
            webHdfs.deleteSnapshot(foo, null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (RemoteException e) {
            Assert.assertEquals((Object)"Required param snapshotname for op: DELETESNAPSHOT is null or empty", (Object)e.getLocalizedMessage());
        }
        webHdfs.deleteSnapshot(foo, "s1");
        Assert.assertFalse((boolean)webHdfs.exists(s1path));
        webHdfs.deleteSnapshot(foo, spath.getName());
        Assert.assertFalse((boolean)webHdfs.exists(spath));
    }

    @Test
    public void testWebHdfsSnapshotDiff() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Path foo = new Path("/foo");
        dfs.mkdirs(foo);
        Path file0 = new Path(foo, "file0");
        DFSTestUtil.createFile((FileSystem)dfs, file0, 100L, (short)1, 0L);
        Path file1 = new Path(foo, "file1");
        DFSTestUtil.createFile((FileSystem)dfs, file1, 100L, (short)1, 0L);
        Path file2 = new Path(foo, "file2");
        DFSTestUtil.createFile((FileSystem)dfs, file2, 100L, (short)1, 0L);
        dfs.allowSnapshot(foo);
        webHdfs.createSnapshot(foo, "s1");
        Path s1path = SnapshotTestHelper.getSnapshotRoot(foo, "s1");
        Assert.assertTrue((boolean)webHdfs.exists(s1path));
        Path file3 = new Path(foo, "file3");
        DFSTestUtil.createFile((FileSystem)dfs, file3, 100L, (short)1, 0L);
        DFSTestUtil.appendFile((FileSystem)dfs, file0, 100);
        dfs.delete(file1, false);
        Path file4 = new Path(foo, "file4");
        dfs.rename(file2, file4);
        webHdfs.createSnapshot(foo, "s2");
        SnapshotDiffReport diffReport = webHdfs.getSnapshotDiffReport(foo, "s1", "s2");
        Assert.assertEquals((Object)"/foo", (Object)diffReport.getSnapshotRoot());
        Assert.assertEquals((Object)"s1", (Object)diffReport.getFromSnapshot());
        Assert.assertEquals((Object)"s2", (Object)diffReport.getLaterSnapshotName());
        SnapshotDiffReport.DiffReportEntry entry0 = new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)""));
        SnapshotDiffReport.DiffReportEntry entry1 = new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file0"));
        SnapshotDiffReport.DiffReportEntry entry2 = new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file1"));
        SnapshotDiffReport.DiffReportEntry entry3 = new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"file2"), DFSUtil.string2Bytes((String)"file4"));
        SnapshotDiffReport.DiffReportEntry entry4 = new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file3"));
        Assert.assertTrue((boolean)diffReport.getDiffList().contains(entry0));
        Assert.assertTrue((boolean)diffReport.getDiffList().contains(entry1));
        Assert.assertTrue((boolean)diffReport.getDiffList().contains(entry2));
        Assert.assertTrue((boolean)diffReport.getDiffList().contains(entry3));
        Assert.assertTrue((boolean)diffReport.getDiffList().contains(entry4));
        Assert.assertEquals((long)diffReport.getDiffList().size(), (long)5L);
        diffReport = webHdfs.getSnapshotDiffReport(foo, null, "s2");
        Assert.assertEquals((long)diffReport.getDiffList().size(), (long)0L);
        diffReport = webHdfs.getSnapshotDiffReport(foo, "s1", null);
        Assert.assertEquals((long)diffReport.getDiffList().size(), (long)5L);
    }

    @Test
    public void testWebHdfsSnapshottableDirectoryList() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Path foo = new Path("/foo");
        Path bar = new Path("/bar");
        dfs.mkdirs(foo);
        dfs.mkdirs(bar);
        SnapshottableDirectoryStatus[] statuses = webHdfs.getSnapshottableDirectoryList();
        Assert.assertNull((Object)statuses);
        dfs.allowSnapshot(foo);
        dfs.allowSnapshot(bar);
        Path file0 = new Path(foo, "file0");
        DFSTestUtil.createFile((FileSystem)dfs, file0, 100L, (short)1, 0L);
        Path file1 = new Path(bar, "file1");
        DFSTestUtil.createFile((FileSystem)dfs, file1, 100L, (short)1, 0L);
        statuses = webHdfs.getSnapshottableDirectoryList();
        SnapshottableDirectoryStatus[] dfsStatuses = dfs.getSnapshottableDirListing();
        for (int i = 0; i < dfsStatuses.length; ++i) {
            Assert.assertEquals((long)statuses[i].getSnapshotNumber(), (long)dfsStatuses[i].getSnapshotNumber());
            Assert.assertEquals((long)statuses[i].getSnapshotQuota(), (long)dfsStatuses[i].getSnapshotQuota());
            Assert.assertTrue((boolean)Arrays.equals(statuses[i].getParentFullPath(), dfsStatuses[i].getParentFullPath()));
            Assert.assertEquals((long)dfsStatuses[i].getDirStatus().getChildrenNum(), (long)statuses[i].getDirStatus().getChildrenNum());
            Assert.assertEquals((long)dfsStatuses[i].getDirStatus().getModificationTime(), (long)statuses[i].getDirStatus().getModificationTime());
            Assert.assertEquals((Object)dfsStatuses[i].getDirStatus().isDir(), (Object)statuses[i].getDirStatus().isDir());
            Assert.assertEquals((long)dfsStatuses[i].getDirStatus().getAccessTime(), (long)statuses[i].getDirStatus().getAccessTime());
            Assert.assertEquals((Object)dfsStatuses[i].getDirStatus().getPermission(), (Object)statuses[i].getDirStatus().getPermission());
            Assert.assertEquals((Object)dfsStatuses[i].getDirStatus().getOwner(), (Object)statuses[i].getDirStatus().getOwner());
            Assert.assertEquals((Object)dfsStatuses[i].getDirStatus().getGroup(), (Object)statuses[i].getDirStatus().getGroup());
            Assert.assertEquals((Object)dfsStatuses[i].getDirStatus().getPath(), (Object)statuses[i].getDirStatus().getPath());
            Assert.assertEquals((long)dfsStatuses[i].getDirStatus().getFileId(), (long)statuses[i].getDirStatus().getFileId());
            Assert.assertEquals((Object)dfsStatuses[i].getDirStatus().hasAcl(), (Object)statuses[i].getDirStatus().hasAcl());
            Assert.assertEquals((Object)dfsStatuses[i].getDirStatus().isEncrypted(), (Object)statuses[i].getDirStatus().isEncrypted());
            Assert.assertEquals((Object)dfsStatuses[i].getDirStatus().isErasureCoded(), (Object)statuses[i].getDirStatus().isErasureCoded());
            Assert.assertEquals((Object)dfsStatuses[i].getDirStatus().isSnapshotEnabled(), (Object)statuses[i].getDirStatus().isSnapshotEnabled());
        }
    }

    @Test
    public void testWebHdfsCreateNonRecursive() throws IOException, URISyntaxException {
        Configuration conf = WebHdfsTestUtil.createConf();
        try (WebHdfsFileSystem webHdfs = null;){
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            TestFileCreation.testFileCreationNonRecursive((FileSystem)webHdfs);
        }
    }

    @Test
    public void testWebHdfsRenameSnapshot() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Path foo = new Path("/foo");
        dfs.mkdirs(foo);
        dfs.allowSnapshot(foo);
        webHdfs.createSnapshot(foo, "s1");
        Path s1path = SnapshotTestHelper.getSnapshotRoot(foo, "s1");
        Assert.assertTrue((boolean)webHdfs.exists(s1path));
        try {
            webHdfs.renameSnapshot(foo, null, "s2");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (RemoteException e) {
            Assert.assertEquals((Object)"Required param oldsnapshotname for op: RENAMESNAPSHOT is null or empty", (Object)e.getLocalizedMessage());
        }
        webHdfs.renameSnapshot(foo, "s1", "s2");
        Assert.assertFalse((boolean)webHdfs.exists(s1path));
        Path s2path = SnapshotTestHelper.getSnapshotRoot(foo, "s2");
        Assert.assertTrue((boolean)webHdfs.exists(s2path));
        webHdfs.deleteSnapshot(foo, "s2");
        Assert.assertFalse((boolean)webHdfs.exists(s2path));
    }

    @Test
    public void testRaceWhileNNStartup() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.waitActive();
        NameNode namenode = cluster.getNameNode();
        NamenodeProtocols rpcServer = namenode.getRpcServer();
        Whitebox.setInternalState((Object)namenode, (String)"rpcServer", null);
        Path foo = new Path("/foo");
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        try {
            webHdfs.mkdirs(foo);
            Assert.fail((String)"Expected RetriableException");
        }
        catch (RetriableException e) {
            GenericTestUtils.assertExceptionContains((String)"Namenode is in startup mode", (Throwable)e);
        }
        Whitebox.setInternalState((Object)namenode, (String)"rpcServer", (Object)rpcServer);
    }

    @Test
    public void testDTInInsecureClusterWithFallback() throws IOException, URISyntaxException {
        Configuration conf = WebHdfsTestUtil.createConf();
        conf.setBoolean("ipc.client.fallback-to-simple-auth-allowed", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Assert.assertNull((Object)webHdfs.getDelegationToken(null));
    }

    @Test
    public void testDTInInsecureCluster() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            webHdfs.getDelegationToken(null);
            Assert.fail((String)"No exception is thrown.");
        }
        catch (AccessControlException ace) {
            Assert.assertTrue((boolean)ace.getMessage().startsWith("The client is configured to only allow connecting to secure cluster"));
        }
    }

    @Test
    public void testWebHdfsOffsetAndLength() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        int OFFSET = 42;
        int LENGTH = 512;
        String PATH = "/foo";
        byte[] CONTENTS = new byte[1024];
        RANDOM.nextBytes(CONTENTS);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        try (FSDataOutputStream os = fs.create(new Path("/foo"));){
            os.write(CONTENTS);
        }
        InetSocketAddress addr = cluster.getNameNode().getHttpAddress();
        URL url = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/foo?op=OPEN" + Param.toSortedString((String)"&", (Param[])new Param[]{new OffsetParam(Long.valueOf(42L)), new LengthParam(Long.valueOf(512L))}));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(true);
        Assert.assertEquals((long)512L, (long)conn.getContentLength());
        byte[] subContents = new byte[512];
        byte[] realContents = new byte[512];
        System.arraycopy(CONTENTS, 42, subContents, 0, 512);
        IOUtils.readFully((InputStream)conn.getInputStream(), (byte[])realContents);
        Assert.assertArrayEquals((byte[])subContents, (byte[])realContents);
    }

    @Test
    public void testContentSummary() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        Path path = new Path("/QuotaDir");
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        DistributedFileSystem dfs = cluster.getFileSystem();
        dfs.mkdirs(path);
        dfs.setQuotaByStorageType(path, StorageType.DISK, 100000L);
        ContentSummary contentSummary = webHdfs.getContentSummary(path);
        Assert.assertTrue((contentSummary.getTypeQuota(StorageType.DISK) == 100000L ? 1 : 0) != 0);
    }

    @Test
    public void testSnapshotInContentSummary() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        Path dirPath = new Path("/dir");
        Path filePath = new Path("/dir/file");
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        DistributedFileSystem dfs = cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)dfs, filePath, 10L, (short)3, 0L);
        dfs.allowSnapshot(dirPath);
        dfs.createSnapshot(dirPath);
        dfs.delete(filePath, true);
        ContentSummary contentSummary = webHdfs.getContentSummary(dirPath);
        Assert.assertEquals((long)1L, (long)contentSummary.getSnapshotFileCount());
        Assert.assertEquals((long)10L, (long)contentSummary.getSnapshotLength());
        Assert.assertEquals((long)30L, (long)contentSummary.getSnapshotSpaceConsumed());
        Assert.assertEquals((Object)dfs.getContentSummary(dirPath), (Object)webHdfs.getContentSummary(dirPath));
    }

    @Test
    public void testQuotaUsage() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        Path path = new Path("/TestDir");
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        DistributedFileSystem dfs = cluster.getFileSystem();
        long nsQuota = 100L;
        long spaceQuota = 629145600L;
        long diskQuota = 100000L;
        byte[] bytes = new byte[]{0, 1, 2, 3};
        dfs.mkdirs(path);
        dfs.setQuota(path, 100L, 629145600L);
        for (int i = 0; i < 10; ++i) {
            dfs.createNewFile(new Path(path, "test_file_" + i));
        }
        FSDataOutputStream out = dfs.create(new Path(path, "test_file"));
        out.write(bytes);
        out.close();
        dfs.setQuotaByStorageType(path, StorageType.DISK, 100000L);
        QuotaUsage quotaUsage = webHdfs.getQuotaUsage(path);
        Assert.assertEquals((long)12L, (long)quotaUsage.getFileAndDirectoryCount());
        Assert.assertEquals((long)100L, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)(bytes.length * dfs.getDefaultReplication()), (long)quotaUsage.getSpaceConsumed());
        Assert.assertEquals((long)629145600L, (long)quotaUsage.getSpaceQuota());
        Assert.assertEquals((long)100000L, (long)quotaUsage.getTypeQuota(StorageType.DISK));
    }

    @Test
    public void testSetQuota() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        Path path = new Path("/TestDir");
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        DistributedFileSystem dfs = cluster.getFileSystem();
        long nsQuota = 100L;
        long spaceQuota = 1024L;
        webHdfs.mkdirs(path);
        webHdfs.setQuota(path, 100L, 1024L);
        QuotaUsage quotaUsage = dfs.getQuotaUsage(path);
        Assert.assertEquals((long)100L, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)1024L, (long)quotaUsage.getSpaceQuota());
        webHdfs.setQuota(path, -1L, -1L);
        quotaUsage = dfs.getQuotaUsage(path);
        Assert.assertEquals((long)-1L, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)-1L, (long)quotaUsage.getSpaceQuota());
        webHdfs.setQuotaByStorageType(path, StorageType.DISK, 1024L);
        webHdfs.setQuotaByStorageType(path, StorageType.ARCHIVE, 1024L);
        webHdfs.setQuotaByStorageType(path, StorageType.SSD, 1024L);
        quotaUsage = dfs.getQuotaUsage(path);
        Assert.assertEquals((long)1024L, (long)quotaUsage.getTypeQuota(StorageType.DISK));
        Assert.assertEquals((long)1024L, (long)quotaUsage.getTypeQuota(StorageType.ARCHIVE));
        Assert.assertEquals((long)1024L, (long)quotaUsage.getTypeQuota(StorageType.SSD));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> webHdfs.setQuota(path, -100L, 100L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> webHdfs.setQuota(path, 100L, -100L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> webHdfs.setQuotaByStorageType(path, StorageType.SSD, -100L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> webHdfs.setQuotaByStorageType(path, null, 100L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> webHdfs.setQuotaByStorageType(path, StorageType.SSD, -100L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> webHdfs.setQuotaByStorageType(path, StorageType.RAM_DISK, 100L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebHdfsPread() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        byte[] content = new byte[1024];
        RANDOM.nextBytes(content);
        Path foo = new Path("/foo");
        try (FSDataInputStream in = null;){
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            try (FSDataOutputStream os = fs.create(foo);){
                os.write(content);
            }
            in = fs.open(foo, 1024);
            byte[] buf = new byte[1024];
            try {
                in.readFully(1020L, buf, 0, 5);
                Assert.fail((String)"EOF expected");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            int length = in.read(buf, 0, 512);
            in.readFully(100L, new byte[1024], 0, 100);
            int preadLen = in.read(200L, new byte[1024], 0, 200);
            Assert.assertTrue((preadLen > 0 ? 1 : 0) != 0);
            IOUtils.readFully((InputStream)in, (byte[])buf, (int)length, (int)(1024 - length));
            Assert.assertArrayEquals((byte[])content, (byte[])buf);
        }
    }

    @Test(timeout=30000L)
    public void testGetHomeDirectory() throws Exception {
        Configuration conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        DistributedFileSystem hdfs = cluster.getFileSystem();
        URI uri = new URI("webhdfs://" + cluster.getHttpUri(0).replace("http://", ""));
        Configuration confTemp = new Configuration();
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)confTemp);
        Assert.assertEquals((Object)hdfs.getHomeDirectory().toUri().getPath(), (Object)webhdfs.getHomeDirectory().toUri().getPath());
        webhdfs.close();
        webhdfs = this.createWebHDFSAsTestUser(confTemp, uri, "XXX");
        Assert.assertNotEquals((Object)hdfs.getHomeDirectory().toUri().getPath(), (Object)webhdfs.getHomeDirectory().toUri().getPath());
        webhdfs.close();
    }

    @Test
    public void testWebHdfsGetBlockLocationsWithStorageType() throws Exception {
        BlockLocation[] locations;
        Configuration conf = WebHdfsTestUtil.createConf();
        int OFFSET = 42;
        int LENGTH = 512;
        Path PATH = new Path("/foo");
        byte[] CONTENTS = new byte[1024];
        RANDOM.nextBytes(CONTENTS);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        BlockLocation[] blockLocationArray = null;
        try (FSDataOutputStream os = fs.create(PATH);){
            os.write(CONTENTS);
        }
        catch (Throwable object) {
            blockLocationArray = object;
            throw object;
        }
        for (BlockLocation location : locations = fs.getFileBlockLocations(PATH, 42L, 512L)) {
            StorageType[] storageTypes = location.getStorageTypes();
            Assert.assertTrue((storageTypes != null && storageTypes.length > 0 && storageTypes[0] == StorageType.DISK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWebHdfsGetBlockLocations() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        int offset = 42;
        int length = 512;
        Path path = new Path("/foo");
        byte[] contents = new byte[1024];
        RANDOM.nextBytes(contents);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        try (FSDataOutputStream os = fs.create(path);){
            os.write(contents);
        }
        BlockLocation[] locations = fs.getFileBlockLocations(path, 42L, 512L);
        InetSocketAddress addr = cluster.getNameNode().getHttpAddress();
        URL url1 = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/foo?op=GETFILEBLOCKLOCATIONS");
        String response1 = TestWebHDFS.getResponse(url1, "GET");
        BlockLocation[] locationArray1 = this.toBlockLocationArray(response1);
        this.verifyEquals(locations, locationArray1);
        URL url2 = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/foo?op=GETFILEBLOCKLOCATIONS&length=512&offset=42");
        String response2 = TestWebHDFS.getResponse(url2, "GET");
        BlockLocation[] locationArray2 = this.toBlockLocationArray(response2);
        this.verifyEquals(locations, locationArray2);
        URL url3 = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/foo?op=GETFILEBLOCKLOCATIONS&length=512");
        String response3 = TestWebHDFS.getResponse(url3, "GET");
        BlockLocation[] locationArray3 = this.toBlockLocationArray(response3);
        this.verifyEquals(locations, locationArray3);
        URL url4 = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/foo?op=GETFILEBLOCKLOCATIONS&offset=42");
        String response4 = TestWebHDFS.getResponse(url4, "GET");
        BlockLocation[] locationArray4 = this.toBlockLocationArray(response4);
        this.verifyEquals(locations, locationArray4);
        URL url5 = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/foo?op=GETFILEBLOCKLOCATIONS&offset=1200");
        String response5 = TestWebHDFS.getResponse(url5, "GET");
        BlockLocation[] locationArray5 = this.toBlockLocationArray(response5);
        this.verifyEquals(new BlockLocation[0], locationArray5);
    }

    private BlockLocation[] toBlockLocationArray(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        MapType subType = mapper.getTypeFactory().constructMapType(Map.class, String.class, BlockLocation[].class);
        MapType rootType = mapper.getTypeFactory().constructMapType(Map.class, mapper.constructType(String.class), mapper.constructType((Type)subType));
        Map jsonMap = (Map)mapper.readValue(json, (JavaType)rootType);
        Map locationMap = (Map)jsonMap.get("BlockLocations");
        BlockLocation[] locationArray = (BlockLocation[])locationMap.get(BlockLocation.class.getSimpleName());
        return locationArray;
    }

    private void verifyEquals(BlockLocation[] locations1, BlockLocation[] locations2) throws IOException {
        for (int i = 0; i < locations1.length; ++i) {
            BlockLocation location1 = locations1[i];
            BlockLocation location2 = locations2[i];
            Assert.assertEquals((long)location1.getLength(), (long)location2.getLength());
            Assert.assertEquals((long)location1.getOffset(), (long)location2.getOffset());
            Assert.assertArrayEquals((Object[])location1.getCachedHosts(), (Object[])location2.getCachedHosts());
            Assert.assertArrayEquals((Object[])location1.getHosts(), (Object[])location2.getHosts());
            Assert.assertArrayEquals((Object[])location1.getNames(), (Object[])location2.getNames());
            Assert.assertArrayEquals((Object[])location1.getTopologyPaths(), (Object[])location2.getTopologyPaths());
            Assert.assertArrayEquals((Object[])location1.getStorageTypes(), (Object[])location2.getStorageTypes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResponse(URL url, String httpRequestType) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(httpRequestType);
            conn.setInstanceFollowRedirects(false);
            String string = IOUtils.toString((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private WebHdfsFileSystem createWebHDFSAsTestUser(final Configuration conf, final URI uri, String userName) throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)userName, (String[])new String[]{"supergroup"});
        return (WebHdfsFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<WebHdfsFileSystem>(){

            @Override
            public WebHdfsFileSystem run() throws IOException {
                WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
                return webhdfs;
            }
        });
    }

    @Test(timeout=90000L)
    public void testWebHdfsReadRetries() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        Path dir = new Path("/testWebHdfsReadRetries");
        conf.setBoolean("dfs.client.retry.policy.enabled", true);
        conf.setInt("dfs.namenode.safemode.min.datanodes", 1);
        conf.setInt("dfs.blocksize", 524288);
        conf.setInt("dfs.replication", 1);
        boolean numDatanodes = true;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        long length = 0x100000L;
        Path file1 = new Path(dir, "testFile");
        DFSTestUtil.createFile((FileSystem)fs, file1, 0x100000L, (short)1, 20120406L);
        FileStatus s1 = fs.getFileStatus(file1);
        Assert.assertEquals((String)("Write failed for file " + file1), (long)0x100000L, (long)s1.getLen());
        FSDataInputStream in = fs.open(file1);
        Assert.assertTrue((String)"Input stream is not an instance of class WebHdfsInputStream", (boolean)(in.getWrappedStream() instanceof WebHdfsFileSystem.WebHdfsInputStream));
        int count = 0;
        while (in.read() != -1) {
            ++count;
        }
        Assert.assertEquals((String)("Read failed for file " + file1), (long)s1.getLen(), (long)count);
        Assert.assertEquals((String)"Sghould not be able to read beyond end of file", (long)in.read(), (long)-1L);
        in.close();
        try {
            in.read();
            Assert.fail((String)"Read after close should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        WebHdfsFileSystem wfs = fs;
        String msg = "ReadRetries: Test Access Control Exception";
        this.testReadRetryExceptionHelper(wfs, file1, (IOException)((Object)new AccessControlException(msg)), msg, false, 1);
        msg = "ReadRetries: Test SocketTimeoutException";
        this.testReadRetryExceptionHelper(wfs, file1, new SocketTimeoutException(msg), msg, true, 5);
        msg = "ReadRetries: Test SocketException";
        this.testReadRetryExceptionHelper(wfs, file1, new SocketException(msg), msg, true, 5);
        msg = "ReadRetries: Test EOFException";
        this.testReadRetryExceptionHelper(wfs, file1, new EOFException(msg), msg, true, 5);
        msg = "ReadRetries: Test Generic IO Exception";
        this.testReadRetryExceptionHelper(wfs, file1, new IOException(msg), msg, true, 5);
        WebHdfsFileSystem spyfs = (WebHdfsFileSystem)Mockito.spy((Object)wfs);
        Mockito.when((Object)spyfs.replaceExpiredDelegationToken()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        msg = "ReadRetries: Test Invalid Token Exception";
        this.testReadRetryExceptionHelper(spyfs, file1, (IOException)((Object)new SecretManager.InvalidToken(msg)), msg, false, 3);
    }

    private void testReadRetryExceptionHelper(WebHdfsFileSystem fs, Path fn, IOException ex, String msg, boolean shouldAttemptRetry, int numTimesTried) throws Exception {
        FSDataInputStream in = fs.open(fn);
        in.read();
        WebHdfsFileSystem.WebHdfsInputStream webIn = (WebHdfsFileSystem.WebHdfsInputStream)in.getWrappedStream();
        InputStream spyInputStream = (InputStream)Mockito.spy((Object)webIn.getReadRunner().getInputStream());
        ((InputStream)Mockito.doThrow((Throwable[])new Throwable[]{ex}).when((Object)spyInputStream)).read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        WebHdfsFileSystem.ReadRunner rr = (WebHdfsFileSystem.ReadRunner)Mockito.spy((Object)webIn.getReadRunner());
        ((WebHdfsFileSystem.ReadRunner)Mockito.doReturn((Object)spyInputStream).when((Object)rr)).initializeInputStream((HttpURLConnection)ArgumentMatchers.any());
        rr.setInputStream(spyInputStream);
        webIn.setReadRunner(rr);
        final RetryPolicy.RetryAction retryAction = new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.RETRY);
        final RetryPolicy.RetryAction failAction = new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL);
        RetryPolicy rp = new RetryPolicy(){

            public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
                TestWebHDFS.this.attemptedRetry = true;
                if (retries > 3) {
                    return failAction;
                }
                return retryAction;
            }
        };
        fs.setRetryPolicy(rp);
        this.attemptedRetry = false;
        try {
            webIn.read();
            Assert.fail((String)(msg + ": Read should have thrown exception."));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(msg));
        }
        Assert.assertEquals((String)(msg + ": Read should " + (shouldAttemptRetry ? "" : "not ") + "have called shouldRetry. "), (Object)this.attemptedRetry, (Object)shouldAttemptRetry);
        ((WebHdfsFileSystem.ReadRunner)Mockito.verify((Object)rr, (VerificationMode)Mockito.times((int)numTimesTried))).getResponse((HttpURLConnection)ArgumentMatchers.any());
        webIn.close();
        in.close();
    }

    private void checkResponseContainsLocation(URL url, String TYPE) throws JSONException, IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(TYPE);
        conn.setInstanceFollowRedirects(false);
        String response = IOUtils.toString((InputStream)conn.getInputStream(), (Charset)Charset.defaultCharset());
        LOG.info("Response was : " + response);
        Assert.assertEquals((String)"Response wasn't 200", (long)200L, (long)conn.getResponseCode());
        JSONObject responseJson = new JSONObject(response);
        Assert.assertTrue((String)("Response didn't give us a location. " + response), (boolean)responseJson.has("Location"));
        if (TYPE.equals("CREATE")) {
            URL dnLocation = new URL(responseJson.getString("Location"));
            HttpURLConnection dnConn = (HttpURLConnection)dnLocation.openConnection();
            dnConn.setRequestMethod("OPTIONS");
            Assert.assertEquals((String)("Datanode url : " + dnLocation + " didn't allow CORS"), (long)200L, (long)dnConn.getResponseCode());
        }
    }

    @Test
    public void testWebHdfsNoRedirect() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        LOG.info("Started cluster");
        InetSocketAddress addr = cluster.getNameNode().getHttpAddress();
        URL url = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/testWebHdfsNoRedirectCreate?op=CREATE" + Param.toSortedString((String)"&", (Param[])new Param[]{new NoRedirectParam(Boolean.valueOf(true))}));
        LOG.info("Sending create request " + url);
        this.checkResponseContainsLocation(url, "PUT");
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        String PATH = "/testWebHdfsNoRedirect";
        byte[] CONTENTS = new byte[1024];
        RANDOM.nextBytes(CONTENTS);
        try (FSDataOutputStream os = fs.create(new Path("/testWebHdfsNoRedirect"));){
            os.write(CONTENTS);
        }
        url = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/testWebHdfsNoRedirect?op=OPEN" + Param.toSortedString((String)"&", (Param[])new Param[]{new NoRedirectParam(Boolean.valueOf(true))}));
        LOG.info("Sending open request " + url);
        this.checkResponseContainsLocation(url, "GET");
        url = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/testWebHdfsNoRedirect?op=GETFILECHECKSUM" + Param.toSortedString((String)"&", (Param[])new Param[]{new NoRedirectParam(Boolean.valueOf(true))}));
        LOG.info("Sending getfilechecksum request " + url);
        this.checkResponseContainsLocation(url, "GET");
        url = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/testWebHdfsNoRedirect?op=APPEND" + Param.toSortedString((String)"&", (Param[])new Param[]{new NoRedirectParam(Boolean.valueOf(true))}));
        LOG.info("Sending append request " + url);
        this.checkResponseContainsLocation(url, "POST");
    }

    @Test
    public void testGetTrashRoot() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        WebHdfsFileSystem webFS = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Path trashPath = webFS.getTrashRoot(new Path("/"));
        Path expectedPath = new Path("/user", new Path(currentUser, ".Trash"));
        Assert.assertEquals((Object)expectedPath.toUri().getPath(), (Object)trashPath.toUri().getPath());
    }

    @Test
    public void testGetEZTrashRoot() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        FileSystemTestHelper fsHelper = new FileSystemTestHelper();
        File testRootDir = new File(fsHelper.getTestRootDir()).getAbsoluteFile();
        conf.set("hadoop.security.key.provider.path", "jceks://file" + new Path(testRootDir.toString(), "test.jks").toUri());
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        WebHdfsFileSystem webhdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        HdfsAdmin dfsAdmin = new HdfsAdmin(cluster.getURI(), conf);
        dfs.getClient().setKeyProvider((KeyProvider)cluster.getNameNode().getNamesystem().getProvider());
        String testkey = "test_key";
        DFSTestUtil.createKey("test_key", cluster, conf);
        Path zone1 = new Path("/zone1");
        dfs.mkdirs(zone1, new FsPermission(700));
        dfsAdmin.createEncryptionZone(zone1, "test_key", EnumSet.of(CreateEncryptionZoneFlag.PROVISION_TRASH));
        Path insideEZ = new Path(zone1, "insideEZ");
        dfs.mkdirs(insideEZ, new FsPermission(700));
        Assert.assertEquals((Object)dfs.getTrashRoot(insideEZ).toUri().getPath(), (Object)webhdfs.getTrashRoot(insideEZ).toUri().getPath());
        Path outsideEZ = new Path("/outsideEZ");
        dfs.mkdirs(outsideEZ, new FsPermission(755));
        Assert.assertEquals((Object)dfs.getTrashRoot(outsideEZ).toUri().getPath(), (Object)webhdfs.getTrashRoot(outsideEZ).toUri().getPath());
        Path root = new Path("/");
        Assert.assertEquals((Object)dfs.getTrashRoot(root).toUri().getPath(), (Object)webhdfs.getTrashRoot(root).toUri().getPath());
        Assert.assertEquals((Object)webhdfs.getTrashRoot(root).toUri().getPath(), (Object)webhdfs.getTrashRoot(zone1).toUri().getPath());
        Assert.assertEquals((Object)webhdfs.getTrashRoot(outsideEZ).toUri().getPath(), (Object)webhdfs.getTrashRoot(zone1).toUri().getPath());
    }

    @Test
    public void testStoragePolicy() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        Path path = new Path("/file");
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        Assert.assertTrue((boolean)Arrays.equals(dfs.getAllStoragePolicies().toArray(), webHdfs.getAllStoragePolicies().toArray()));
        DFSTestUtil.createFile((FileSystem)dfs, path, 0L, (short)1, 0L);
        BlockStoragePolicySpi defaultdfsPolicy = dfs.getStoragePolicy(path);
        webHdfs.setStoragePolicy(path, "COLD");
        BlockStoragePolicySpi dfsPolicy = dfs.getStoragePolicy(path);
        BlockStoragePolicy webHdfsPolicy = webHdfs.getStoragePolicy(path);
        Assert.assertEquals((Object)"COLD".toString(), (Object)webHdfsPolicy.getName());
        Assert.assertEquals((Object)webHdfsPolicy, (Object)dfsPolicy);
        webHdfs.unsetStoragePolicy(path);
        Assert.assertEquals((Object)defaultdfsPolicy, (Object)webHdfs.getStoragePolicy(path));
    }

    @Test
    public void testSetStoragePolicyWhenPolicyDisabled() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.storage.policy.enabled", false);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        try {
            cluster.waitActive();
            WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem((Configuration)conf, "webhdfs");
            webHdfs.setStoragePolicy(new Path("/"), "COLD");
            Assert.fail((String)"Should throw exception, when storage policy disabled");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to set storage policy since"));
        }
    }

    private void checkECPolicyState(Collection<ErasureCodingPolicyInfo> policies, String ecpolicy, String state) {
        Iterator<ErasureCodingPolicyInfo> itr = policies.iterator();
        boolean found = false;
        while (policies.iterator().hasNext()) {
            ErasureCodingPolicyInfo policy = itr.next();
            if (!policy.getPolicy().getName().equals(ecpolicy)) continue;
            found = true;
            if (state.equals("disable")) {
                Assert.assertTrue((boolean)policy.isDisabled());
                break;
            }
            if (!state.equals("enable")) break;
            Assert.assertTrue((boolean)policy.isEnabled());
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testECPolicyCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem((Configuration)conf, "webhdfs");
        String policy = "RS-10-4-1024k";
        dfs.disableErasureCodingPolicy(policy);
        this.checkECPolicyState(dfs.getAllErasureCodingPolicies(), policy, "disable");
        webHdfs.enableECPolicy(policy);
        this.checkECPolicyState(dfs.getAllErasureCodingPolicies(), policy, "enable");
        Path dir = new Path("/tmp");
        dfs.mkdirs(dir);
        Assert.assertNull((Object)dfs.getErasureCodingPolicy(dir));
        webHdfs.setErasureCodingPolicy(dir, policy);
        Assert.assertEquals((Object)policy, (Object)dfs.getErasureCodingPolicy(dir).getName());
        Assert.assertEquals((Object)policy, (Object)webHdfs.getErasureCodingPolicy(dir).getName());
        webHdfs.unsetErasureCodingPolicy(dir);
        Assert.assertNull((Object)dfs.getErasureCodingPolicy(dir));
        webHdfs.disableECPolicy(policy);
        this.checkECPolicyState(dfs.getAllErasureCodingPolicies(), policy, "disable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebHdfsSps() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        StoragePolicySatisfier sps = new StoragePolicySatisfier((Configuration)conf);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}}).storagesPerDatanode(2).numDataNodes(1).build();
            cluster.waitActive();
            sps.init((Context)new ExternalSPSContext((SPSService)sps, DFSTestUtil.getNameNodeConnector((Configuration)conf, HdfsServerConstants.MOVER_ID_PATH, 1, false)));
            sps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
            sps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
            DistributedFileSystem dfs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)dfs, new Path("/file"), 1024L, (short)1, 0L);
            DFSTestUtil.waitForReplication(dfs, new Path("/file"), (short)1, 5000);
            dfs.setStoragePolicy(new Path("/file"), "COLD");
            dfs.satisfyStoragePolicy(new Path("/file"));
            DFSTestUtil.waitExpectedStorageType("/file", StorageType.ARCHIVE, 1, 30000, dfs);
        }
        finally {
            sps.stopGracefully();
        }
    }

    @Test
    public void testWebHdfsAppend() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        int dnNumber = 3;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        WebHdfsFileSystem webFS = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        DistributedFileSystem fs = cluster.getFileSystem();
        Path appendFile = new Path("/testAppend.txt");
        String content = "hello world";
        DFSTestUtil.writeFile((FileSystem)fs, appendFile, "hello world");
        for (int index = 0; index < 2; ++index) {
            cluster.shutdownDataNode(index);
        }
        cluster.restartNameNodes();
        cluster.waitActive();
        try {
            DFSTestUtil.appendFile((FileSystem)webFS, appendFile, "hello world");
            Assert.fail((String)"Should fail to append file since datanode number is 1 and replication is 3");
        }
        catch (IOException ignored) {
            String resultContent = DFSTestUtil.readFile((FileSystem)fs, appendFile);
            Assert.assertTrue((boolean)resultContent.equals("hello world"));
        }
    }

    @Test
    public void testFsserverDefaults() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        long blockSize = 0x10000000L;
        int bytesPerChecksum = 256;
        int writePacketSize = 131072;
        int replicationFactor = 0;
        int bufferSize = 1024;
        boolean encryptDataTransfer = true;
        long trashInterval = 1L;
        String checksumType = "CRC32";
        byte policyId = 7;
        conf.setLong("dfs.blocksize", blockSize);
        conf.setInt("dfs.bytes-per-checksum", bytesPerChecksum);
        conf.setInt("dfs.client-write-packet-size", writePacketSize);
        conf.setInt("dfs.replication", replicationFactor);
        conf.setInt("io.file.buffer.size", bufferSize);
        conf.setBoolean("dfs.encrypt.data.transfer", encryptDataTransfer);
        conf.setLong("fs.trash.interval", trashInterval);
        conf.set("dfs.checksum.type", checksumType);
        FsServerDefaults originalServerDefaults = new FsServerDefaults(blockSize, bytesPerChecksum, writePacketSize, (short)replicationFactor, bufferSize, encryptDataTransfer, trashInterval, DataChecksum.Type.valueOf((String)checksumType), "", policyId);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        FsServerDefaults dfsServerDefaults = dfs.getServerDefaults();
        FsServerDefaults webfsServerDefaults = webfs.getServerDefaults();
        this.compareFsServerDefaults(originalServerDefaults, dfsServerDefaults);
        this.compareFsServerDefaults(dfsServerDefaults, webfsServerDefaults);
        webfs.getServerDefaults();
    }

    private void compareFsServerDefaults(FsServerDefaults serverDefaults1, FsServerDefaults serverDefaults2) throws Exception {
        Assert.assertEquals((String)"Block size is different", (long)serverDefaults1.getBlockSize(), (long)serverDefaults2.getBlockSize());
        Assert.assertEquals((String)"Bytes per checksum are different", (long)serverDefaults1.getBytesPerChecksum(), (long)serverDefaults2.getBytesPerChecksum());
        Assert.assertEquals((String)"Write packet size is different", (long)serverDefaults1.getWritePacketSize(), (long)serverDefaults2.getWritePacketSize());
        Assert.assertEquals((String)"Default replication is different", (long)serverDefaults1.getReplication(), (long)serverDefaults2.getReplication());
        Assert.assertEquals((String)"File buffer size are different", (long)serverDefaults1.getFileBufferSize(), (long)serverDefaults2.getFileBufferSize());
        Assert.assertEquals((String)"Encrypt data transfer key is different", (Object)serverDefaults1.getEncryptDataTransfer(), (Object)serverDefaults2.getEncryptDataTransfer());
        Assert.assertEquals((String)"Trash interval is different", (long)serverDefaults1.getTrashInterval(), (long)serverDefaults2.getTrashInterval());
        Assert.assertEquals((String)"Checksum type is different", (Object)serverDefaults1.getChecksumType(), (Object)serverDefaults2.getChecksumType());
        Assert.assertEquals((String)"Key provider uri is different", (Object)serverDefaults1.getKeyProviderUri(), (Object)serverDefaults2.getKeyProviderUri());
        Assert.assertEquals((String)"Default storage policy is different", (long)serverDefaults1.getDefaultStoragePolicyId(), (long)serverDefaults2.getDefaultStoragePolicyId());
    }

    @Test
    public void testFsserverDefaultsBackwardsCompatible() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        FSNamesystem fsnSpy = NameNodeAdapter.spyOnNamesystem(cluster.getNameNode());
        Mockito.when((Object)fsnSpy.getServerDefaults()).thenThrow(new Throwable[]{new UnsupportedOperationException()});
        try {
            webfs.getServerDefaults();
            Assert.fail((String)"should have thrown UnSupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testExceptionPropogationInAbstractRunner() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        Path dir = new Path("/testExceptionPropogationInAbstractRunner");
        conf.setBoolean("dfs.client.retry.policy.enabled", true);
        boolean numDatanodes = true;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        long length = 0x100000L;
        Path file1 = new Path(dir, "testFile");
        DFSTestUtil.createFile((FileSystem)fs, file1, 0x100000L, (short)1, 20120406L);
        FileStatus s1 = fs.getFileStatus(file1);
        Assert.assertEquals((String)("Write failed for file " + file1), (long)0x100000L, (long)s1.getLen());
        FSDataInputStream in = fs.open(file1);
        in.read();
        WebHdfsFileSystem.WebHdfsInputStream webIn = (WebHdfsFileSystem.WebHdfsInputStream)in.getWrappedStream();
        String msg = "Throwing dummy exception";
        IOException ioe = new IOException("Throwing dummy exception", new DummyThrowable());
        WebHdfsFileSystem.ReadRunner readRunner = (WebHdfsFileSystem.ReadRunner)Mockito.spy((Object)webIn.getReadRunner());
        ((WebHdfsFileSystem.ReadRunner)Mockito.doThrow((Throwable[])new Throwable[]{ioe}).when((Object)readRunner)).getResponse((HttpURLConnection)ArgumentMatchers.any(HttpURLConnection.class));
        webIn.setReadRunner(readRunner);
        try {
            webIn.read();
            Assert.fail((String)"Read should have thrown IOException.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Throwing dummy exception"));
            Assert.assertTrue((boolean)(e.getCause() instanceof DummyThrowable));
        }
    }

    @Test(timeout=300000L)
    public void testECPolicyInFileStatus() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        ErasureCodingPolicy ecPolicy = SystemErasureCodingPolicies.getByID((byte)2);
        String ecPolicyName = ecPolicy.getName();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(5).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path ecDir = new Path("/ec");
        Path ecFile = new Path(ecDir, "ec_file.txt");
        Path nonEcFile = new Path(ecDir, "non_ec_file.txt");
        fs.mkdirs(ecDir);
        DFSTestUtil.createFile((FileSystem)fs, nonEcFile, 1024L, (short)1, 0L);
        fs.enableErasureCodingPolicy(ecPolicyName);
        fs.setErasureCodingPolicy(ecDir, ecPolicyName);
        DFSTestUtil.createFile((FileSystem)fs, ecFile, 1024L, (short)1, 0L);
        InetSocketAddress addr = cluster.getNameNode().getHttpAddress();
        URL listStatusUrl = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1" + ecDir.toString() + "?op=LISTSTATUS");
        HttpURLConnection conn = (HttpURLConnection)listStatusUrl.openConnection();
        conn.setRequestMethod("GET");
        conn.setInstanceFollowRedirects(false);
        String listStatusResponse = IOUtils.toString((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Response wasn't 200", (long)200L, (long)conn.getResponseCode());
        String ecpolicyForECfile = this.getECPolicyFromFileStatusJson(this.getFileStatusJson(listStatusResponse, ecFile.getName()));
        Assert.assertEquals((String)"EC policy for ecFile should match the set EC policy", (Object)ecpolicyForECfile, (Object)ecPolicyName);
        String ecPolicyForNonECfile = this.getECPolicyFromFileStatusJson(this.getFileStatusJson(listStatusResponse, nonEcFile.getName()));
        Assert.assertEquals((String)"EC policy for nonEcFile should be null (not set)", (Object)ecPolicyForNonECfile, null);
        URL getFileStatusUrl = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1" + ecFile.toString() + "?op=GETFILESTATUS");
        conn = (HttpURLConnection)getFileStatusUrl.openConnection();
        conn.setRequestMethod("GET");
        conn.setInstanceFollowRedirects(false);
        String getFileStatusResponse = IOUtils.toString((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Response wasn't 200", (long)200L, (long)conn.getResponseCode());
        JSONObject fileStatusObject = new JSONObject(getFileStatusResponse).getJSONObject("FileStatus");
        ecpolicyForECfile = this.getECPolicyFromFileStatusJson(fileStatusObject);
        Assert.assertEquals((String)"EC policy for ecFile should match the set EC policy", (Object)ecpolicyForECfile, (Object)ecPolicyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatistics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        StoragePolicySatisfier sps = new StoragePolicySatisfier((Configuration)conf);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}}).storagesPerDatanode(2).numDataNodes(1).build();
            cluster.waitActive();
            sps.init((Context)new ExternalSPSContext((SPSService)sps, DFSTestUtil.getNameNodeConnector((Configuration)conf, HdfsServerConstants.MOVER_ID_PATH, 1, false)));
            sps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
            sps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
            WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem((Configuration)conf, "webhdfs");
            Path dir = new Path("/test");
            webHdfs.mkdirs(dir);
            int readOps = 0;
            int writeOps = 0;
            FileSystem.clearStatistics();
            long opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_STORAGE_POLICY);
            webHdfs.getStoragePolicy(dir);
            TestDistributedFileSystem.checkStatistics((FileSystem)webHdfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_STORAGE_POLICY, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_STORAGE_POLICIES);
            webHdfs.getAllStoragePolicies();
            TestDistributedFileSystem.checkStatistics((FileSystem)webHdfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_STORAGE_POLICIES, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.SATISFY_STORAGE_POLICY);
            webHdfs.satisfyStoragePolicy(dir);
            TestDistributedFileSystem.checkStatistics((FileSystem)webHdfs, readOps, ++writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.SATISFY_STORAGE_POLICY, opCount + 1L);
            opCount = TestDistributedFileSystem.getOpStatistics(DFSOpsCountStatistics.OpType.GET_SNAPSHOTTABLE_DIRECTORY_LIST);
            webHdfs.getSnapshottableDirectoryList();
            TestDistributedFileSystem.checkStatistics((FileSystem)webHdfs, ++readOps, writeOps, 0);
            TestDistributedFileSystem.checkOpStatistics(DFSOpsCountStatistics.OpType.GET_SNAPSHOTTABLE_DIRECTORY_LIST, opCount + 1L);
        }
        finally {
            cluster.shutdown();
        }
    }

    private JSONObject getFileStatusJson(String response, String fileName) throws JSONException {
        JSONObject listStatusResponseJson = new JSONObject(response);
        JSONArray fileStatusArray = listStatusResponseJson.getJSONObject("FileStatuses").getJSONArray("FileStatus");
        for (int i = 0; i < fileStatusArray.length(); ++i) {
            JSONObject fileStatusJsonObject = fileStatusArray.getJSONObject(i);
            if (!fileName.equals(fileStatusJsonObject.get("pathSuffix"))) continue;
            return fileStatusJsonObject;
        }
        return null;
    }

    private String getECPolicyFromFileStatusJson(JSONObject fileStatusJsonObject) throws JSONException {
        if (fileStatusJsonObject.has("ecPolicy")) {
            return fileStatusJsonObject.getString("ecPolicy");
        }
        return null;
    }

    static final class DummyThrowable
    extends Throwable {
        DummyThrowable() {
        }
    }

    static class Ticker {
        final String name;
        final long startTime;
        private long previousTick;

        Ticker(String name, String format, Object ... args) {
            this.previousTick = this.startTime = System.nanoTime();
            this.name = name;
            LOG.info(String.format("\n\n%s START: %s\n", name, String.format(format, args)));
        }

        void tick(long nBytes, String format, Object ... args) {
            long now = System.nanoTime();
            if (now - this.previousTick > 10000000000L) {
                this.previousTick = now;
                double mintues = (double)(now - systemStartTime) / 6.0E10;
                LOG.info(String.format("\n\n%s %.2f min) %s %s\n", this.name, mintues, String.format(format, args), this.toMpsString(nBytes, now)));
            }
        }

        void end(long nBytes) {
            long now = System.nanoTime();
            double seconds = (double)(now - this.startTime) / 1.0E9;
            LOG.info(String.format("\n\n%s END: duration=%.2fs %s\n", this.name, seconds, this.toMpsString(nBytes, now)));
        }

        String toMpsString(long nBytes, long now) {
            double mb = (double)nBytes / 1048576.0;
            double mps = mb * 1.0E9 / (double)(now - this.startTime);
            return String.format("[nBytes=%.2fMB, speed=%.2fMB/s]", mb, mps);
        }
    }
}

