/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.DecommissionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.RMHAServiceTarget;
import org.apache.hadoop.yarn.client.util.YarnClientUtils;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMAdminCLI
extends HAAdmin {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    static CommonNodeLabelsManager localNodeLabelsManager = null;
    private static final String NO_MAPPING_ERR_MSG = "No node-to-labels mappings are specified";
    private static final String INVALID_TIMEOUT_ERR_MSG = "Invalid timeout specified : ";
    private static final Pattern RESOURCE_TYPES_ARGS_PATTERN = Pattern.compile("^[0-9]*$");
    protected static final Map<String, HAAdmin.UsageInfo> ADMIN_USAGE = ImmutableMap.builder().put((Object)"-refreshQueues", (Object)new HAAdmin.UsageInfo("", "Reload the queues' acls, states and scheduler specific properties. \n\t\tResourceManager will reload the mapred-queues configuration file.")).put((Object)"-refreshNodes", (Object)new HAAdmin.UsageInfo("[-g|graceful [timeout in seconds] -client|server]", "Refresh the hosts information at the ResourceManager. Here [-g|graceful [timeout in seconds] -client|server] is optional, if we specify the timeout then ResourceManager will wait for timeout before marking the NodeManager as decommissioned. The -client|server indicates if the timeout tracking should be handled by the client or the ResourceManager. The client-side tracking is blocking, while the server-side tracking is not. Omitting the timeout, or a timeout of -1, indicates an infinite timeout. Known Issue: the server-side tracking will immediately decommission if an RM HA failover occurs.")).put((Object)"-refreshNodesResources", (Object)new HAAdmin.UsageInfo("", "Refresh resources of NodeManagers at the ResourceManager.")).put((Object)"-refreshSuperUserGroupsConfiguration", (Object)new HAAdmin.UsageInfo("", "Refresh superuser proxy groups mappings")).put((Object)"-refreshUserToGroupsMappings", (Object)new HAAdmin.UsageInfo("", "Refresh user-to-groups mappings")).put((Object)"-refreshAdminAcls", (Object)new HAAdmin.UsageInfo("", "Refresh acls for administration of ResourceManager")).put((Object)"-refreshServiceAcl", (Object)new HAAdmin.UsageInfo("", "Reload the service-level authorization policy file. \n\t\tResourceManager will reload the authorization policy file.")).put((Object)"-getGroups", (Object)new HAAdmin.UsageInfo("[username]", "Get the groups which given user belongs to.")).put((Object)"-addToClusterNodeLabels", (Object)new HAAdmin.UsageInfo("<\"label1(exclusive=true),label2(exclusive=false),label3\">", "add to cluster node labels. Default exclusivity is true")).put((Object)"-removeFromClusterNodeLabels", (Object)new HAAdmin.UsageInfo("<label1,label2,label3> (label splitted by \",\")", "remove from cluster node labels")).put((Object)"-replaceLabelsOnNode", (Object)new HAAdmin.UsageInfo("<\"node1[:port]=label1,label2 node2[:port]=label1,label2\"> [-failOnUnknownNodes] ", "replace labels on nodes (please note that we do not support specifying multiple labels on a single host for now.)\n\t\t[-failOnUnknownNodes] is optional, when we set this option, it will fail if specified nodes are unknown.")).put((Object)"-directlyAccessNodeLabelStore", (Object)new HAAdmin.UsageInfo("", "This is DEPRECATED, will be removed in future releases. Directly access node label store, with this option, all node label related operations will not connect RM. Instead, they will access/modify stored node labels directly. By default, it is false (access via RM). AND PLEASE NOTE: if you configured yarn.node-labels.fs-store.root-dir to a local directory (instead of NFS or HDFS), this option will only work when the command run on the machine where RM is running.")).put((Object)"-refreshClusterMaxPriority", (Object)new HAAdmin.UsageInfo("", "Refresh cluster max priority")).put((Object)"-updateNodeResource", (Object)new HAAdmin.UsageInfo("[NodeID] [MemSize] [vCores] ([OvercommitTimeout]) \n\t\tor\n\t\t[NodeID] [resourcetypes] ([OvercommitTimeout]). ", "Update resource on specific node.")).build();

    public RMAdminCLI() {
    }

    public RMAdminCLI(Configuration conf) {
        super(conf);
    }

    protected void setErrOut(PrintStream errOut) {
        this.errOut = errOut;
    }

    protected void setOut(PrintStream out) {
        this.out = out;
    }

    private static void appendHAUsage(StringBuilder usageBuilder) {
        for (Map.Entry cmdEntry : USAGE.entrySet()) {
            if (((String)cmdEntry.getKey()).equals("-help") || ((String)cmdEntry.getKey()).equals("-failover") || ((String)cmdEntry.getKey()).equals("-transitionToObserver")) continue;
            HAAdmin.UsageInfo usageInfo = (HAAdmin.UsageInfo)cmdEntry.getValue();
            if (usageInfo.args == null) {
                usageBuilder.append(" [" + (String)cmdEntry.getKey() + "]");
                continue;
            }
            usageBuilder.append(" [" + (String)cmdEntry.getKey() + " " + usageInfo.args + "]");
        }
    }

    private static void buildHelpMsg(String cmd, StringBuilder builder) {
        HAAdmin.UsageInfo usageInfo = ADMIN_USAGE.get(cmd);
        if (usageInfo == null && (usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmd)) == null) {
            return;
        }
        if (usageInfo.args == null) {
            builder.append("   " + cmd + ": " + usageInfo.help);
        } else {
            String space = usageInfo.args == "" ? "" : " ";
            builder.append("   " + cmd + space + usageInfo.args + ": " + usageInfo.help);
        }
    }

    private static void buildIndividualUsageMsg(String cmd, StringBuilder builder) {
        boolean isHACommand = false;
        HAAdmin.UsageInfo usageInfo = ADMIN_USAGE.get(cmd);
        if (usageInfo == null) {
            usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmd);
            if (usageInfo == null) {
                return;
            }
            isHACommand = true;
        }
        if (usageInfo.args == null) {
            builder.append("Usage: yarn rmadmin [" + cmd + "]\n");
        } else {
            String space = usageInfo.args == "" ? "" : " ";
            builder.append("Usage: yarn rmadmin [" + cmd + space + usageInfo.args + "]\n");
        }
        if (isHACommand) {
            builder.append(cmd + " can only be used when RM HA is enabled");
        }
    }

    private static void buildUsageMsg(StringBuilder builder, boolean isHAEnabled) {
        builder.append("Usage: yarn rmadmin\n");
        for (Map.Entry<String, HAAdmin.UsageInfo> entry : ADMIN_USAGE.entrySet()) {
            HAAdmin.UsageInfo usageInfo = entry.getValue();
            builder.append("   " + entry.getKey() + " " + usageInfo.args + "\n");
        }
        if (isHAEnabled) {
            for (Map.Entry<String, Object> entry : USAGE.entrySet()) {
                String cmdKey = entry.getKey();
                if (cmdKey.equals("-help")) continue;
                HAAdmin.UsageInfo usageInfo = (HAAdmin.UsageInfo)entry.getValue();
                if (usageInfo.args == null) {
                    builder.append("   " + cmdKey + "\n");
                    continue;
                }
                builder.append("   " + cmdKey + " " + usageInfo.args + "\n");
            }
        }
        builder.append("   -help [cmd]\n");
    }

    private static void printHelp(String cmd, boolean isHAEnabled) {
        StringBuilder summary = new StringBuilder();
        summary.append("rmadmin is the command to execute YARN administrative commands.\n");
        summary.append("The full syntax is: \n\nyarn rmadmin [-refreshQueues] [-refreshNodes [-g|graceful [timeout in seconds] -client|server]] [-refreshNodesResources] [-refreshSuperUserGroupsConfiguration] [-refreshUserToGroupsMappings] [-refreshAdminAcls] [-refreshServiceAcl] [-getGroup [username]] [-addToClusterNodeLabels <\"label1(exclusive=true),label2(exclusive=false),label3\">] [-removeFromClusterNodeLabels <label1,label2,label3>] [-replaceLabelsOnNode <\"node1[:port]=label1,label2 node2[:port]=label1\"> [-failOnUnknownNodes]] [-directlyAccessNodeLabelStore] [-refreshClusterMaxPriority] [-updateNodeResource [NodeID] [MemSize] [vCores] ([OvercommitTimeout]) or -updateNodeResource [NodeID] [ResourceTypes] ([OvercommitTimeout])]");
        if (isHAEnabled) {
            RMAdminCLI.appendHAUsage(summary);
        }
        summary.append(" [-help [cmd]]");
        summary.append("\n");
        StringBuilder helpBuilder = new StringBuilder();
        System.out.println(summary);
        for (String cmdKey : ADMIN_USAGE.keySet()) {
            RMAdminCLI.buildHelpMsg(cmdKey, helpBuilder);
            helpBuilder.append("\n");
        }
        if (isHAEnabled) {
            for (String cmdKey : USAGE.keySet()) {
                if (cmdKey.equals("-help") || cmdKey.equals("-failover") || cmdKey.equals("-transitionToObserver")) continue;
                RMAdminCLI.buildHelpMsg(cmdKey, helpBuilder);
                helpBuilder.append("\n");
            }
        }
        helpBuilder.append("   -help [cmd]: Displays help for the given command or all commands if none is specified.");
        System.out.println(helpBuilder);
        System.out.println();
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    private static void printUsage(String cmd, boolean isHAEnabled) {
        StringBuilder usageBuilder = new StringBuilder();
        if (ADMIN_USAGE.containsKey(cmd) || USAGE.containsKey(cmd)) {
            RMAdminCLI.buildIndividualUsageMsg(cmd, usageBuilder);
        } else {
            RMAdminCLI.buildUsageMsg(usageBuilder, isHAEnabled);
        }
        System.err.println(usageBuilder);
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    protected ResourceManagerAdministrationProtocol createAdminProtocol() throws IOException {
        YarnConfiguration conf = new YarnConfiguration(this.getConf());
        return (ResourceManagerAdministrationProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ResourceManagerAdministrationProtocol.class);
    }

    private int refreshQueues() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshQueuesRequest request = (RefreshQueuesRequest)this.recordFactory.newRecordInstance(RefreshQueuesRequest.class);
        adminProtocol.refreshQueues(request);
        return 0;
    }

    private int refreshNodes(boolean graceful) throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshNodesRequest request = RefreshNodesRequest.newInstance((DecommissionType)(graceful ? DecommissionType.GRACEFUL : DecommissionType.NORMAL));
        adminProtocol.refreshNodes(request);
        return 0;
    }

    private int refreshNodes(int timeout, String trackingMode) throws IOException, YarnException {
        long waitingTime;
        boolean serverTracking = !"client".equals(trackingMode);
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshNodesRequest gracefulRequest = RefreshNodesRequest.newInstance((DecommissionType)DecommissionType.GRACEFUL, (Integer)timeout);
        adminProtocol.refreshNodes(gracefulRequest);
        if (serverTracking) {
            return 0;
        }
        CheckForDecommissioningNodesRequest checkForDecommissioningNodesRequest = (CheckForDecommissioningNodesRequest)this.recordFactory.newRecordInstance(CheckForDecommissioningNodesRequest.class);
        boolean nodesDecommissioning = true;
        int gracePeriod = 5;
        for (waitingTime = 0L; timeout == -1 || timeout >= 0 && waitingTime < (long)(timeout + 5); ++waitingTime) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            CheckForDecommissioningNodesResponse checkForDecommissioningNodes = adminProtocol.checkForDecommissioningNodes(checkForDecommissioningNodesRequest);
            Set decommissioningNodes = checkForDecommissioningNodes.getDecommissioningNodes();
            if (decommissioningNodes.isEmpty()) {
                nodesDecommissioning = false;
                break;
            }
            StringBuilder nodes = new StringBuilder();
            for (NodeId nodeId : decommissioningNodes) {
                nodes.append(nodeId).append(",");
            }
            nodes.deleteCharAt(nodes.length() - 1);
            System.out.println("Nodes '" + nodes + "' are still decommissioning.");
        }
        if (nodesDecommissioning) {
            System.out.println("Graceful decommissioning not completed in " + timeout + " seconds, issuing forceful decommissioning command.");
            RefreshNodesRequest forcefulRequest = RefreshNodesRequest.newInstance((DecommissionType)DecommissionType.FORCEFUL);
            adminProtocol.refreshNodes(forcefulRequest);
        } else {
            System.out.println("Graceful decommissioning completed in " + waitingTime + " seconds.");
        }
        return 0;
    }

    private int refreshNodesResources() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshNodesResourcesRequest request = (RefreshNodesResourcesRequest)this.recordFactory.newRecordInstance(RefreshNodesResourcesRequest.class);
        adminProtocol.refreshNodesResources(request);
        return 0;
    }

    private int refreshNodes() throws IOException, YarnException {
        return this.refreshNodes(false);
    }

    private int refreshUserToGroupsMappings() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshUserToGroupsMappingsRequest request = (RefreshUserToGroupsMappingsRequest)this.recordFactory.newRecordInstance(RefreshUserToGroupsMappingsRequest.class);
        adminProtocol.refreshUserToGroupsMappings(request);
        return 0;
    }

    private int refreshSuperUserGroupsConfiguration() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshSuperUserGroupsConfigurationRequest request = (RefreshSuperUserGroupsConfigurationRequest)this.recordFactory.newRecordInstance(RefreshSuperUserGroupsConfigurationRequest.class);
        adminProtocol.refreshSuperUserGroupsConfiguration(request);
        return 0;
    }

    private int refreshAdminAcls() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshAdminAclsRequest request = (RefreshAdminAclsRequest)this.recordFactory.newRecordInstance(RefreshAdminAclsRequest.class);
        adminProtocol.refreshAdminAcls(request);
        return 0;
    }

    private int refreshServiceAcls() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshServiceAclsRequest request = (RefreshServiceAclsRequest)this.recordFactory.newRecordInstance(RefreshServiceAclsRequest.class);
        adminProtocol.refreshServiceAcls(request);
        return 0;
    }

    private int refreshClusterMaxPriority() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshClusterMaxPriorityRequest request = (RefreshClusterMaxPriorityRequest)this.recordFactory.newRecordInstance(RefreshClusterMaxPriorityRequest.class);
        adminProtocol.refreshClusterMaxPriority(request);
        return 0;
    }

    private int updateNodeResource(String nodeIdStr, Resource resource, int overCommitTimeout) throws YarnException, IOException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        UpdateNodeResourceRequest request = (UpdateNodeResourceRequest)this.recordFactory.newRecordInstance(UpdateNodeResourceRequest.class);
        NodeId nodeId = NodeId.fromString((String)nodeIdStr);
        HashMap<NodeId, ResourceOption> resourceMap = new HashMap<NodeId, ResourceOption>();
        resourceMap.put(nodeId, ResourceOption.newInstance((Resource)resource, (int)overCommitTimeout));
        request.setNodeResourceMap(resourceMap);
        adminProtocol.updateNodeResource(request);
        return 0;
    }

    private boolean invalidResourceValue(int memValue, int coreValue) {
        return memValue < 0 || coreValue < 0;
    }

    private int getGroups(String[] usernames) throws IOException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        if (usernames.length == 0) {
            usernames = new String[]{UserGroupInformation.getCurrentUser().getUserName()};
        }
        for (String username : usernames) {
            StringBuilder sb = new StringBuilder();
            sb.append(username + " :");
            for (String group : adminProtocol.getGroupsForUser(username)) {
                sb.append(" ");
                sb.append(group);
            }
            System.out.println(sb);
        }
        return 0;
    }

    protected static synchronized CommonNodeLabelsManager getNodeLabelManagerInstance(Configuration conf) {
        if (localNodeLabelsManager == null) {
            localNodeLabelsManager = new CommonNodeLabelsManager();
            localNodeLabelsManager.init(conf);
            localNodeLabelsManager.start();
        }
        return localNodeLabelsManager;
    }

    private Set<String> buildNodeLabelNamesFromStr(String args) {
        HashSet<String> labels = new HashSet<String>();
        for (String p : args.split(",")) {
            if (p.trim().isEmpty()) continue;
            labels.add(p.trim());
        }
        if (labels.isEmpty()) {
            throw new IllegalArgumentException("No cluster node-labels are specified");
        }
        return labels;
    }

    private int handleAddToClusterNodeLabels(String[] args, String cmd, boolean isHAEnabled) throws IOException, YarnException, ParseException {
        Options opts = new Options();
        opts.addOption("addToClusterNodeLabels", true, "Add to cluster node labels.");
        opts.addOption("directlyAccessNodeLabelStore", false, "Directly access node label store.");
        int exitCode = -1;
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            System.err.println("No cluster node-labels are specified");
            RMAdminCLI.printUsage(args[0], isHAEnabled);
            return exitCode;
        }
        List<NodeLabel> labels = YarnClientUtils.buildNodeLabelsFromStr(cliParser.getOptionValue("addToClusterNodeLabels"));
        if (cliParser.hasOption("directlyAccessNodeLabelStore")) {
            RMAdminCLI.getNodeLabelManagerInstance(this.getConf()).addToCluserNodeLabels(labels);
        } else {
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            AddToClusterNodeLabelsRequest request = AddToClusterNodeLabelsRequest.newInstance(labels);
            adminProtocol.addToClusterNodeLabels(request);
        }
        return 0;
    }

    private int handleRemoveFromClusterNodeLabels(String[] args, String cmd, boolean isHAEnabled) throws IOException, YarnException, ParseException {
        Options opts = new Options();
        opts.addOption("removeFromClusterNodeLabels", true, "Remove From cluster node labels.");
        opts.addOption("directlyAccessNodeLabelStore", false, "Directly access node label store.");
        int exitCode = -1;
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            System.err.println("No cluster node-labels are specified");
            RMAdminCLI.printUsage(args[0], isHAEnabled);
            return exitCode;
        }
        Set<String> labels = this.buildNodeLabelNamesFromStr(cliParser.getOptionValue("removeFromClusterNodeLabels"));
        if (cliParser.hasOption("directlyAccessNodeLabelStore")) {
            RMAdminCLI.getNodeLabelManagerInstance(this.getConf()).removeFromClusterNodeLabels(labels);
        } else {
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            RemoveFromClusterNodeLabelsRequest request = RemoveFromClusterNodeLabelsRequest.newInstance(labels);
            adminProtocol.removeFromClusterNodeLabels(request);
        }
        return 0;
    }

    private Map<NodeId, Set<String>> buildNodeLabelsMapFromStr(String args) {
        HashMap<NodeId, Set<String>> map = new HashMap<NodeId, Set<String>>();
        for (String nodeToLabels : args.split("[ \n]")) {
            if ((nodeToLabels = nodeToLabels.trim()).isEmpty() || nodeToLabels.startsWith("#")) continue;
            String[] splits = nodeToLabels.split("=");
            int labelsStartIndex = 0;
            String nodeIdStr = splits[0];
            if (splits.length == 2) {
                splits = splits[1].split(",");
            } else if (nodeToLabels.endsWith("=")) {
                splits = new String[]{};
            } else {
                splits = nodeToLabels.split(",");
                nodeIdStr = splits[0];
                labelsStartIndex = 1;
            }
            Preconditions.checkArgument((!nodeIdStr.trim().isEmpty() ? 1 : 0) != 0, (Object)"node name cannot be empty");
            NodeId nodeId = ConverterUtils.toNodeIdWithDefaultPort((String)nodeIdStr);
            map.put(nodeId, new HashSet());
            for (int i = labelsStartIndex; i < splits.length; ++i) {
                if (splits[i].trim().isEmpty()) continue;
                ((Set)map.get(nodeId)).add(splits[i].trim());
            }
            int nLabels = ((Set)map.get(nodeId)).size();
            Preconditions.checkArgument((nLabels <= 1 ? 1 : 0) != 0, (String)"%s labels specified on host=%s, please note that we do not support specifying multiple labels on a single host for now.", (int)nLabels, (Object)nodeIdStr);
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException(NO_MAPPING_ERR_MSG);
        }
        return map;
    }

    private int handleReplaceLabelsOnNodes(String[] args, String cmd, boolean isHAEnabled) throws IOException, YarnException, ParseException {
        Options opts = new Options();
        opts.addOption("replaceLabelsOnNode", true, "Replace label on node.");
        opts.addOption("failOnUnknownNodes", false, "Fail on unknown nodes.");
        opts.addOption("directlyAccessNodeLabelStore", false, "Directly access node label store.");
        int exitCode = -1;
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            System.err.println(NO_MAPPING_ERR_MSG);
            RMAdminCLI.printUsage(args[0], isHAEnabled);
            return exitCode;
        }
        Map<NodeId, Set<String>> map = this.buildNodeLabelsMapFromStr(cliParser.getOptionValue("replaceLabelsOnNode"));
        return this.replaceLabelsOnNodes(map, cliParser.hasOption("failOnUnknownNodes"), cliParser.hasOption("directlyAccessNodeLabelStore"));
    }

    private int replaceLabelsOnNodes(Map<NodeId, Set<String>> map, boolean failOnUnknownNodes, boolean directlyAccessNodeLabelStore) throws IOException, YarnException {
        if (directlyAccessNodeLabelStore) {
            RMAdminCLI.getNodeLabelManagerInstance(this.getConf()).replaceLabelsOnNode(map);
        } else {
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            ReplaceLabelsOnNodeRequest request = ReplaceLabelsOnNodeRequest.newInstance(map);
            request.setFailOnUnknownNodes(failOnUnknownNodes);
            adminProtocol.replaceLabelsOnNode(request);
        }
        return 0;
    }

    public int run(String[] args) throws Exception {
        YarnConfiguration yarnConf = this.getConf() == null ? new YarnConfiguration() : new YarnConfiguration(this.getConf());
        boolean isHAEnabled = yarnConf.getBoolean("yarn.resourcemanager.ha.enabled", false);
        if (args.length < 1) {
            RMAdminCLI.printUsage("", isHAEnabled);
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        String cmd = args[i++];
        exitCode = 0;
        if ("-help".equals(cmd)) {
            if (i < args.length) {
                RMAdminCLI.printUsage(args[i], isHAEnabled);
            } else {
                RMAdminCLI.printHelp("", isHAEnabled);
            }
            return exitCode;
        }
        if (USAGE.containsKey(cmd)) {
            if (isHAEnabled) {
                return super.run(args);
            }
            System.out.println("Cannot run " + cmd + " when ResourceManager HA is not enabled");
            return -1;
        }
        if (("-refreshAdminAcls".equals(cmd) || "-refreshQueues".equals(cmd) || "-refreshNodesResources".equals(cmd) || "-refreshServiceAcl".equals(cmd) || "-refreshUserToGroupsMappings".equals(cmd) || "-refreshSuperUserGroupsConfiguration".equals(cmd)) && args.length != 1) {
            RMAdminCLI.printUsage(cmd, isHAEnabled);
            return exitCode;
        }
        try {
            if ("-refreshQueues".equals(cmd)) {
                exitCode = this.refreshQueues();
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.handleRefreshNodes(args, cmd, isHAEnabled);
            } else if ("-refreshNodesResources".equals(cmd)) {
                exitCode = this.refreshNodesResources();
            } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
                exitCode = this.refreshUserToGroupsMappings();
            } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
                exitCode = this.refreshSuperUserGroupsConfiguration();
            } else if ("-refreshAdminAcls".equals(cmd)) {
                exitCode = this.refreshAdminAcls();
            } else if ("-refreshServiceAcl".equals(cmd)) {
                exitCode = this.refreshServiceAcls();
            } else if ("-refreshClusterMaxPriority".equals(cmd)) {
                exitCode = this.refreshClusterMaxPriority();
            } else if ("-getGroups".equals(cmd)) {
                String[] usernames = Arrays.copyOfRange(args, i, args.length);
                exitCode = this.getGroups(usernames);
            } else if ("-updateNodeResource".equals(cmd)) {
                exitCode = this.handleUpdateNodeResource(args, cmd, isHAEnabled);
            } else if ("-addToClusterNodeLabels".equals(cmd)) {
                exitCode = this.handleAddToClusterNodeLabels(args, cmd, isHAEnabled);
            } else if ("-removeFromClusterNodeLabels".equals(cmd)) {
                exitCode = this.handleRemoveFromClusterNodeLabels(args, cmd, isHAEnabled);
            } else if ("-replaceLabelsOnNode".equals(cmd)) {
                exitCode = this.handleReplaceLabelsOnNodes(args, cmd, isHAEnabled);
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                RMAdminCLI.printUsage("", isHAEnabled);
            }
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            RMAdminCLI.printUsage(cmd, isHAEnabled);
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        if (null != localNodeLabelsManager) {
            localNodeLabelsManager.stop();
        }
        return exitCode;
    }

    private int handleRefreshNodes(String[] args, String cmd, boolean isHAEnabled) throws IOException, YarnException, ParseException {
        Options opts = new Options();
        opts.addOption("refreshNodes", false, "Refresh the hosts information at the ResourceManager.");
        Option gracefulOpt = new Option("g", "graceful", true, "Wait for timeout before marking the NodeManager as decommissioned.");
        gracefulOpt.setOptionalArg(true);
        opts.addOption(gracefulOpt);
        opts.addOption("client", false, "Indicates the timeout tracking should be handled by the client.");
        opts.addOption("server", false, "Indicates the timeout tracking should be handled by the RM.");
        int exitCode = -1;
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            System.out.println("Missing argument for options");
            RMAdminCLI.printUsage(args[0], isHAEnabled);
            return exitCode;
        }
        int timeout = -1;
        if (cliParser.hasOption("g")) {
            String strTimeout = cliParser.getOptionValue("g");
            if (strTimeout != null) {
                timeout = this.validateTimeout(strTimeout);
            }
            String trackingMode = null;
            if (cliParser.hasOption("client")) {
                trackingMode = "client";
            } else if (cliParser.hasOption("server")) {
                trackingMode = "server";
            } else {
                RMAdminCLI.printUsage(cmd, isHAEnabled);
                return -1;
            }
            return this.refreshNodes(timeout, trackingMode);
        }
        return this.refreshNodes();
    }

    private int handleUpdateNodeResource(String[] args, String cmd, boolean isHAEnabled) throws YarnException, IOException {
        int i = 1;
        int overCommitTimeout = -1;
        String nodeID = args[i++];
        Resource resource = Resource.newInstance((int)0, (int)0);
        if (args.length < 3 || args.length > 5) {
            System.err.println("Number of parameters specified for updateNodeResource is wrong.");
            RMAdminCLI.printUsage(cmd, isHAEnabled);
            return -1;
        }
        if ((args.length == 4 || args.length == 5) && RESOURCE_TYPES_ARGS_PATTERN.matcher(args[2]).matches()) {
            int cores;
            int memSize;
            if (this.invalidResourceValue(memSize = Integer.parseInt(args[i++]), cores = Integer.parseInt(args[i++]))) {
                throw new IllegalArgumentException("Invalid resource value: (" + memSize + "," + cores + ") for updateNodeResource.");
            }
            resource = Resources.createResource((int)memSize, (int)cores);
        } else {
            String resourceTypes;
            if (!(resourceTypes = args[i++]).contains("=")) {
                System.err.println("Resource Types parameter specified for updateNodeResource is wrong. It should be comma-delimited key value pairs. For example, memory-mb=1024Mi,vcores=1,resource1=3Gi,resource2=2");
                RMAdminCLI.printUsage(cmd, isHAEnabled);
                return -1;
            }
            resource = this.parseCommandAndCreateResource(resourceTypes);
            ResourceUtils.areMandatoryResourcesAvailable((Resource)resource);
        }
        if (i == args.length - 1) {
            overCommitTimeout = Integer.parseInt(args[i]);
        }
        return this.updateNodeResource(nodeID, resource, overCommitTimeout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Resource parseCommandAndCreateResource(String resourceTypes) {
        Resource resource = Resource.newInstance((int)0, (int)0);
        Map resourceTypesFromRM = ResourceUtils.getResourceTypes();
        String[] resourceTypesArr = resourceTypes.split(",");
        for (int k = 0; k < resourceTypesArr.length; ++k) {
            String resourceType = resourceTypesArr[k];
            String[] resourceTypeArray = resourceType.split("=");
            if (resourceTypeArray.length != 2) throw new IllegalArgumentException("Invalid resource type value: (" + resourceType + ") for updateNodeResource. It should be key value pairs separated using '=' symbol.");
            String resName = StringUtils.trim((String)resourceTypeArray[0]);
            String resValue = StringUtils.trim((String)resourceTypeArray[1]);
            if (!resourceTypesFromRM.containsKey(resName)) throw new IllegalArgumentException("Invalid resource type: " + resName + ". Not allowed.");
            String[] resourceValue = ResourceUtils.parseResourceValue((String)resValue);
            if (resourceValue.length != 2) throw new IllegalArgumentException("Invalid resource value: " + resValue + ". Unable to extract unit and actual value.");
            long value = Long.parseLong(resourceValue[1]);
            if (!((ResourceInformation)resourceTypesFromRM.get(resName)).getUnits().equals(resourceValue[0])) {
                value = UnitsConversionUtil.convert((String)resourceValue[0], (String)((ResourceInformation)resourceTypesFromRM.get(resName)).getUnits(), (long)value);
            }
            ResourceInformation ri = ResourceInformation.newInstance((String)resName, (String)resourceValue[0], (long)value);
            resource.setResourceInformation(resName, ri);
        }
        return resource;
    }

    private int validateTimeout(String strTimeout) {
        int timeout;
        try {
            timeout = Integer.parseInt(strTimeout);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(INVALID_TIMEOUT_ERR_MSG + strTimeout);
        }
        if (timeout < -1) {
            throw new IllegalArgumentException(INVALID_TIMEOUT_ERR_MSG + timeout);
        }
        return timeout;
    }

    private String validateTrackingMode(String mode) {
        if ("-client".equals(mode)) {
            return "client";
        }
        if ("-server".equals(mode)) {
            return "server";
        }
        throw new IllegalArgumentException("Invalid mode specified: " + mode);
    }

    public void setConf(Configuration conf) {
        if (conf != null) {
            conf = RMAdminCLI.addSecurityConfiguration(conf);
        }
        super.setConf(conf);
    }

    private static Configuration addSecurityConfiguration(Configuration conf) {
        conf = new YarnConfiguration(conf);
        conf.set("hadoop.security.service.user.name.key", conf.get("yarn.resourcemanager.principal", ""));
        return conf;
    }

    protected HAServiceTarget resolveTarget(String rmId) {
        Collection rmIds = HAUtil.getRMHAIds((Configuration)this.getConf());
        if (!rmIds.contains(rmId)) {
            StringBuilder msg = new StringBuilder();
            msg.append(rmId + " is not a valid serviceId. It should be one of ");
            for (String id : rmIds) {
                msg.append(id + " ");
            }
            throw new IllegalArgumentException(msg.toString());
        }
        try {
            YarnConfiguration conf = new YarnConfiguration(this.getConf());
            conf.set("yarn.resourcemanager.ha.id", rmId);
            return new RMHAServiceTarget(conf);
        }
        catch (IllegalArgumentException iae) {
            throw new YarnRuntimeException("Could not connect to " + rmId + "; the configuration for it might be missing");
        }
        catch (IOException ioe) {
            throw new YarnRuntimeException("Could not connect to RM HA Admin for node " + rmId);
        }
    }

    protected Collection<String> getTargetIds(String targetNodeToActivate) {
        return HAUtil.getRMHAIds((Configuration)this.getConf());
    }

    protected String getUsageString() {
        return "Usage: rmadmin";
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new RMAdminCLI(), (String[])args);
        System.exit(result);
    }
}

