/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DefaultLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DockerLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegatingLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Log LOG = LogFactory.getLog(DelegatingLinuxContainerRuntime.class);
    private DefaultLinuxContainerRuntime defaultLinuxContainerRuntime;
    private DockerLinuxContainerRuntime dockerLinuxContainerRuntime;
    private EnumSet<LinuxContainerRuntimeConstants.RuntimeType> allowedRuntimes = EnumSet.noneOf(LinuxContainerRuntimeConstants.RuntimeType.class);

    @Override
    public void initialize(Configuration conf) throws ContainerExecutionException {
        String[] configuredRuntimes;
        for (String configuredRuntime : configuredRuntimes = conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.allowed-runtimes", YarnConfiguration.DEFAULT_LINUX_CONTAINER_RUNTIME_ALLOWED_RUNTIMES)) {
            try {
                this.allowedRuntimes.add(LinuxContainerRuntimeConstants.RuntimeType.valueOf(configuredRuntime.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new ContainerExecutionException("Invalid runtime set in yarn.nodemanager.runtime.linux.allowed-runtimes : " + configuredRuntime);
            }
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.DOCKER)) {
            this.dockerLinuxContainerRuntime = new DockerLinuxContainerRuntime(PrivilegedOperationExecutor.getInstance(conf));
            this.dockerLinuxContainerRuntime.initialize(conf);
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.DEFAULT)) {
            this.defaultLinuxContainerRuntime = new DefaultLinuxContainerRuntime(PrivilegedOperationExecutor.getInstance(conf));
            this.defaultLinuxContainerRuntime.initialize(conf);
        }
    }

    @VisibleForTesting
    LinuxContainerRuntime pickContainerRuntime(Map<String, String> environment) throws ContainerExecutionException {
        LinuxContainerRuntime runtime;
        if (this.dockerLinuxContainerRuntime != null && DockerLinuxContainerRuntime.isDockerContainerRequested(environment)) {
            runtime = this.dockerLinuxContainerRuntime;
        } else if (this.defaultLinuxContainerRuntime != null && !DockerLinuxContainerRuntime.isDockerContainerRequested(environment)) {
            runtime = this.defaultLinuxContainerRuntime;
        } else {
            throw new ContainerExecutionException("Requested runtime not allowed.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using container runtime: " + runtime.getClass().getSimpleName()));
        }
        return runtime;
    }

    private LinuxContainerRuntime pickContainerRuntime(Container container) throws ContainerExecutionException {
        return this.pickContainerRuntime(container.getLaunchContext().getEnvironment());
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.prepareContainer(ctx);
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.launchContainer(ctx);
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.signalContainer(ctx);
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.reapContainer(ctx);
    }

    @VisibleForTesting
    boolean isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType runtimeType) {
        return this.allowedRuntimes.contains((Object)runtimeType);
    }
}

