/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Planner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryPlan
implements Plan {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryPlan.class);
    private static final Resource ZERO_RESOURCE = Resource.newInstance((int)0, (int)0);
    private TreeMap<ReservationInterval, Set<InMemoryReservationAllocation>> currentReservations = new TreeMap();
    private RLESparseResourceAllocation rleSparseVector;
    private Map<String, RLESparseResourceAllocation> userResourceAlloc = new HashMap<String, RLESparseResourceAllocation>();
    private Map<ReservationId, InMemoryReservationAllocation> reservationTable = new HashMap<ReservationId, InMemoryReservationAllocation>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final SharingPolicy policy;
    private final ReservationAgent agent;
    private final long step;
    private final ResourceCalculator resCalc;
    private final Resource minAlloc;
    private final Resource maxAlloc;
    private final String queueName;
    private final QueueMetrics queueMetrics;
    private final Planner replanner;
    private final boolean getMoveOnExpiry;
    private final Clock clock;
    private Resource totalCapacity;

    InMemoryPlan(QueueMetrics queueMetrics, SharingPolicy policy, ReservationAgent agent, Resource totalCapacity, long step, ResourceCalculator resCalc, Resource minAlloc, Resource maxAlloc, String queueName, Planner replanner, boolean getMoveOnExpiry) {
        this(queueMetrics, policy, agent, totalCapacity, step, resCalc, minAlloc, maxAlloc, queueName, replanner, getMoveOnExpiry, (Clock)new UTCClock());
    }

    InMemoryPlan(QueueMetrics queueMetrics, SharingPolicy policy, ReservationAgent agent, Resource totalCapacity, long step, ResourceCalculator resCalc, Resource minAlloc, Resource maxAlloc, String queueName, Planner replanner, boolean getMoveOnExpiry, Clock clock) {
        this.queueMetrics = queueMetrics;
        this.policy = policy;
        this.agent = agent;
        this.step = step;
        this.totalCapacity = totalCapacity;
        this.resCalc = resCalc;
        this.minAlloc = minAlloc;
        this.maxAlloc = maxAlloc;
        this.rleSparseVector = new RLESparseResourceAllocation(resCalc, minAlloc);
        this.queueName = queueName;
        this.replanner = replanner;
        this.getMoveOnExpiry = getMoveOnExpiry;
        this.clock = clock;
    }

    @Override
    public QueueMetrics getQueueMetrics() {
        return this.queueMetrics;
    }

    private void incrementAllocation(ReservationAllocation reservation) {
        assert (this.readWriteLock.isWriteLockedByCurrentThread());
        Map<ReservationInterval, ReservationRequest> allocationRequests = reservation.getAllocationRequests();
        String user = reservation.getUser();
        RLESparseResourceAllocation resAlloc = this.userResourceAlloc.get(user);
        if (resAlloc == null) {
            resAlloc = new RLESparseResourceAllocation(this.resCalc, this.minAlloc);
            this.userResourceAlloc.put(user, resAlloc);
        }
        for (Map.Entry<ReservationInterval, ReservationRequest> r : allocationRequests.entrySet()) {
            resAlloc.addInterval(r.getKey(), r.getValue());
            this.rleSparseVector.addInterval(r.getKey(), r.getValue());
        }
    }

    private void decrementAllocation(ReservationAllocation reservation) {
        assert (this.readWriteLock.isWriteLockedByCurrentThread());
        Map<ReservationInterval, ReservationRequest> allocationRequests = reservation.getAllocationRequests();
        String user = reservation.getUser();
        RLESparseResourceAllocation resAlloc = this.userResourceAlloc.get(user);
        for (Map.Entry<ReservationInterval, ReservationRequest> r : allocationRequests.entrySet()) {
            resAlloc.removeInterval(r.getKey(), r.getValue());
            this.rleSparseVector.removeInterval(r.getKey(), r.getValue());
        }
        if (resAlloc.isEmpty()) {
            this.userResourceAlloc.remove(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ReservationAllocation> getAllReservations() {
        this.readLock.lock();
        try {
            if (this.currentReservations != null) {
                HashSet<ReservationAllocation> flattenedReservations = new HashSet<ReservationAllocation>();
                for (Set<InMemoryReservationAllocation> reservationEntries : this.currentReservations.values()) {
                    flattenedReservations.addAll(reservationEntries);
                }
                HashSet<ReservationAllocation> hashSet = flattenedReservations;
                return hashSet;
            }
            Set<ReservationAllocation> set = null;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addReservation(ReservationAllocation reservation) throws PlanningException {
        InMemoryReservationAllocation inMemReservation = (InMemoryReservationAllocation)reservation;
        if (inMemReservation.getUser() == null) {
            String errMsg = "The specified Reservation with ID " + inMemReservation.getReservationId() + " is not mapped to any user";
            LOG.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        this.writeLock.lock();
        try {
            if (this.reservationTable.containsKey(inMemReservation.getReservationId())) {
                String errMsg = "The specified Reservation with ID " + inMemReservation.getReservationId() + " already exists";
                LOG.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            this.policy.validate(this, inMemReservation);
            reservation.setAcceptanceTimestamp(this.clock.getTime());
            ReservationInterval searchInterval = new ReservationInterval(inMemReservation.getStartTime(), inMemReservation.getEndTime());
            Set<InMemoryReservationAllocation> reservations = this.currentReservations.get(searchInterval);
            if (reservations == null) {
                reservations = new HashSet<InMemoryReservationAllocation>();
            }
            if (!reservations.add(inMemReservation)) {
                LOG.error("Unable to add reservation: {} to plan.", (Object)inMemReservation.getReservationId());
                boolean bl = false;
                return bl;
            }
            this.currentReservations.put(searchInterval, reservations);
            this.reservationTable.put(inMemReservation.getReservationId(), inMemReservation);
            this.incrementAllocation(inMemReservation);
            LOG.info("Sucessfully added reservation: {} to plan.", (Object)inMemReservation.getReservationId());
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateReservation(ReservationAllocation reservation) throws PlanningException {
        this.writeLock.lock();
        boolean result = false;
        try {
            ReservationId resId = reservation.getReservationId();
            ReservationAllocation currReservation = this.getReservationById(resId);
            if (currReservation == null) {
                String errMsg = "The specified Reservation with ID " + resId + " does not exist in the plan";
                LOG.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            this.policy.validate(this, reservation);
            if (!this.removeReservation(currReservation)) {
                LOG.error("Unable to replace reservation: {} from plan.", (Object)reservation.getReservationId());
                boolean errMsg = result;
                return errMsg;
            }
            try {
                result = this.addReservation(reservation);
            }
            catch (PlanningException e) {
                LOG.error("Unable to update reservation: {} from plan due to {}.", (Object)reservation.getReservationId(), (Object)e.getMessage());
            }
            if (result) {
                LOG.info("Sucessfully updated reservation: {} in plan.", (Object)reservation.getReservationId());
                boolean bl = result;
                return bl;
            }
            this.addReservation(currReservation);
            LOG.info("Rollbacked update reservation: {} from plan.", (Object)reservation.getReservationId());
            boolean bl = result;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean removeReservation(ReservationAllocation reservation) {
        assert (this.readWriteLock.isWriteLockedByCurrentThread());
        ReservationInterval searchInterval = new ReservationInterval(reservation.getStartTime(), reservation.getEndTime());
        Set<InMemoryReservationAllocation> reservations = this.currentReservations.get(searchInterval);
        if (reservations != null) {
            if (!reservations.remove(reservation)) {
                LOG.error("Unable to remove reservation: {} from plan.", (Object)reservation.getReservationId());
                return false;
            }
            if (reservations.isEmpty()) {
                this.currentReservations.remove(searchInterval);
            }
        } else {
            String errMsg = "The specified Reservation with ID " + reservation.getReservationId() + " does not exist in the plan";
            LOG.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        this.reservationTable.remove(reservation.getReservationId());
        this.decrementAllocation(reservation);
        LOG.info("Sucessfully deleted reservation: {} in plan.", (Object)reservation.getReservationId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteReservation(ReservationId reservationID) {
        this.writeLock.lock();
        try {
            ReservationAllocation reservation = this.getReservationById(reservationID);
            if (reservation == null) {
                String errMsg = "The specified Reservation with ID " + reservationID + " does not exist in the plan";
                LOG.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            boolean bl = this.removeReservation(reservation);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveCompletedReservations(long tick) {
        LOG.debug("Running archival at time: {}", (Object)tick);
        ArrayList<InMemoryReservationAllocation> expiredReservations = new ArrayList<InMemoryReservationAllocation>();
        this.readLock.lock();
        try {
            long archivalTime = tick - this.policy.getValidWindow();
            ReservationInterval searchInterval = new ReservationInterval(archivalTime, archivalTime);
            NavigableMap<ReservationInterval, Set<InMemoryReservationAllocation>> reservations = this.currentReservations.headMap(searchInterval, true);
            if (!reservations.isEmpty()) {
                for (Set reservationEntries : reservations.values()) {
                    for (InMemoryReservationAllocation reservation : reservationEntries) {
                        if (reservation.getEndTime() > archivalTime) continue;
                        expiredReservations.add(reservation);
                    }
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (expiredReservations.isEmpty()) {
            return;
        }
        this.writeLock.lock();
        try {
            for (InMemoryReservationAllocation expiredReservation : expiredReservations) {
                this.removeReservation(expiredReservation);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ReservationAllocation> getReservationsAtTime(long tick) {
        ReservationInterval searchInterval = new ReservationInterval(tick, Long.MAX_VALUE);
        this.readLock.lock();
        try {
            NavigableMap<ReservationInterval, Set<InMemoryReservationAllocation>> reservations = this.currentReservations.headMap(searchInterval, true);
            if (!reservations.isEmpty()) {
                HashSet<InMemoryReservationAllocation> flattenedReservations = new HashSet<InMemoryReservationAllocation>();
                for (Set reservationEntries : reservations.values()) {
                    for (InMemoryReservationAllocation reservation : reservationEntries) {
                        if (reservation.getEndTime() <= tick) continue;
                        flattenedReservations.add(reservation);
                    }
                }
                Set<ReservationAllocation> set = Collections.unmodifiableSet(flattenedReservations);
                return set;
            }
            Set<ReservationAllocation> set = Collections.emptySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getStep() {
        return this.step;
    }

    @Override
    public SharingPolicy getSharingPolicy() {
        return this.policy;
    }

    @Override
    public ReservationAgent getReservationAgent() {
        return this.agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getConsumptionForUser(String user, long t) {
        this.readLock.lock();
        try {
            RLESparseResourceAllocation userResAlloc = this.userResourceAlloc.get(user);
            if (userResAlloc != null) {
                Resource resource = userResAlloc.getCapacityAtTime(t);
                return resource;
            }
            Resource resource = Resources.clone((Resource)ZERO_RESOURCE);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getTotalCommittedResources(long t) {
        this.readLock.lock();
        try {
            Resource resource = this.rleSparseVector.getCapacityAtTime(t);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReservationAllocation getReservationById(ReservationId reservationID) {
        if (reservationID == null) {
            return null;
        }
        this.readLock.lock();
        try {
            ReservationAllocation reservationAllocation = this.reservationTable.get(reservationID);
            return reservationAllocation;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getTotalCapacity() {
        this.readLock.lock();
        try {
            Resource resource = Resources.clone((Resource)this.totalCapacity);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Resource getMinimumAllocation() {
        return Resources.clone((Resource)this.minAlloc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTotalCapacity(Resource cap) {
        this.writeLock.lock();
        try {
            this.totalCapacity = Resources.clone((Resource)cap);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEarliestStartTime() {
        this.readLock.lock();
        try {
            long l = this.rleSparseVector.getEarliestStartTime();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastEndTime() {
        this.readLock.lock();
        try {
            long l = this.rleSparseVector.getLatestEndTime();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return this.resCalc;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public Resource getMaximumAllocation() {
        return Resources.clone((Resource)this.maxAlloc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toCumulativeString() {
        this.readLock.lock();
        try {
            String string = this.rleSparseVector.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Planner getReplanner() {
        return this.replanner;
    }

    @Override
    public boolean getMoveOnExpiry() {
        return this.getMoveOnExpiry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock.lock();
        try {
            StringBuffer planStr = new StringBuffer("In-memory Plan: ");
            planStr.append("Parent Queue: ").append(this.queueName).append("Total Capacity: ").append(this.totalCapacity).append("Step: ").append(this.step);
            for (ReservationAllocation reservation : this.getAllReservations()) {
                planStr.append(reservation);
            }
            String string = planStr.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

