/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.PreemptableResourceCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.PreemptionCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class FifoCandidatesSelector
extends PreemptionCandidatesSelector {
    private static final Log LOG = LogFactory.getLog(FifoCandidatesSelector.class);
    private PreemptableResourceCalculator preemptableAmountCalculator;

    FifoCandidatesSelector(CapacitySchedulerPreemptionContext preemptionContext, boolean includeReservedResource) {
        super(preemptionContext);
        this.preemptableAmountCalculator = new PreemptableResourceCalculator(preemptionContext, includeReservedResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ApplicationAttemptId, Set<RMContainer>> selectCandidates(Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource clusterResource, Resource totalPreemptionAllowed) {
        this.preemptableAmountCalculator.computeIdealAllocation(clusterResource, totalPreemptionAllowed);
        CapacitySchedulerPreemptionUtils.deductPreemptableResourcesBasedSelectedCandidates(this.preemptionContext, selectedCandidates);
        ArrayList<RMContainer> skippedAMContainerlist = new ArrayList<RMContainer>();
        for (String queueName : this.preemptionContext.getLeafQueueNames()) {
            if (this.preemptionContext.getQueueByPartition((String)queueName, (String)"").preemptionDisabled) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("skipping from queue=" + queueName + " because it's a non-preemptable queue"));
                continue;
            }
            LeafQueue leafQueue = this.preemptionContext.getQueueByPartition((String)queueName, (String)"").leafQueue;
            Map<String, Resource> resToObtainByPartition = CapacitySchedulerPreemptionUtils.getResToObtainByPartitionForLeafQueue(this.preemptionContext, queueName, clusterResource);
            LeafQueue leafQueue2 = leafQueue;
            synchronized (leafQueue2) {
                Map<String, TreeSet<RMContainer>> ignorePartitionExclusivityContainers = leafQueue.getIgnoreExclusivityRMContainers();
                for (String partition : resToObtainByPartition.keySet()) {
                    if (!ignorePartitionExclusivityContainers.containsKey(partition)) continue;
                    TreeSet<RMContainer> rmContainers = ignorePartitionExclusivityContainers.get(partition);
                    for (RMContainer c : rmContainers.descendingSet()) {
                        boolean preempted;
                        if (!CapacitySchedulerPreemptionUtils.isContainerAlreadySelected(c, selectedCandidates) && (preempted = CapacitySchedulerPreemptionUtils.tryPreemptContainerAndDeductResToObtain(this.rc, this.preemptionContext, resToObtainByPartition, c, clusterResource, selectedCandidates, totalPreemptionAllowed))) continue;
                    }
                }
                Resource skippedAMSize = Resource.newInstance((int)0, (int)0);
                Iterator<FiCaSchedulerApp> desc = leafQueue.getOrderingPolicy().getPreemptionIterator();
                while (desc.hasNext()) {
                    FiCaSchedulerApp fc = desc.next();
                    if (resToObtainByPartition.isEmpty()) break;
                    this.preemptFrom(fc, clusterResource, resToObtainByPartition, skippedAMContainerlist, skippedAMSize, selectedCandidates, totalPreemptionAllowed);
                }
                Resource maxAMCapacityForThisQueue = Resources.multiply((Resource)Resources.multiply((Resource)clusterResource, (double)leafQueue.getAbsoluteCapacity()), (double)leafQueue.getMaxAMResourcePerQueuePercent());
                this.preemptAMContainers(clusterResource, selectedCandidates, skippedAMContainerlist, resToObtainByPartition, skippedAMSize, maxAMCapacityForThisQueue, totalPreemptionAllowed);
            }
        }
        return selectedCandidates;
    }

    private void preemptAMContainers(Resource clusterResource, Map<ApplicationAttemptId, Set<RMContainer>> preemptMap, List<RMContainer> skippedAMContainerlist, Map<String, Resource> resToObtainByPartition, Resource skippedAMSize, Resource maxAMCapacityForThisQueue, Resource totalPreemptionAllowed) {
        for (RMContainer c : skippedAMContainerlist) {
            if (resToObtainByPartition.isEmpty() || Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)skippedAMSize, (Resource)maxAMCapacityForThisQueue)) break;
            boolean preempted = CapacitySchedulerPreemptionUtils.tryPreemptContainerAndDeductResToObtain(this.rc, this.preemptionContext, resToObtainByPartition, c, clusterResource, preemptMap, totalPreemptionAllowed);
            if (!preempted) continue;
            Resources.subtractFrom((Resource)skippedAMSize, (Resource)c.getAllocatedResource());
        }
        skippedAMContainerlist.clear();
    }

    private void preemptFrom(FiCaSchedulerApp app, Resource clusterResource, Map<String, Resource> resToObtainByPartition, List<RMContainer> skippedAMContainerlist, Resource skippedAMSize, Map<ApplicationAttemptId, Set<RMContainer>> selectedContainers, Resource totalPreemptionAllowed) {
        ApplicationAttemptId appId = app.getApplicationAttemptId();
        ArrayList<RMContainer> reservedContainers = new ArrayList<RMContainer>(app.getReservedContainers());
        for (RMContainer c : reservedContainers) {
            if (CapacitySchedulerPreemptionUtils.isContainerAlreadySelected(c, selectedContainers)) continue;
            if (resToObtainByPartition.isEmpty()) {
                return;
            }
            CapacitySchedulerPreemptionUtils.tryPreemptContainerAndDeductResToObtain(this.rc, this.preemptionContext, resToObtainByPartition, c, clusterResource, selectedContainers, totalPreemptionAllowed);
            if (this.preemptionContext.isObserveOnly()) continue;
            this.preemptionContext.getRMContext().getDispatcher().getEventHandler().handle((Event)new ContainerPreemptEvent(appId, c, SchedulerEventType.KILL_RESERVED_CONTAINER));
        }
        ArrayList<RMContainer> liveContainers = new ArrayList<RMContainer>(app.getLiveContainers());
        FifoCandidatesSelector.sortContainers(liveContainers);
        for (RMContainer c : liveContainers) {
            if (resToObtainByPartition.isEmpty()) {
                return;
            }
            if (CapacitySchedulerPreemptionUtils.isContainerAlreadySelected(c, selectedContainers) || null != this.preemptionContext.getKillableContainers() && this.preemptionContext.getKillableContainers().contains(c.getContainerId())) continue;
            if (c.isAMContainer()) {
                skippedAMContainerlist.add(c);
                Resources.addTo((Resource)skippedAMSize, (Resource)c.getAllocatedResource());
                continue;
            }
            CapacitySchedulerPreemptionUtils.tryPreemptContainerAndDeductResToObtain(this.rc, this.preemptionContext, resToObtainByPartition, c, clusterResource, selectedContainers, totalPreemptionAllowed);
        }
    }
}

