/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureQueue;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterProcedureEnv {
    private static final Log LOG = LogFactory.getLog(MasterProcedureEnv.class);
    private final MasterProcedureQueue procQueue;
    private final MasterServices master;

    public MasterProcedureEnv(MasterServices master) {
        this.master = master;
        this.procQueue = new MasterProcedureQueue(master.getConfiguration(), master.getTableLockManager());
    }

    public User getRequestUser() throws IOException {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            user = UserProvider.instantiate((Configuration)this.getMasterConfiguration()).getCurrent();
        }
        return user;
    }

    public MasterServices getMasterServices() {
        return this.master;
    }

    public Configuration getMasterConfiguration() {
        return this.master.getConfiguration();
    }

    public MasterCoprocessorHost getMasterCoprocessorHost() {
        return this.master.getMasterCoprocessorHost();
    }

    public MasterProcedureQueue getProcedureQueue() {
        return this.procQueue;
    }

    public boolean isRunning() {
        return this.master.getMasterProcedureExecutor().isRunning();
    }

    public boolean isInitialized() {
        return this.master.isInitialized();
    }

    @InterfaceAudience.Private
    public static class MasterProcedureStoreListener
    implements ProcedureStore.ProcedureStoreListener {
        private final HMaster master;

        public MasterProcedureStoreListener(HMaster master) {
            this.master = master;
        }

        public void postSync() {
        }

        public void abortProcess() {
            this.master.abort("The Procedure Store lost the lease");
        }
    }

    @InterfaceAudience.Private
    public static class WALStoreLeaseRecovery
    implements WALProcedureStore.LeaseRecovery {
        private final HMaster master;

        public WALStoreLeaseRecovery(HMaster master) {
            this.master = master;
        }

        public void recoverFileLease(FileSystem fs, final Path path) throws IOException {
            Configuration conf = this.master.getConfiguration();
            FSUtils fsUtils = FSUtils.getInstance(fs, conf);
            fsUtils.recoverFileLease(fs, path, conf, new CancelableProgressable(){

                @Override
                public boolean progress() {
                    LOG.debug((Object)("Recover Procedure Store log lease: " + path));
                    return WALStoreLeaseRecovery.this.master.isActiveMaster();
                }
            });
        }
    }
}

