/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHDFSBlocksDistribution {
    @Test
    public void testAddHostsAndBlockWeight() throws Exception {
        HDFSBlocksDistribution distribution = new HDFSBlocksDistribution();
        distribution.addHostsAndBlockWeight(null, 100L);
        Assert.assertEquals((String)"Expecting no hosts weights", (int)0, (int)distribution.getHostAndWeights().size());
        distribution.addHostsAndBlockWeight(new String[0], 100L);
        Assert.assertEquals((String)"Expecting no hosts weights", (int)0, (int)distribution.getHostAndWeights().size());
        distribution.addHostsAndBlockWeight(new String[]{"test"}, 101L);
        Assert.assertEquals((String)"Should be one host", (int)1, (int)distribution.getHostAndWeights().size());
        distribution.addHostsAndBlockWeight(new String[]{"test"}, 202L);
        Assert.assertEquals((String)"Should be one host", (int)1, (int)distribution.getHostAndWeights().size());
        Assert.assertEquals((String)"test host should have weight 303", (long)303L, (long)((HDFSBlocksDistribution.HostAndWeight)distribution.getHostAndWeights().get("test")).getWeight());
        distribution.addHostsAndBlockWeight(new String[]{"testTwo"}, 222L);
        Assert.assertEquals((String)"Should be two hosts", (int)2, (int)distribution.getHostAndWeights().size());
        Assert.assertEquals((String)"Total weight should be 525", (long)525L, (long)distribution.getUniqueBlocksTotalWeight());
    }

    @Test
    public void testAdd() throws Exception {
        HDFSBlocksDistribution distribution = new HDFSBlocksDistribution();
        distribution.add((HDFSBlocksDistribution)new MockHDFSBlocksDistribution());
        Assert.assertEquals((String)"Expecting no hosts weights", (int)0, (int)distribution.getHostAndWeights().size());
        distribution.addHostsAndBlockWeight(new String[]{"test"}, 10L);
        Assert.assertEquals((String)"Should be one host", (int)1, (int)distribution.getHostAndWeights().size());
        distribution.add((HDFSBlocksDistribution)new MockHDFSBlocksDistribution());
        Assert.assertEquals((String)"Should be one host", (int)1, (int)distribution.getHostAndWeights().size());
        Assert.assertEquals((String)"Total weight should be 10", (long)10L, (long)distribution.getUniqueBlocksTotalWeight());
    }

    public class MockHDFSBlocksDistribution
    extends HDFSBlocksDistribution {
        public Map<String, HDFSBlocksDistribution.HostAndWeight> getHostAndWeights() {
            HashMap<String, HDFSBlocksDistribution.HostAndWeight> map = new HashMap<String, HDFSBlocksDistribution.HostAndWeight>();
            map.put("test", new HDFSBlocksDistribution.HostAndWeight(null, 100L));
            return map;
        }
    }
}

