/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.PerformanceEvaluation;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPerformanceEvaluation {
    @Test
    public void testSerialization() throws JsonGenerationException, JsonMappingException, IOException {
        PerformanceEvaluation.TestOptions options = new PerformanceEvaluation.TestOptions();
        Assert.assertTrue((!options.isAutoFlush() ? 1 : 0) != 0);
        options.setAutoFlush(true);
        ObjectMapper mapper = new ObjectMapper();
        String optionsString = mapper.writeValueAsString((Object)options);
        PerformanceEvaluation.TestOptions optionsDeserialized = (PerformanceEvaluation.TestOptions)mapper.readValue(optionsString, PerformanceEvaluation.TestOptions.class);
        Assert.assertTrue((boolean)optionsDeserialized.isAutoFlush());
    }

    @Test
    public void testParseOptsWithThreads() {
        LinkedList<String> opts = new LinkedList<String>();
        String cmdName = "sequentialWrite";
        int threads = 1;
        opts.offer(cmdName);
        opts.offer(String.valueOf(threads));
        PerformanceEvaluation.TestOptions options = PerformanceEvaluation.parseOpts(opts);
        Assert.assertNotNull((Object)options);
        Assert.assertNotNull((Object)options.getCmdName());
        Assert.assertEquals((Object)cmdName, (Object)options.getCmdName());
        Assert.assertEquals((long)threads, (long)options.getNumClientThreads());
    }

    @Test
    public void testParseOptsWrongThreads() {
        LinkedList<String> opts = new LinkedList<String>();
        String cmdName = "sequentialWrite";
        opts.offer(cmdName);
        opts.offer("qq");
        try {
            PerformanceEvaluation.parseOpts(opts);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            Assert.assertEquals((Object)("Command " + cmdName + " does not have threads number"), (Object)e.getMessage());
            Assert.assertTrue((boolean)(e.getCause() instanceof NumberFormatException));
        }
    }

    @Test
    public void testParseOptsNoThreads() {
        LinkedList<String> opts = new LinkedList<String>();
        String cmdName = "sequentialWrite";
        try {
            PerformanceEvaluation.parseOpts(opts);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            Assert.assertEquals((Object)("Command " + cmdName + " does not have threads number"), (Object)e.getMessage());
            Assert.assertTrue((boolean)(e.getCause() instanceof NoSuchElementException));
        }
    }

    @Test
    public void testSetBufferSizeOption() {
        PerformanceEvaluation.TestOptions opts = new PerformanceEvaluation.TestOptions();
        long bufferSize = opts.getBufferSize();
        Assert.assertEquals((long)bufferSize, (long)0x200000L);
        opts.setBufferSize(65536L);
        bufferSize = opts.getBufferSize();
        Assert.assertEquals((long)bufferSize, (long)65536L);
    }
}

