/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableMultiplexer;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class, ClientTests.class})
public class TestHTableMultiplexerFlushCache {
    private static final Log LOG = LogFactory.getLog(TestHTableMultiplexerFlushCache.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER1 = Bytes.toBytes((String)"testQualifier_1");
    private static byte[] QUALIFIER2 = Bytes.toBytes((String)"testQualifier_2");
    private static byte[] VALUE1 = Bytes.toBytes((String)"testValue1");
    private static byte[] VALUE2 = Bytes.toBytes((String)"testValue2");
    private static int SLAVES = 3;
    private static int PER_REGIONSERVER_QUEUE_SIZE = 100000;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void checkExistence(HTable htable, byte[] row, byte[] family, byte[] quality, byte[] value) throws Exception {
        Result r;
        Get get = new Get(row);
        get.addColumn(family, quality);
        int nbTry = 0;
        do {
            Assert.assertTrue((String)("Fail to get from " + htable.getName() + " after " + nbTry + " tries"), (nbTry < 50 ? 1 : 0) != 0);
            ++nbTry;
            Thread.sleep(100L);
        } while ((r = htable.get(get)) == null || r.getValue(family, quality) == null);
        Assert.assertEquals((String)"value", (Object)Bytes.toStringBinary((byte[])value), (Object)Bytes.toStringBinary((byte[])r.getValue(family, quality)));
    }

    @Test
    public void testOnRegionChange() throws Exception {
        TableName TABLE = TableName.valueOf((String)"testOnRegionChange");
        int NUM_REGIONS = 10;
        HTable htable = TEST_UTIL.createTable(TABLE, (byte[][])new byte[][]{FAMILY}, 3, Bytes.toBytes((String)"aaaaa"), Bytes.toBytes((String)"zzzzz"), 10);
        HTableMultiplexer multiplexer = new HTableMultiplexer(TEST_UTIL.getConfiguration(), PER_REGIONSERVER_QUEUE_SIZE);
        byte[][] startRows = htable.getStartKeys();
        byte[] row = startRows[1];
        Assert.assertTrue((String)"2nd region should not start with empty row", (row != null && row.length > 0 ? 1 : 0) != 0);
        Put put = new Put(row).add(FAMILY, QUALIFIER1, VALUE1);
        Assert.assertTrue((String)"multiplexer.put returns", (boolean)multiplexer.put(TABLE, put));
        TestHTableMultiplexerFlushCache.checkExistence(htable, row, FAMILY, QUALIFIER1, VALUE1);
        HRegionLocation loc = htable.getRegionLocation(row);
        MiniHBaseCluster hbaseCluster = TEST_UTIL.getHBaseCluster();
        hbaseCluster.stopRegionServer(loc.getServerName());
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLE);
        put = new Put(row).add(FAMILY, QUALIFIER2, VALUE2);
        Assert.assertTrue((String)"multiplexer.put returns", (boolean)multiplexer.put(TABLE, put));
        TestHTableMultiplexerFlushCache.checkExistence(htable, row, FAMILY, QUALIFIER2, VALUE2);
    }

    @Test
    public void testOnRegionMove() throws Exception {
        TableName TABLE = TableName.valueOf((String)"testOnRegionMove");
        int NUM_REGIONS = 10;
        HTable htable = TEST_UTIL.createTable(TABLE, (byte[][])new byte[][]{FAMILY}, 3, Bytes.toBytes((String)"aaaaa"), Bytes.toBytes((String)"zzzzz"), 10);
        HTableMultiplexer multiplexer = new HTableMultiplexer(TEST_UTIL.getConfiguration(), PER_REGIONSERVER_QUEUE_SIZE);
        RegionLocator regionLocator = TEST_UTIL.getConnection().getRegionLocator(TABLE);
        Pair startEndRows = regionLocator.getStartEndKeys();
        byte[] row = ((byte[][])startEndRows.getFirst())[1];
        Assert.assertTrue((String)"2nd region should not start with empty row", (row != null && row.length > 0 ? 1 : 0) != 0);
        Put put = new Put(row).addColumn(FAMILY, QUALIFIER1, VALUE1);
        Assert.assertTrue((String)"multiplexer.put returns", (boolean)multiplexer.put(TABLE, put));
        TestHTableMultiplexerFlushCache.checkExistence(htable, row, FAMILY, QUALIFIER1, VALUE1);
        HRegionLocation loc = regionLocator.getRegionLocation(row);
        MiniHBaseCluster hbaseCluster = TEST_UTIL.getHBaseCluster();
        ServerName originalServer = loc.getServerName();
        ServerName newServer = null;
        for (int i = 0; i < SLAVES; ++i) {
            HRegionServer rs = hbaseCluster.getRegionServer(i);
            if (rs.getServerName().equals((Object)originalServer)) continue;
            newServer = rs.getServerName();
            break;
        }
        Assert.assertNotNull((String)"Did not find a new RegionServer to use", newServer);
        LOG.info((Object)("Moving " + loc.getRegionInfo().getEncodedName() + " from " + originalServer + " to " + newServer));
        TEST_UTIL.getHBaseAdmin().move(loc.getRegionInfo().getEncodedNameAsBytes(), Bytes.toBytes((String)newServer.getServerName()));
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLE);
        put = new Put(row).addColumn(FAMILY, QUALIFIER2, VALUE2);
        Assert.assertTrue((String)"multiplexer.put returns", (boolean)multiplexer.put(TABLE, put));
        TestHTableMultiplexerFlushCache.checkExistence(htable, row, FAMILY, QUALIFIER2, VALUE2);
    }
}

