/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCompactSplitThread {
    private static final Log LOG = LogFactory.getLog(TestCompactSplitThread.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
    private final byte[] family = Bytes.toBytes((String)"f");
    private static final int NUM_RS = 1;
    private static final int blockingStoreFiles = 3;
    private static Path rootDir;
    private static FileSystem fs;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestCompactSplitThread.setupConf(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(1);
        fs = TEST_UTIL.getDFSCluster().getFileSystem();
        rootDir = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
    }

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hstore.compaction.min", 2);
        conf.setInt("hbase.hstore.compactionThreshold", 5);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.blockingStoreFiles", 3);
        conf.setInt("hbase.regionserver.thread.compaction.large", 3);
        conf.setInt("hbase.regionserver.thread.compaction.small", 4);
        conf.setInt("hbase.regionserver.thread.split", 5);
        conf.setInt("hbase.regionserver.thread.merge", 6);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            TEST_UTIL.shutdownMiniCluster();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadPoolSizeTuning() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
            HTableDescriptor htd = new HTableDescriptor(this.tableName);
            htd.addFamily(new HColumnDescriptor(this.family));
            htd.setCompactionEnabled(false);
            TEST_UTIL.getHBaseAdmin().createTable(htd);
            TEST_UTIL.waitTableAvailable(this.tableName);
            HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(this.tableName);
            Assert.assertEquals((long)3L, (long)regionServer.compactSplitThread.getLargeCompactionThreadNum());
            Assert.assertEquals((long)4L, (long)regionServer.compactSplitThread.getSmallCompactionThreadNum());
            Assert.assertEquals((long)5L, (long)regionServer.compactSplitThread.getSplitThreadNum());
            Assert.assertEquals((long)6L, (long)regionServer.compactSplitThread.getMergeThreadNum());
            conf.setInt("hbase.regionserver.thread.compaction.large", 4);
            conf.setInt("hbase.regionserver.thread.compaction.small", 5);
            conf.setInt("hbase.regionserver.thread.split", 6);
            conf.setInt("hbase.regionserver.thread.merge", 7);
            try {
                regionServer.compactSplitThread.onConfigurationChange(conf);
            }
            catch (IllegalArgumentException iae) {
                Assert.fail((String)"Update bigger configuration failed!");
            }
            Assert.assertEquals((long)4L, (long)regionServer.compactSplitThread.getLargeCompactionThreadNum());
            Assert.assertEquals((long)5L, (long)regionServer.compactSplitThread.getSmallCompactionThreadNum());
            Assert.assertEquals((long)6L, (long)regionServer.compactSplitThread.getSplitThreadNum());
            Assert.assertEquals((long)7L, (long)regionServer.compactSplitThread.getMergeThreadNum());
            conf.setInt("hbase.regionserver.thread.compaction.large", 2);
            conf.setInt("hbase.regionserver.thread.compaction.small", 3);
            conf.setInt("hbase.regionserver.thread.split", 4);
            conf.setInt("hbase.regionserver.thread.merge", 5);
            try {
                regionServer.compactSplitThread.onConfigurationChange(conf);
            }
            catch (IllegalArgumentException iae) {
                Assert.fail((String)"Update smaller configuration failed!");
            }
            Assert.assertEquals((long)2L, (long)regionServer.compactSplitThread.getLargeCompactionThreadNum());
            Assert.assertEquals((long)3L, (long)regionServer.compactSplitThread.getSmallCompactionThreadNum());
            Assert.assertEquals((long)4L, (long)regionServer.compactSplitThread.getSplitThreadNum());
            Assert.assertEquals((long)5L, (long)regionServer.compactSplitThread.getMergeThreadNum());
        }
    }

    @Test(timeout=60000L)
    public void testFlushWithTableCompactionDisabled() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.tableName);
        htd.setCompactionEnabled(false);
        TEST_UTIL.createTable(htd, (byte[][])new byte[][]{this.family}, null);
        for (int i = 0; i < 4; ++i) {
            TEST_UTIL.loadTable(TEST_UTIL.getConnection().getTable(this.tableName), this.family);
            TEST_UTIL.flush(this.tableName);
        }
        Path tableDir = FSUtils.getTableDir((Path)rootDir, (TableName)this.tableName);
        ArrayList<String> hfiles = SnapshotTestingUtils.listHFileNames(fs, tableDir);
        assert (hfiles.size() > 4);
    }
}

