/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationListener;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationTrackerZKImpl {
    private static final Log LOG = LogFactory.getLog(TestReplicationTrackerZKImpl.class);
    private static Configuration conf;
    private static HBaseTestingUtility utility;
    private ZooKeeperWatcher zkw;
    private ReplicationPeers rp;
    private ReplicationTracker rt;
    private AtomicInteger rsRemovedCount;
    private String rsRemovedData;
    private AtomicInteger plChangedCount;
    private List<String> plChangedData;
    private AtomicInteger peerRemovedCount;
    private String peerRemovedData;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        utility = new HBaseTestingUtility();
        utility.startMiniZKCluster();
        conf = utility.getConfiguration();
        ZooKeeperWatcher zk = HBaseTestingUtility.getZooKeeperWatcher(utility);
        ZKUtil.createWithParents((ZooKeeperWatcher)zk, (String)zk.rsZNode);
    }

    @Before
    public void setUp() throws Exception {
        this.zkw = HBaseTestingUtility.getZooKeeperWatcher(utility);
        String fakeRs1 = ZKUtil.joinZNode((String)this.zkw.rsZNode, (String)"hostname1.example.org:1234");
        try {
            ZKClusterId.setClusterId((ZooKeeperWatcher)this.zkw, (ClusterId)new ClusterId());
            this.rp = ReplicationFactory.getReplicationPeers((ZooKeeperWatcher)this.zkw, (Configuration)conf, (Abortable)this.zkw);
            this.rp.init();
            this.rt = ReplicationFactory.getReplicationTracker((ZooKeeperWatcher)this.zkw, (ReplicationPeers)this.rp, (Configuration)conf, (Abortable)this.zkw, (Stoppable)new DummyServer(fakeRs1));
        }
        catch (Exception e) {
            Assert.fail((String)("Exception during test setup: " + e));
        }
        this.rsRemovedCount = new AtomicInteger(0);
        this.rsRemovedData = "";
        this.plChangedCount = new AtomicInteger(0);
        this.plChangedData = new ArrayList<String>();
        this.peerRemovedCount = new AtomicInteger(0);
        this.peerRemovedData = "";
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility.shutdownMiniZKCluster();
    }

    @Test
    public void testGetListOfRegionServers() throws Exception {
        Assert.assertEquals((long)0L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.createWithParents((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.zkw.rsZNode, (String)"hostname1.example.org:1234"));
        Assert.assertEquals((long)1L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.createWithParents((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.zkw.rsZNode, (String)"hostname2.example.org:1234"));
        Assert.assertEquals((long)2L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.deleteNode((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.zkw.rsZNode, (String)"hostname2.example.org:1234"));
        Assert.assertEquals((long)1L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.deleteNode((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.zkw.rsZNode, (String)"hostname1.example.org:1234"));
        Assert.assertEquals((long)0L, (long)this.rt.getListOfRegionServers().size());
    }

    @Test(timeout=30000L)
    public void testRegionServerRemovedEvent() throws Exception {
        ZKUtil.createAndWatch((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.zkw.rsZNode, (String)"hostname2.example.org:1234"), (byte[])HConstants.EMPTY_BYTE_ARRAY);
        this.rt.registerListener((ReplicationListener)new DummyReplicationListener());
        ZKUtil.deleteNode((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.zkw.rsZNode, (String)"hostname2.example.org:1234"));
        while (this.rsRemovedCount.get() < 1) {
            Thread.sleep(5L);
        }
        Assert.assertEquals((Object)"hostname2.example.org:1234", (Object)this.rsRemovedData);
    }

    @Test(timeout=30000L)
    public void testPeerRemovedEvent() throws Exception {
        this.rp.addPeer("5", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()));
        this.rt.registerListener((ReplicationListener)new DummyReplicationListener());
        this.rp.removePeer("5");
        while (this.peerRemovedCount.get() < 1) {
            Thread.sleep(5L);
        }
        Assert.assertEquals((Object)"5", (Object)this.peerRemovedData);
    }

    @Test(timeout=30000L)
    public void testPeerListChangedEvent() throws Exception {
        this.rp.addPeer("5", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()));
        this.zkw.getRecoverableZooKeeper().getZooKeeper().getChildren("/hbase/replication/peers/5", true);
        this.rt.registerListener((ReplicationListener)new DummyReplicationListener());
        this.rp.disablePeer("5");
        int tmp = this.plChangedCount.get();
        LOG.info((Object)("Peer count=" + tmp));
        ZKUtil.deleteNode((ZooKeeperWatcher)this.zkw, (String)"/hbase/replication/peers/5/peer-state");
        while (this.plChangedCount.get() <= tmp) {
            Thread.sleep(100L);
            LOG.info((Object)("Peer count=" + tmp));
        }
        Assert.assertEquals((long)1L, (long)this.plChangedData.size());
        Assert.assertTrue((boolean)this.plChangedData.contains("5"));
        this.rp.removePeer("5");
    }

    @Test(timeout=30000L)
    public void testPeerNameControl() throws Exception {
        int exists = 0;
        int hyphen = 0;
        this.rp.addPeer("6", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()));
        try {
            this.rp.addPeer("6", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()));
        }
        catch (IllegalArgumentException e) {
            ++exists;
        }
        try {
            this.rp.addPeer("6-ec2", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()));
        }
        catch (IllegalArgumentException e) {
            ++hyphen;
        }
        Assert.assertEquals((long)1L, (long)exists);
        Assert.assertEquals((long)1L, (long)hyphen);
        this.rp.removePeer("6");
    }

    private class DummyServer
    implements Server {
        private String serverName;
        private boolean isAborted = false;
        private boolean isStopped = false;

        public DummyServer(String serverName) {
            this.serverName = serverName;
        }

        public Configuration getConfiguration() {
            return conf;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return TestReplicationTrackerZKImpl.this.zkw;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.serverName);
        }

        public void abort(String why, Throwable e) {
            LOG.info((Object)("Aborting " + this.serverName));
            this.isAborted = true;
        }

        public boolean isAborted() {
            return this.isAborted;
        }

        public void stop(String why) {
            this.isStopped = true;
        }

        public boolean isStopped() {
            return this.isStopped;
        }

        public ChoreService getChoreService() {
            return null;
        }
    }

    private class DummyReplicationListener
    implements ReplicationListener {
        private DummyReplicationListener() {
        }

        public void regionServerRemoved(String regionServer) {
            TestReplicationTrackerZKImpl.this.rsRemovedData = regionServer;
            TestReplicationTrackerZKImpl.this.rsRemovedCount.getAndIncrement();
            LOG.debug((Object)("Received regionServerRemoved event: " + regionServer));
        }

        public void peerRemoved(String peerId) {
            TestReplicationTrackerZKImpl.this.peerRemovedData = peerId;
            TestReplicationTrackerZKImpl.this.peerRemovedCount.getAndIncrement();
            LOG.debug((Object)("Received peerRemoved event: " + peerId));
        }

        public void peerListChanged(List<String> peerIds) {
            TestReplicationTrackerZKImpl.this.plChangedData.clear();
            TestReplicationTrackerZKImpl.this.plChangedData.addAll(peerIds);
            int count = TestReplicationTrackerZKImpl.this.plChangedCount.getAndIncrement();
            LOG.debug((Object)("Received peerListChanged event " + count));
        }
    }
}

