// Autogenerated Jamon implementation
// /home/stack/hbase.git/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/common/TaskMonitorTmpl.jamon

package org.apache.hadoop.hbase.tmpl.common;

// 20, 1
import java.util.*;
// 21, 1
import org.apache.hadoop.hbase.monitoring.*;
// 22, 1
import org.apache.hadoop.util.StringUtils;

public class TaskMonitorTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.Intf

{
  private final String filter;
  private final String format;
  private final TaskMonitor taskMonitor;
  protected static org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData p_implData)
  {
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getTaskMonitor__IsNotDefault())
    {
      p_implData.setTaskMonitor(TaskMonitor.get());
    }
    return p_implData;
  }
  public TaskMonitorTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
    taskMonitor = p_implData.getTaskMonitor();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 29, 1
    
// apply requested filter
List<? extends MonitoredTask> tasks = taskMonitor.getTasks(filter);
long now = System.currentTimeMillis();
Collections.reverse(tasks);
boolean first = true;

    // 36, 1
    if (format.equals("json"))
    {
      // 36, 29
      jamonWriter.write("\n[");
      // 37, 2
      for (MonitoredTask task : tasks)
      {
        // 37, 36
        if (first)
        {
          // 37, 48
          first = false;
        }
        // 37, 77
        else
        {
          // 37, 84
          jamonWriter.write(",");
        }
        // 37, 91
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.toJSON()), jamonWriter);
      }
      // 37, 117
      jamonWriter.write("]\n");
    }
    // 38, 1
    else
    {
      // 38, 8
      jamonWriter.write("\n<h2>Tasks</h2>\n  <ul class=\"nav nav-pills\">\n    <li ");
      // 41, 9
      if (filter.equals("all"))
      {
        // 41, 36
        jamonWriter.write("class=\"active\"");
      }
      // 41, 56
      jamonWriter.write("><a href=\"?filter=all\">Show All Monitored Tasks</a></li>\n    <li ");
      // 42, 9
      if (filter.equals("general"))
      {
        // 42, 40
        jamonWriter.write("class=\"active\"");
      }
      // 42, 60
      jamonWriter.write("><a href=\"?filter=general\">Show non-RPC Tasks</a></li>\n    <li ");
      // 43, 9
      if (filter.equals("handler"))
      {
        // 43, 40
        jamonWriter.write("class=\"active\"");
      }
      // 43, 60
      jamonWriter.write("><a href=\"?filter=handler\">Show All RPC Handler Tasks</a></li>\n    <li ");
      // 44, 9
      if (filter.equals("rpc"))
      {
        // 44, 36
        jamonWriter.write("class=\"active\"");
      }
      // 44, 56
      jamonWriter.write("><a href=\"?filter=rpc\">Show Active RPC Calls</a></li>\n    <li ");
      // 45, 9
      if (filter.equals("operation"))
      {
        // 45, 42
        jamonWriter.write("class=\"active\"");
      }
      // 45, 62
      jamonWriter.write("><a href=\"?filter=operation\">Show Client Operations</a></li>\n    <li><a href=\"?format=json&filter=");
      // 46, 38
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(filter), jamonWriter);
      // 46, 50
      jamonWriter.write("\">View as JSON</a></li>\n  </ul>\n  ");
      // 48, 3
      if (tasks.isEmpty())
      {
        // 48, 25
        jamonWriter.write("\n    <p>No tasks currently running on this node.</p>\n  ");
      }
      // 50, 3
      else
      {
        // 50, 10
        jamonWriter.write("\n    <table class=\"table\">\n    <tr>\n      <th>Start Time</th>\n      <th>Description</th>\n      <th>State</th>\n      <th>Status</th>\n    </tr>\n    ");
        // 58, 5
        for (MonitoredTask task : tasks )
        {
          // 58, 40
          jamonWriter.write("\n    <tr class=\"");
          // 59, 16
          {
            // 59, 16
            __jamon_innerUnit__stateCss(jamonWriter, task.getState() );
          }
          // 59, 55
          jamonWriter.write("\">\n      <td>");
          // 60, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(task.getStartTime())), jamonWriter);
          // 60, 46
          jamonWriter.write("</td>\n      <td>");
          // 61, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getDescription()), jamonWriter);
          // 61, 38
          jamonWriter.write("</td>\n      <td>");
          // 62, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getState()), jamonWriter);
          // 62, 32
          jamonWriter.write("\n          (since ");
          // 63, 18
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStateTime())), jamonWriter);
          // 63, 76
          jamonWriter.write(" ago)\n      </td>\n      <td>");
          // 65, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getStatus()), jamonWriter);
          // 65, 33
          jamonWriter.write("\n          (since ");
          // 66, 18
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStatusTime())), jamonWriter);
          // 66, 77
          jamonWriter.write(" \n          ago)</td>\n    </tr>\n    ");
        }
        // 69, 12
        jamonWriter.write("\n    </table>\n\n  ");
      }
      // 72, 9
      jamonWriter.write("\n");
    }
    // 73, 7
    jamonWriter.write("\n\n\n");
  }
  
  
  // 76, 1
  private void __jamon_innerUnit__stateCss(final java.io.Writer jamonWriter, final MonitoredTask.State state)
    throws java.io.IOException
  {
    // 80, 1
           if (state == MonitoredTask.State.COMPLETE) { 
    // 80, 68
    jamonWriter.write("alert alert-success");
    // 80, 87
     } 
    // 81, 1
      else if (state == MonitoredTask.State.ABORTED)  { 
    // 81, 68
    jamonWriter.write("alert alert-error");
    // 81, 85
       } 
  }
  
  
}
