/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.io.netty.channel.Channel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ServerChannel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.hadoop.hbase.util.JVM;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NettyEventLoopGroupConfig {
    private final EventLoopGroup group;
    private final Class<? extends ServerChannel> serverChannelClass;
    private final Class<? extends Channel> clientChannelClass;

    private static boolean useEpoll(Configuration conf) {
        boolean epollEnabled = conf.getBoolean("hbase.netty.nativetransport", true);
        return epollEnabled && JVM.isLinux() && JVM.isAmd64();
    }

    public NettyEventLoopGroupConfig(Configuration conf, String threadPoolName) {
        boolean useEpoll = NettyEventLoopGroupConfig.useEpoll(conf);
        int workerCount = conf.getInt("hbase.netty.worker.count", 0);
        DefaultThreadFactory eventLoopThreadFactory = new DefaultThreadFactory(threadPoolName, true, 10);
        if (useEpoll) {
            this.group = new EpollEventLoopGroup(workerCount, (ThreadFactory)eventLoopThreadFactory);
            this.serverChannelClass = EpollServerSocketChannel.class;
            this.clientChannelClass = EpollSocketChannel.class;
        } else {
            this.group = new NioEventLoopGroup(workerCount, (ThreadFactory)eventLoopThreadFactory);
            this.serverChannelClass = NioServerSocketChannel.class;
            this.clientChannelClass = NioSocketChannel.class;
        }
    }

    public EventLoopGroup group() {
        return this.group;
    }

    public Class<? extends ServerChannel> serverChannelClass() {
        return this.serverChannelClass;
    }

    public Class<? extends Channel> clientChannelClass() {
        return this.clientChannelClass;
    }
}

