/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Iterator;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockCachesIterator;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.FirstLevelBlockCache;
import org.apache.hadoop.hbase.io.hfile.ResizableBlockCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CombinedBlockCache
implements ResizableBlockCache,
HeapSize {
    protected final FirstLevelBlockCache l1Cache;
    protected final BlockCache l2Cache;
    protected final CombinedCacheStats combinedCacheStats;

    public CombinedBlockCache(FirstLevelBlockCache l1Cache, BlockCache l2Cache) {
        this.l1Cache = l1Cache;
        this.l2Cache = l2Cache;
        this.combinedCacheStats = new CombinedCacheStats(l1Cache.getStats(), l2Cache.getStats());
    }

    public long heapSize() {
        long l2size = 0L;
        if (this.l2Cache instanceof HeapSize) {
            l2size = ((HeapSize)this.l2Cache).heapSize();
        }
        return this.l1Cache.heapSize() + l2size;
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        boolean metaBlock;
        boolean bl = metaBlock = buf.getBlockType().getCategory() != BlockType.BlockCategory.DATA;
        if (metaBlock) {
            this.l1Cache.cacheBlock(cacheKey, buf, inMemory);
        } else {
            this.l2Cache.cacheBlock(cacheKey, buf, inMemory);
        }
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        this.cacheBlock(cacheKey, buf, false);
    }

    @Override
    public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        return this.l1Cache.containsBlock(cacheKey) ? this.l1Cache.getBlock(cacheKey, caching, repeat, updateCacheMetrics) : this.l2Cache.getBlock(cacheKey, caching, repeat, updateCacheMetrics);
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        return this.l1Cache.evictBlock(cacheKey) || this.l2Cache.evictBlock(cacheKey);
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        return this.l1Cache.evictBlocksByHfileName(hfileName) + this.l2Cache.evictBlocksByHfileName(hfileName);
    }

    @Override
    public CacheStats getStats() {
        return this.combinedCacheStats;
    }

    @Override
    public void shutdown() {
        this.l1Cache.shutdown();
        this.l2Cache.shutdown();
    }

    @Override
    public long size() {
        return this.l1Cache.size() + this.l2Cache.size();
    }

    @Override
    public long getMaxSize() {
        return this.l1Cache.getMaxSize() + this.l2Cache.getMaxSize();
    }

    @Override
    public long getCurrentDataSize() {
        return this.l1Cache.getCurrentDataSize() + this.l2Cache.getCurrentDataSize();
    }

    @Override
    public long getFreeSize() {
        return this.l1Cache.getFreeSize() + this.l2Cache.getFreeSize();
    }

    @Override
    public long getCurrentSize() {
        return this.l1Cache.getCurrentSize() + this.l2Cache.getCurrentSize();
    }

    @Override
    public long getBlockCount() {
        return this.l1Cache.getBlockCount() + this.l2Cache.getBlockCount();
    }

    @Override
    public long getDataBlockCount() {
        return this.l1Cache.getDataBlockCount() + this.l2Cache.getDataBlockCount();
    }

    @Override
    public Iterator<CachedBlock> iterator() {
        return new BlockCachesIterator(this.getBlockCaches());
    }

    @Override
    public BlockCache[] getBlockCaches() {
        return new BlockCache[]{this.l1Cache, this.l2Cache};
    }

    @Override
    public void setMaxSize(long size) {
        this.l1Cache.setMaxSize(size);
    }

    @VisibleForTesting
    public int getRpcRefCount(BlockCacheKey cacheKey) {
        return this.l2Cache instanceof BucketCache ? ((BucketCache)this.l2Cache).getRpcRefCount(cacheKey) : 0;
    }

    public FirstLevelBlockCache getFirstLevelCache() {
        return this.l1Cache;
    }

    public static class CombinedCacheStats
    extends CacheStats {
        private final CacheStats lruCacheStats;
        private final CacheStats bucketCacheStats;

        CombinedCacheStats(CacheStats lbcStats, CacheStats fcStats) {
            super("CombinedBlockCache");
            this.lruCacheStats = lbcStats;
            this.bucketCacheStats = fcStats;
        }

        public CacheStats getLruCacheStats() {
            return this.lruCacheStats;
        }

        public CacheStats getBucketCacheStats() {
            return this.bucketCacheStats;
        }

        @Override
        public long getDataMissCount() {
            return this.lruCacheStats.getDataMissCount() + this.bucketCacheStats.getDataMissCount();
        }

        @Override
        public long getLeafIndexMissCount() {
            return this.lruCacheStats.getLeafIndexMissCount() + this.bucketCacheStats.getLeafIndexMissCount();
        }

        @Override
        public long getBloomChunkMissCount() {
            return this.lruCacheStats.getBloomChunkMissCount() + this.bucketCacheStats.getBloomChunkMissCount();
        }

        @Override
        public long getMetaMissCount() {
            return this.lruCacheStats.getMetaMissCount() + this.bucketCacheStats.getMetaMissCount();
        }

        @Override
        public long getRootIndexMissCount() {
            return this.lruCacheStats.getRootIndexMissCount() + this.bucketCacheStats.getRootIndexMissCount();
        }

        @Override
        public long getIntermediateIndexMissCount() {
            return this.lruCacheStats.getIntermediateIndexMissCount() + this.bucketCacheStats.getIntermediateIndexMissCount();
        }

        @Override
        public long getFileInfoMissCount() {
            return this.lruCacheStats.getFileInfoMissCount() + this.bucketCacheStats.getFileInfoMissCount();
        }

        @Override
        public long getGeneralBloomMetaMissCount() {
            return this.lruCacheStats.getGeneralBloomMetaMissCount() + this.bucketCacheStats.getGeneralBloomMetaMissCount();
        }

        @Override
        public long getDeleteFamilyBloomMissCount() {
            return this.lruCacheStats.getDeleteFamilyBloomMissCount() + this.bucketCacheStats.getDeleteFamilyBloomMissCount();
        }

        @Override
        public long getTrailerMissCount() {
            return this.lruCacheStats.getTrailerMissCount() + this.bucketCacheStats.getTrailerMissCount();
        }

        @Override
        public long getDataHitCount() {
            return this.lruCacheStats.getDataHitCount() + this.bucketCacheStats.getDataHitCount();
        }

        @Override
        public long getLeafIndexHitCount() {
            return this.lruCacheStats.getLeafIndexHitCount() + this.bucketCacheStats.getLeafIndexHitCount();
        }

        @Override
        public long getBloomChunkHitCount() {
            return this.lruCacheStats.getBloomChunkHitCount() + this.bucketCacheStats.getBloomChunkHitCount();
        }

        @Override
        public long getMetaHitCount() {
            return this.lruCacheStats.getMetaHitCount() + this.bucketCacheStats.getMetaHitCount();
        }

        @Override
        public long getRootIndexHitCount() {
            return this.lruCacheStats.getRootIndexHitCount() + this.bucketCacheStats.getRootIndexHitCount();
        }

        @Override
        public long getIntermediateIndexHitCount() {
            return this.lruCacheStats.getIntermediateIndexHitCount() + this.bucketCacheStats.getIntermediateIndexHitCount();
        }

        @Override
        public long getFileInfoHitCount() {
            return this.lruCacheStats.getFileInfoHitCount() + this.bucketCacheStats.getFileInfoHitCount();
        }

        @Override
        public long getGeneralBloomMetaHitCount() {
            return this.lruCacheStats.getGeneralBloomMetaHitCount() + this.bucketCacheStats.getGeneralBloomMetaHitCount();
        }

        @Override
        public long getDeleteFamilyBloomHitCount() {
            return this.lruCacheStats.getDeleteFamilyBloomHitCount() + this.bucketCacheStats.getDeleteFamilyBloomHitCount();
        }

        @Override
        public long getTrailerHitCount() {
            return this.lruCacheStats.getTrailerHitCount() + this.bucketCacheStats.getTrailerHitCount();
        }

        @Override
        public long getRequestCount() {
            return this.lruCacheStats.getRequestCount() + this.bucketCacheStats.getRequestCount();
        }

        @Override
        public long getRequestCachingCount() {
            return this.lruCacheStats.getRequestCachingCount() + this.bucketCacheStats.getRequestCachingCount();
        }

        @Override
        public long getMissCount() {
            return this.lruCacheStats.getMissCount() + this.bucketCacheStats.getMissCount();
        }

        @Override
        public long getPrimaryMissCount() {
            return this.lruCacheStats.getPrimaryMissCount() + this.bucketCacheStats.getPrimaryMissCount();
        }

        @Override
        public long getMissCachingCount() {
            return this.lruCacheStats.getMissCachingCount() + this.bucketCacheStats.getMissCachingCount();
        }

        @Override
        public long getHitCount() {
            return this.lruCacheStats.getHitCount() + this.bucketCacheStats.getHitCount();
        }

        @Override
        public long getPrimaryHitCount() {
            return this.lruCacheStats.getPrimaryHitCount() + this.bucketCacheStats.getPrimaryHitCount();
        }

        @Override
        public long getHitCachingCount() {
            return this.lruCacheStats.getHitCachingCount() + this.bucketCacheStats.getHitCachingCount();
        }

        @Override
        public long getEvictionCount() {
            return this.lruCacheStats.getEvictionCount() + this.bucketCacheStats.getEvictionCount();
        }

        @Override
        public long getEvictedCount() {
            return this.lruCacheStats.getEvictedCount() + this.bucketCacheStats.getEvictedCount();
        }

        @Override
        public long getPrimaryEvictedCount() {
            return this.lruCacheStats.getPrimaryEvictedCount() + this.bucketCacheStats.getPrimaryEvictedCount();
        }

        @Override
        public void rollMetricsPeriod() {
            this.lruCacheStats.rollMetricsPeriod();
            this.bucketCacheStats.rollMetricsPeriod();
        }

        @Override
        public long getFailedInserts() {
            return this.lruCacheStats.getFailedInserts() + this.bucketCacheStats.getFailedInserts();
        }

        @Override
        public long getSumHitCountsPastNPeriods() {
            return this.lruCacheStats.getSumHitCountsPastNPeriods() + this.bucketCacheStats.getSumHitCountsPastNPeriods();
        }

        @Override
        public long getSumRequestCountsPastNPeriods() {
            return this.lruCacheStats.getSumRequestCountsPastNPeriods() + this.bucketCacheStats.getSumRequestCountsPastNPeriods();
        }

        @Override
        public long getSumHitCachingCountsPastNPeriods() {
            return this.lruCacheStats.getSumHitCachingCountsPastNPeriods() + this.bucketCacheStats.getSumHitCachingCountsPastNPeriods();
        }

        @Override
        public long getSumRequestCachingCountsPastNPeriods() {
            return this.lruCacheStats.getSumRequestCachingCountsPastNPeriods() + this.bucketCacheStats.getSumRequestCachingCountsPastNPeriods();
        }
    }
}

