/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class EnableTableProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.EnableTableState> {
    private static final Logger LOG = LoggerFactory.getLogger(EnableTableProcedure.class);
    private TableName tableName;

    public EnableTableProcedure() {
    }

    public EnableTableProcedure(MasterProcedureEnv env, TableName tableName) {
        this(env, tableName, null);
    }

    public EnableTableProcedure(MasterProcedureEnv env, TableName tableName, ProcedurePrepareLatch syncLatch) {
        super(env, syncLatch);
        this.tableName = tableName;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case ENABLE_TABLE_PREPARE: {
                    if (this.prepareEnable(env)) {
                        this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_PRE_OPERATION);
                        break;
                    }
                    assert (this.isFailed()) : "enable should have an exception here";
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case ENABLE_TABLE_PRE_OPERATION: {
                    this.preEnable(env, state);
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_SET_ENABLING_TABLE_STATE);
                    break;
                }
                case ENABLE_TABLE_SET_ENABLING_TABLE_STATE: {
                    EnableTableProcedure.setTableStateToEnabling(env, this.tableName);
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_MARK_REGIONS_ONLINE);
                    break;
                }
                case ENABLE_TABLE_MARK_REGIONS_ONLINE: {
                    Connection connection = env.getMasterServices().getConnection();
                    TableDescriptor tableDescriptor = env.getMasterServices().getTableDescriptors().get(this.tableName);
                    int configuredReplicaCount = tableDescriptor.getRegionReplication();
                    List regionsOfTable = env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.tableName, true);
                    int currentMaxReplica = EnableTableProcedure.getMaxReplicaId(regionsOfTable);
                    int replicasFound = TableName.isMetaTableName((TableName)this.tableName) ? 0 : this.getReplicaCountInMeta(connection, configuredReplicaCount, regionsOfTable);
                    LOG.info("replicasFound={} (configuredReplicaCount={} for {}", new Object[]{replicasFound, configuredReplicaCount, this.tableName.getNameAsString()});
                    if (currentMaxReplica == configuredReplicaCount - 1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No change in number of region replicas (configuredReplicaCount={}); assigning.", (Object)configuredReplicaCount);
                        }
                    } else if (currentMaxReplica > configuredReplicaCount - 1) {
                        LOG.info("The number of replicas " + (currentMaxReplica + 1) + "  is more than the region replica count " + configuredReplicaCount);
                        ArrayList copyOfRegions = new ArrayList(regionsOfTable);
                        for (RegionInfo regionInfo : copyOfRegions) {
                            if (regionInfo.getReplicaId() <= configuredReplicaCount - 1) continue;
                            env.getAssignmentManager().getRegionStates().deleteRegion(regionInfo);
                            LOG.info("Removed replica={} of {}", (Object)regionInfo.getRegionId(), (Object)regionInfo);
                            regionsOfTable.remove(regionInfo);
                        }
                    } else {
                        LOG.info("Number of replicas has increased. Assigning new region replicas.The previous replica count was {}. The current replica count is {}.", (Object)(currentMaxReplica + 1), (Object)configuredReplicaCount);
                        regionsOfTable = RegionReplicaUtil.addReplicas(regionsOfTable, (int)(currentMaxReplica + 1), (int)configuredReplicaCount);
                    }
                    this.addChildProcedure((Procedure[])env.getAssignmentManager().createAssignProcedures(regionsOfTable));
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_SET_ENABLED_TABLE_STATE);
                    break;
                }
                case ENABLE_TABLE_SET_ENABLED_TABLE_STATE: {
                    EnableTableProcedure.setTableStateToEnabled(env, this.tableName);
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_POST_OPERATION);
                    break;
                }
                case ENABLE_TABLE_POST_OPERATION: {
                    this.postEnable(env, state);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-enable-table", e);
            }
            LOG.warn("Retriable error trying to enable table=" + this.tableName + " (in state=" + state + ")", (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private int getReplicaCountInMeta(Connection connection, int regionReplicaCount, List<RegionInfo> regionsOfTable) throws IOException {
        Result r = MetaTableAccessor.getCatalogFamilyRow((Connection)connection, (RegionInfo)regionsOfTable.get(0));
        int replicasFound = 0;
        for (int i = 1; i < regionReplicaCount; ++i) {
            List columnCells = r.getColumnCells(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)i));
            if (columnCells.isEmpty()) continue;
            ++replicasFound;
        }
        return replicasFound;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException {
        switch (state) {
            case ENABLE_TABLE_PRE_OPERATION: {
                return;
            }
            case ENABLE_TABLE_PREPARE: {
                this.releaseSyncLatch();
                return;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.EnableTableState state) {
        switch (state) {
            case ENABLE_TABLE_PREPARE: 
            case ENABLE_TABLE_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.EnableTableState getState(int stateId) {
        return MasterProcedureProtos.EnableTableState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.EnableTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.EnableTableState getInitialState() {
        return MasterProcedureProtos.EnableTableState.ENABLE_TABLE_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.EnableTableStateData.Builder enableTableMsg = MasterProcedureProtos.EnableTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName)).setSkipTableStateCheck(false);
        serializer.serialize((Message)enableTableMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.EnableTableStateData enableTableMsg = (MasterProcedureProtos.EnableTableStateData)serializer.deserialize(MasterProcedureProtos.EnableTableStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(enableTableMsg.getUserInfo()));
        this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)enableTableMsg.getTableName());
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.ENABLE;
    }

    private boolean prepareEnable(MasterProcedureEnv env) throws IOException {
        boolean canTableBeEnabled = true;
        if (!MetaTableAccessor.tableExists((Connection)env.getMasterServices().getConnection(), (TableName)this.tableName)) {
            this.setFailure("master-enable-table", new TableNotFoundException(this.tableName));
            canTableBeEnabled = false;
        } else {
            TableStateManager tsm = env.getMasterServices().getTableStateManager();
            TableState ts = tsm.getTableState(this.tableName);
            if (!ts.isDisabled()) {
                LOG.info("Not DISABLED tableState={}; skipping enable; {}", (Object)ts.getState(), (Object)this);
                this.setFailure("master-enable-table", new TableNotDisabledException(ts.toString()));
                canTableBeEnabled = false;
            }
        }
        this.releaseSyncLatch();
        return canTableBeEnabled;
    }

    private void preEnable(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    protected static void setTableStateToEnabling(MasterProcedureEnv env, TableName tableName) throws IOException {
        LOG.info("Attempting to enable the table " + tableName);
        env.getMasterServices().getTableStateManager().setTableState(tableName, TableState.State.ENABLING);
    }

    protected static void setTableStateToEnabled(MasterProcedureEnv env, TableName tableName) throws IOException {
        env.getMasterServices().getTableStateManager().setTableState(tableName, TableState.State.ENABLED);
        LOG.info("Table '" + tableName + "' was successfully enabled.");
    }

    private void postEnable(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void runCoprocessorAction(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            switch (state) {
                case ENABLE_TABLE_PRE_OPERATION: {
                    cpHost.preEnableTableAction(this.getTableName(), this.getUser());
                    break;
                }
                case ENABLE_TABLE_POST_OPERATION: {
                    cpHost.postCompletedEnableTableAction(this.getTableName(), this.getUser());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
    }

    private static int getMaxReplicaId(List<RegionInfo> regions) {
        int max = 0;
        for (RegionInfo regionInfo : regions) {
            if (regionInfo.getReplicaId() <= max) continue;
            max = regionInfo.getReplicaId();
        }
        return max;
    }
}

