/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.compactions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mob.compactions.MobCompactionRequest;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PartitionedMobCompactionRequest
extends MobCompactionRequest {
    protected List<CompactionDelPartition> delPartitions;
    protected Collection<CompactionPartition> compactionPartitions;

    public PartitionedMobCompactionRequest(Collection<CompactionPartition> compactionPartitions, List<CompactionDelPartition> delPartitions) {
        this.selectionTime = EnvironmentEdgeManager.currentTime();
        this.compactionPartitions = compactionPartitions;
        this.delPartitions = delPartitions;
    }

    public Collection<CompactionPartition> getCompactionPartitions() {
        return this.compactionPartitions;
    }

    public List<CompactionDelPartition> getDelPartitions() {
        return this.delPartitions;
    }

    public static class CompactionDelPartitionId
    implements Comparable<CompactionDelPartitionId> {
        private byte[] startKey;
        private byte[] endKey;

        public CompactionDelPartitionId() {
        }

        public CompactionDelPartitionId(byte[] startKey, byte[] endKey) {
            this.startKey = startKey;
            this.endKey = endKey;
        }

        public byte[] getStartKey() {
            return this.startKey;
        }

        public void setStartKey(byte[] startKey) {
            this.startKey = startKey;
        }

        public byte[] getEndKey() {
            return this.endKey;
        }

        public void setEndKey(byte[] endKey) {
            this.endKey = endKey;
        }

        @Override
        public int compareTo(CompactionDelPartitionId o) {
            int result = Bytes.compareTo((byte[])this.startKey, (byte[])o.getStartKey());
            if (result != 0) {
                return result;
            }
            return Bytes.compareTo((byte[])this.endKey, (byte[])o.getEndKey());
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + Arrays.hashCode(this.startKey);
            result = 31 * result + Arrays.hashCode(this.endKey);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CompactionDelPartitionId)) {
                return false;
            }
            CompactionDelPartitionId another = (CompactionDelPartitionId)obj;
            return this.compareTo(another) == 0;
        }
    }

    protected static class CompactionDelPartition {
        private List<Path> delFiles = new ArrayList<Path>();
        private List<HStoreFile> storeFiles = new ArrayList<HStoreFile>();
        private CompactionDelPartitionId id;

        public CompactionDelPartition(CompactionDelPartitionId id) {
            this.id = id;
        }

        public CompactionDelPartitionId getId() {
            return this.id;
        }

        void addDelFile(FileStatus file) {
            this.delFiles.add(file.getPath());
        }

        public void addStoreFile(HStoreFile file) {
            this.storeFiles.add(file);
        }

        public List<HStoreFile> getStoreFiles() {
            return this.storeFiles;
        }

        List<Path> listDelFiles() {
            return Collections.unmodifiableList(this.delFiles);
        }

        void addDelFileList(Collection<Path> list) {
            this.delFiles.addAll(list);
        }

        int getDelFileCount() {
            return this.delFiles.size();
        }

        void cleanDelFiles() {
            this.delFiles.clear();
        }
    }

    public static class CompactionPartitionId {
        private String startKey;
        private String date;
        private String latestDate;
        private long threshold;

        public CompactionPartitionId() {
            this.startKey = "";
            this.date = "";
            this.latestDate = "";
            this.threshold = 0L;
        }

        public CompactionPartitionId(String startKey, String date) {
            if (startKey == null || date == null) {
                throw new IllegalArgumentException("Neither of start key and date could be null");
            }
            this.startKey = startKey;
            this.date = date;
            this.latestDate = "";
            this.threshold = 0L;
        }

        public void setThreshold(long threshold) {
            this.threshold = threshold;
        }

        public long getThreshold() {
            return this.threshold;
        }

        public String getStartKey() {
            return this.startKey;
        }

        public void setStartKey(String startKey) {
            this.startKey = startKey;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getLatestDate() {
            return this.latestDate;
        }

        public void updateLatestDate(String latestDate) {
            if (this.latestDate.compareTo(latestDate) < 0) {
                this.latestDate = latestDate;
            }
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.startKey.hashCode();
            result = 31 * result + this.date.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CompactionPartitionId)) {
                return false;
            }
            CompactionPartitionId another = (CompactionPartitionId)obj;
            if (!this.startKey.equals(another.startKey)) {
                return false;
            }
            return this.date.equals(another.date);
        }

        public String toString() {
            return this.startKey + this.date;
        }
    }

    protected static class CompactionPartition {
        private List<FileStatus> files = new ArrayList<FileStatus>();
        private CompactionPartitionId partitionId;
        private byte[] startKey;
        private byte[] endKey;

        public CompactionPartition(CompactionPartitionId partitionId) {
            this.partitionId = partitionId;
        }

        public CompactionPartitionId getPartitionId() {
            return this.partitionId;
        }

        public void addFile(FileStatus file) {
            this.files.add(file);
        }

        public List<FileStatus> listFiles() {
            return Collections.unmodifiableList(this.files);
        }

        public int getFileCount() {
            return this.files.size();
        }

        public byte[] getStartKey() {
            return this.startKey;
        }

        public void setStartKey(byte[] startKey) {
            if (this.startKey == null || Bytes.compareTo((byte[])startKey, (byte[])this.startKey) < 0) {
                this.startKey = startKey;
            }
        }

        public byte[] getEndKey() {
            return this.endKey;
        }

        public void setEndKey(byte[] endKey) {
            if (this.endKey == null || Bytes.compareTo((byte[])endKey, (byte[])this.endKey) > 0) {
                this.endKey = endKey;
            }
        }
    }
}

