/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.hbase.regionserver.FlushLargeStoresPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class FlushAllLargeStoresPolicy
extends FlushLargeStoresPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(FlushAllLargeStoresPolicy.class);

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        int familyNumber = region.getTableDescriptor().getColumnFamilyCount();
        if (familyNumber <= 1) {
            return;
        }
        this.setFlushSizeLowerBounds(region);
    }

    @Override
    public Collection<HStore> selectStoresToFlush() {
        if (this.region.getTableDescriptor().getColumnFamilyCount() == 1) {
            return this.region.stores.values();
        }
        Collection<HStore> stores = this.region.stores.values();
        HashSet<HStore> specificStoresToFlush = new HashSet<HStore>();
        for (HStore store : stores) {
            if (!this.shouldFlush(store)) continue;
            specificStoresToFlush.add(store);
        }
        if (!specificStoresToFlush.isEmpty()) {
            return specificStoresToFlush;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Since none of the CFs were above the size, flushing all.");
        }
        return stores;
    }

    @Override
    protected boolean shouldFlush(HStore store) {
        return super.shouldFlush(store) || this.region.shouldFlushStore(store);
    }
}

