/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.regionserver.RecoveredReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSourceFactory.class);

    static ReplicationSourceInterface create(Configuration conf, String queueId) {
        ReplicationSourceInterface src;
        ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(queueId);
        boolean isQueueRecovered = replicationQueueInfo.isQueueRecovered();
        try {
            String defaultReplicationSourceImpl = isQueueRecovered ? RecoveredReplicationSource.class.getCanonicalName() : ReplicationSource.class.getCanonicalName();
            Class<?> c = Class.forName(conf.get("replication.replicationsource.implementation", defaultReplicationSourceImpl));
            src = c.asSubclass(ReplicationSourceInterface.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Passed replication source implementation throws errors, defaulting to ReplicationSource", (Throwable)e);
            src = isQueueRecovered ? new RecoveredReplicationSource() : new ReplicationSource();
        }
        return src;
    }
}

