/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.jcraft.jsch.jcraft;

import java.security.MessageDigest;

class HMAC {
    private static final int B = 64;
    private byte[] k_ipad = null;
    private byte[] k_opad = null;
    private MessageDigest md = null;
    private int bsize = 0;
    private final byte[] tmp = new byte[4];

    HMAC() {
    }

    protected void setH(MessageDigest messageDigest) {
        this.md = messageDigest;
        this.bsize = messageDigest.getDigestLength();
    }

    public int getBlockSize() {
        return this.bsize;
    }

    public void init(byte[] byArray) throws Exception {
        if (byArray.length > this.bsize) {
            byte[] byArray2 = new byte[this.bsize];
            System.arraycopy(byArray, 0, byArray2, 0, this.bsize);
            byArray = byArray2;
        }
        if (byArray.length > 64) {
            this.md.update(byArray, 0, byArray.length);
            byArray = this.md.digest();
        }
        this.k_ipad = new byte[64];
        System.arraycopy(byArray, 0, this.k_ipad, 0, byArray.length);
        this.k_opad = new byte[64];
        System.arraycopy(byArray, 0, this.k_opad, 0, byArray.length);
        int n = 0;
        while (n < 64) {
            int n2 = n;
            this.k_ipad[n2] = (byte)(this.k_ipad[n2] ^ 0x36);
            int n3 = n++;
            this.k_opad[n3] = (byte)(this.k_opad[n3] ^ 0x5C);
        }
        this.md.update(this.k_ipad, 0, 64);
    }

    public void update(int n) {
        this.tmp[0] = (byte)(n >>> 24);
        this.tmp[1] = (byte)(n >>> 16);
        this.tmp[2] = (byte)(n >>> 8);
        this.tmp[3] = (byte)n;
        this.update(this.tmp, 0, 4);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }

    public void doFinal(byte[] byArray, int n) {
        byte[] byArray2 = this.md.digest();
        this.md.update(this.k_opad, 0, 64);
        this.md.update(byArray2, 0, this.bsize);
        try {
            this.md.digest(byArray, n, this.bsize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.md.update(this.k_ipad, 0, 64);
    }
}

