/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.inject.Singleton;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.RemoteExceptionData;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
@Singleton
@Provider
public class GenericExceptionHandler
implements ExceptionMapper<Exception> {
    public static final Log LOG = LogFactory.getLog(GenericExceptionHandler.class);
    @Context
    private HttpServletResponse response;

    public Response toResponse(Exception e) {
        Response.Status s;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"GOT EXCEPITION", (Throwable)e);
        }
        if (e instanceof com.sun.jersey.api.NotFoundException) {
            return ((com.sun.jersey.api.NotFoundException)e).getResponse();
        }
        this.response.setContentType(null);
        if (e instanceof RemoteException) {
            e = ((RemoteException)e).unwrapRemoteException();
        }
        if (e instanceof SecurityException) {
            s = Response.Status.UNAUTHORIZED;
        } else if (e instanceof AuthorizationException) {
            s = Response.Status.UNAUTHORIZED;
        } else if (e instanceof FileNotFoundException) {
            s = Response.Status.NOT_FOUND;
        } else if (e instanceof NotFoundException) {
            s = Response.Status.NOT_FOUND;
        } else if (e instanceof IOException) {
            s = Response.Status.NOT_FOUND;
        } else if (e instanceof UnsupportedOperationException) {
            s = Response.Status.BAD_REQUEST;
        } else if (e instanceof IllegalArgumentException) {
            s = Response.Status.BAD_REQUEST;
        } else if (e instanceof NumberFormatException) {
            s = Response.Status.BAD_REQUEST;
        } else if (e instanceof BadRequestException) {
            s = Response.Status.BAD_REQUEST;
        } else if (e instanceof WebApplicationException && e.getCause() instanceof UnmarshalException) {
            s = Response.Status.BAD_REQUEST;
        } else {
            LOG.warn((Object)"INTERNAL_SERVER_ERROR", (Throwable)e);
            s = Response.Status.INTERNAL_SERVER_ERROR;
        }
        RemoteExceptionData exception = new RemoteExceptionData(e.getClass().getSimpleName(), e.getMessage(), e.getClass().getName());
        return Response.status((Response.Status)s).entity((Object)exception).build();
    }
}

