/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewForwardOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDTFOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.ColumnPrunerProcCtx;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.ShapeDetails;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public final class ColumnPrunerProcFactory {
    protected static final Log LOG = LogFactory.getLog((String)ColumnPrunerProcFactory.class.getName());

    private ColumnPrunerProcFactory() {
    }

    public static ColumnPrunerFilterProc getFilterProc() {
        return new ColumnPrunerFilterProc();
    }

    public static ColumnPrunerGroupByProc getGroupByProc() {
        return new ColumnPrunerGroupByProc();
    }

    public static ColumnPrunerLimitProc getLimitProc() {
        return new ColumnPrunerLimitProc();
    }

    public static ColumnPrunerScriptProc getScriptProc() {
        return new ColumnPrunerScriptProc();
    }

    public static ColumnPrunerPTFProc getPTFProc() {
        return new ColumnPrunerPTFProc();
    }

    public static ColumnPrunerDefaultProc getDefaultProc() {
        return new ColumnPrunerDefaultProc();
    }

    public static void setupNeededColumns(TableScanOperator scanOp, RowSchema inputRS, List<String> cols) throws SemanticException {
        ArrayList<Integer> neededColumnIds = new ArrayList<Integer>();
        ArrayList<String> neededColumnNames = new ArrayList<String>();
        ArrayList<String> referencedColumnNames = new ArrayList<String>();
        TableScanDesc desc = (TableScanDesc)scanOp.getConf();
        List<VirtualColumn> virtualCols = desc.getVirtualCols();
        ArrayList<VirtualColumn> newVirtualCols = new ArrayList<VirtualColumn>();
        if (((TableScanDesc)scanOp.getConf()).isGatherStats()) {
            cols.add(VirtualColumn.RAWDATASIZE.getName());
        }
        for (String column : cols) {
            ColumnInfo colInfo = inputRS.getColumnInfo(column);
            if (colInfo == null) continue;
            referencedColumnNames.add(column);
            if (colInfo.getIsVirtualCol()) {
                for (int j = 0; j < virtualCols.size(); ++j) {
                    VirtualColumn vc = virtualCols.get(j);
                    if (!vc.getName().equals(colInfo.getInternalName())) continue;
                    newVirtualCols.add(vc);
                }
                continue;
            }
            int position = inputRS.getPosition(column);
            if (position < 0) continue;
            neededColumnIds.add(position);
            neededColumnNames.add(column);
        }
        desc.setVirtualCols(newVirtualCols);
        scanOp.setNeededColumnIDs(neededColumnIds);
        scanOp.setNeededColumns(neededColumnNames);
        scanOp.setReferencedColumns(referencedColumnNames);
    }

    public static ColumnPrunerTableScanProc getTableScanProc() {
        return new ColumnPrunerTableScanProc();
    }

    public static ColumnPrunerReduceSinkProc getReduceSinkProc() {
        return new ColumnPrunerReduceSinkProc();
    }

    private static boolean[] getPruneReduceSinkOpRetainFlags(List<String> retainedParentOpOutputCols, ReduceSinkOperator reduce) {
        ReduceSinkDesc reduceConf = (ReduceSinkDesc)reduce.getConf();
        ArrayList<ExprNodeDesc> originalValueEval = reduceConf.getValueCols();
        boolean[] flags = new boolean[originalValueEval.size()];
        block0: for (int i = 0; i < originalValueEval.size(); ++i) {
            flags[i] = false;
            List<String> current = originalValueEval.get(i).getCols();
            if (current == null || current.size() == 0) {
                flags[i] = true;
                continue;
            }
            for (int j = 0; j < current.size(); ++j) {
                if (!retainedParentOpOutputCols.contains(current.get(j))) continue;
                flags[i] = true;
                continue block0;
            }
        }
        return flags;
    }

    private static void pruneReduceSinkOperator(boolean[] retainFlags, ReduceSinkOperator reduce, ColumnPrunerProcCtx cppCtx) throws SemanticException {
        ReduceSinkDesc reduceConf = (ReduceSinkDesc)reduce.getConf();
        Map<String, ExprNodeDesc> oldMap = reduce.getColumnExprMap();
        LOG.info((Object)("RS " + reduce.getIdentifier() + " oldColExprMap: " + oldMap));
        RowSchema oldRS = reduce.getSchema();
        ArrayList<ColumnInfo> old_signature = oldRS.getSignature();
        ArrayList<ColumnInfo> signature = new ArrayList<ColumnInfo>(old_signature);
        ArrayList<String> valueColNames = reduceConf.getOutputValueColumnNames();
        ArrayList<String> newValueColNames = new ArrayList<String>();
        ArrayList<ExprNodeDesc> keyExprs = reduceConf.getKeyCols();
        ArrayList<ExprNodeDesc> valueExprs = reduceConf.getValueCols();
        ArrayList<ExprNodeDesc> newValueExprs = new ArrayList<ExprNodeDesc>();
        for (int i = 0; i < retainFlags.length; ++i) {
            String outputCol = (String)valueColNames.get(i);
            ExprNodeDesc outputColExpr = (ExprNodeDesc)valueExprs.get(i);
            if (!retainFlags[i]) {
                ColumnInfo colInfo = oldRS.getColumnInfo(outputCol);
                if (colInfo == null) {
                    outputCol = Utilities.ReduceField.VALUE.toString() + "." + outputCol;
                    colInfo = oldRS.getColumnInfo(outputCol);
                }
                if (colInfo == null || ExprNodeDescUtils.indexOf(outputColExpr, keyExprs) != -1) continue;
                oldMap.remove(outputCol);
                signature.remove(colInfo);
                continue;
            }
            newValueColNames.add(outputCol);
            newValueExprs.add(outputColExpr);
        }
        oldRS.setSignature(signature);
        reduce.getSchema().setSignature(signature);
        reduceConf.setOutputValueColumnNames(newValueColNames);
        reduceConf.setValueCols(newValueExprs);
        TableDesc newValueTable = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(reduceConf.getValueCols(), newValueColNames, 0, ""));
        reduceConf.setValueSerializeInfo(newValueTable);
        LOG.info((Object)("RS " + reduce.getIdentifier() + " newColExprMap: " + oldMap));
    }

    public static ColumnPrunerSelectProc getSelectProc() {
        return new ColumnPrunerSelectProc();
    }

    public static ColumnPrunerLateralViewJoinProc getLateralViewJoinProc() {
        return new ColumnPrunerLateralViewJoinProc();
    }

    public static ColumnPrunerLateralViewForwardProc getLateralViewForwardProc() {
        return new ColumnPrunerLateralViewForwardProc();
    }

    public static ColumnPrunerJoinProc getJoinProc() {
        return new ColumnPrunerJoinProc();
    }

    private static void pruneOperator(NodeProcessorCtx ctx, Operator<? extends OperatorDesc> op, List<String> cols) throws SemanticException {
        RowSchema inputSchema = op.getSchema();
        if (inputSchema != null) {
            ArrayList<ColumnInfo> rs = new ArrayList<ColumnInfo>();
            RowSchema oldRS = op.getSchema();
            for (ColumnInfo i : oldRS.getSignature()) {
                if (!cols.contains(i.getInternalName())) continue;
                rs.add(i);
            }
            op.getSchema().setSignature(rs);
        }
    }

    private static List<String> preserveColumnOrder(Operator<? extends OperatorDesc> op, List<String> cols) throws SemanticException {
        RowSchema inputSchema = op.getSchema();
        if (inputSchema != null) {
            ArrayList<String> rs = new ArrayList<String>();
            ArrayList<ColumnInfo> inputCols = inputSchema.getSignature();
            for (ColumnInfo i : inputCols) {
                if (!cols.contains(i.getInternalName())) continue;
                rs.add(i.getInternalName());
            }
            return rs;
        }
        return cols;
    }

    private static void pruneJoinOperator(NodeProcessorCtx ctx, CommonJoinOperator op, JoinDesc conf, Map<String, ExprNodeDesc> columnExprMap, Map<Byte, List<Integer>> retainMap, boolean mapJoin) throws SemanticException {
        String internalName;
        ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
        List<Operator<OperatorDesc>> childOperators = op.getChildOperators();
        LOG.info((Object)("JOIN " + op.getIdentifier() + " oldExprs: " + conf.getExprs()));
        List<String> childColLists = cppCtx.genColLists(op);
        if (childColLists == null) {
            return;
        }
        HashMap<Byte, List<Object>> prunedColLists = new HashMap<Byte, List<Object>>();
        Byte[] arr$ = conf.getTagOrder();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte tag = arr$[i$];
            prunedColLists.put(tag, new ArrayList());
        }
        Set<Map.Entry<Byte, List<ExprNodeDesc>>> filters = conf.getFilters().entrySet();
        for (Map.Entry<Byte, List<ExprNodeDesc>> entry : filters) {
            Byte tag = entry.getKey();
            for (ExprNodeDesc desc : entry.getValue()) {
                List<String> cols = (List<String>)prunedColLists.get(tag);
                cols = Utilities.mergeUniqElems(cols, desc.getCols());
                prunedColLists.put(tag, cols);
            }
        }
        RowSchema joinRS = op.getSchema();
        ArrayList<String> outputCols = new ArrayList<String>();
        ArrayList<ColumnInfo> rs = new ArrayList<ColumnInfo>();
        HashMap<String, ExprNodeDesc> newColExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < conf.getOutputColumnNames().size(); ++i) {
            internalName = conf.getOutputColumnNames().get(i);
            ExprNodeDesc desc = columnExprMap.get(internalName);
            Byte tag = conf.getReversedExprs().get(internalName);
            if (!childColLists.contains(internalName)) {
                int index = conf.getExprs().get(tag).indexOf(desc);
                if (index < 0) continue;
                conf.getExprs().get(tag).remove(desc);
                if (retainMap == null) continue;
                retainMap.get(tag).remove(index);
                continue;
            }
            List<String> prunedRSList = (ArrayList<String>)prunedColLists.get(tag);
            if (prunedRSList == null) {
                prunedRSList = new ArrayList<String>();
                prunedColLists.put(tag, prunedRSList);
            }
            prunedRSList = Utilities.mergeUniqElems(prunedRSList, desc.getCols());
            outputCols.add(internalName);
            newColExprMap.put(internalName, desc);
        }
        if (mapJoin) {
            ArrayList<TableDesc> valueTableDescs = new ArrayList<TableDesc>();
            for (int pos = 0; pos < op.getParentOperators().size(); ++pos) {
                List<ExprNodeDesc> valueCols = conf.getExprs().get((byte)pos);
                StringBuilder keyOrder = new StringBuilder();
                for (int i = 0; i < valueCols.size(); ++i) {
                    keyOrder.append("+");
                }
                TableDesc valueTableDesc = PlanUtils.getMapJoinValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueCols, "mapjoinvalue"));
                valueTableDescs.add(valueTableDesc);
            }
            ((MapJoinDesc)conf).setValueTblDescs(valueTableDescs);
            Set<Map.Entry<Byte, List<ExprNodeDesc>>> exprs = ((MapJoinDesc)conf).getKeys().entrySet();
            for (Map.Entry<Byte, List<ExprNodeDesc>> entry : exprs) {
                List<ExprNodeDesc> lists = entry.getValue();
                for (int j = 0; j < lists.size(); ++j) {
                    ExprNodeDesc desc = lists.get(j);
                    Byte tag = entry.getKey();
                    List<String> cols = (List<String>)prunedColLists.get(tag);
                    cols = Utilities.mergeUniqElems(cols, desc.getCols());
                    prunedColLists.put(tag, cols);
                }
            }
        }
        for (Operator<OperatorDesc> child : childOperators) {
            if (!(child instanceof ReduceSinkOperator)) continue;
            boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(childColLists, (ReduceSinkOperator)child);
            ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)child, cppCtx);
        }
        for (int i = 0; i < outputCols.size(); ++i) {
            internalName = (String)outputCols.get(i);
            ColumnInfo col = joinRS.getColumnInfo(internalName);
            rs.add(col);
        }
        LOG.info((Object)("JOIN " + op.getIdentifier() + " newExprs: " + conf.getExprs()));
        op.setColumnExprMap(newColExprMap);
        conf.setOutputColumnNames(outputCols);
        op.getSchema().setSignature(rs);
        cppCtx.getJoinPrunedColLists().put(op, prunedColLists);
    }

    public static ColumnPrunerMapJoinProc getMapJoinProc() {
        return new ColumnPrunerMapJoinProc();
    }

    public static class ColumnPrunerMapJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            AbstractMapJoinOperator op = (AbstractMapJoinOperator)nd;
            ColumnPrunerProcFactory.pruneJoinOperator(ctx, op, (JoinDesc)op.getConf(), op.getColumnExprMap(), ((MapJoinDesc)op.getConf()).getRetainList(), true);
            return null;
        }
    }

    public static class ColumnPrunerJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator op = (JoinOperator)nd;
            ColumnPrunerProcFactory.pruneJoinOperator(ctx, op, (JoinDesc)op.getConf(), op.getColumnExprMap(), null, false);
            return null;
        }
    }

    public static class ColumnPrunerSelectProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator op = (SelectOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            if (op.getChildOperators() != null) {
                for (Operator<OperatorDesc> child : op.getChildOperators()) {
                    if (!(child instanceof UDTFOperator)) continue;
                    cppCtx.getPrunedColLists().put(op, cppCtx.getColsFromSelectExpr(op));
                    return null;
                }
            }
            LateralViewJoinOperator lvJoin = null;
            if (((SelectDesc)op.getConf()).isSelStarNoCompute()) {
                Operator<OperatorDesc> child;
                assert (op.getNumChild() == 1);
                child = op.getChildOperators().get(0);
                if (child instanceof LateralViewJoinOperator) {
                    lvJoin = (LateralViewJoinOperator)child;
                }
            }
            List<String> cols = cppCtx.genColLists(op);
            SelectDesc conf = (SelectDesc)op.getConf();
            if (lvJoin != null) {
                if (cols != null) {
                    RowSchema rs = op.getSchema();
                    cppCtx.getPrunedColLists().put(op, cppCtx.getSelectColsFromLVJoin(rs, cols));
                }
                return null;
            }
            cppCtx.getPrunedColLists().put(op, cppCtx.getSelectColsFromChildren(op, cols));
            if (cols == null || conf.isSelStarNoCompute()) {
                return null;
            }
            List<ExprNodeDesc> originalColList = ((SelectDesc)op.getConf()).getColList();
            List<String> originalOutputColumnNames = conf.getOutputColumnNames();
            if (cols.size() < originalOutputColumnNames.size()) {
                ArrayList<ExprNodeDesc> newColList = new ArrayList<ExprNodeDesc>();
                ArrayList<String> newOutputColumnNames = new ArrayList<String>();
                ArrayList<ColumnInfo> rs_oldsignature = op.getSchema().getSignature();
                ArrayList<ColumnInfo> rs_newsignature = new ArrayList<ColumnInfo>();
                for (String col : cols) {
                    int index = originalOutputColumnNames.indexOf(col);
                    newOutputColumnNames.add(col);
                    newColList.add(originalColList.get(index));
                    rs_newsignature.add(rs_oldsignature.get(index));
                }
                op.getSchema().setSignature(rs_newsignature);
                conf.setColList(newColList);
                conf.setOutputColumnNames(newOutputColumnNames);
                this.handleChildren(op, cols, cppCtx);
            }
            return null;
        }

        private void handleChildren(SelectOperator op, List<String> retainedSelOutputCols, ColumnPrunerProcCtx cppCtx) throws SemanticException {
            for (Operator<OperatorDesc> child : op.getChildOperators()) {
                if (child instanceof ReduceSinkOperator) {
                    boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(retainedSelOutputCols, (ReduceSinkOperator)child);
                    ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)child, cppCtx);
                    continue;
                }
                if (!(child instanceof FilterOperator)) continue;
                for (Operator<OperatorDesc> filterChild : child.getChildOperators()) {
                    if (!(filterChild instanceof ReduceSinkOperator)) continue;
                    boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(retainedSelOutputCols, (ReduceSinkOperator)filterChild);
                    ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)filterChild, cppCtx);
                }
            }
        }
    }

    public static class ColumnPrunerLateralViewForwardProc
    extends ColumnPrunerDefaultProc {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            super.process(nd, stack, ctx, nodeOutputs);
            LateralViewForwardOperator op = (LateralViewForwardOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            Operator<OperatorDesc> select = op.getChildOperators().get(0);
            List<String> cols = cppCtx.getPrunedColList(select);
            RowSchema rs = op.getSchema();
            ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
            ArrayList<String> outputColNames = new ArrayList<String>();
            for (String col : cols) {
                ColumnInfo colInfo = rs.getColumnInfo(col);
                ExprNodeColumnDesc colExpr = new ExprNodeColumnDesc(colInfo);
                colList.add(colExpr);
                outputColNames.add(col);
            }
            ((SelectDesc)select.getConf()).setSelStarNoCompute(false);
            ((SelectDesc)select.getConf()).setColList(colList);
            ((SelectDesc)select.getConf()).setOutputColumnNames(outputColNames);
            ColumnPrunerProcFactory.pruneOperator(ctx, select, outputColNames);
            Operator<OperatorDesc> udtfPath = op.getChildOperators().get(1);
            List<String> lvFCols = new ArrayList<String>((Collection)cppCtx.getPrunedColLists().get(udtfPath));
            lvFCols = Utilities.mergeUniqElems(lvFCols, outputColNames);
            ColumnPrunerProcFactory.pruneOperator(ctx, op, lvFCols);
            return null;
        }
    }

    public static class ColumnPrunerLateralViewJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            LateralViewJoinOperator op = (LateralViewJoinOperator)nd;
            List<String> cols = cppCtx.genColLists(op);
            if (cols == null) {
                return null;
            }
            Map<String, ExprNodeDesc> colExprMap = op.getColumnExprMap();
            ArrayList<String> outputCols = ((LateralViewJoinDesc)op.getConf()).getOutputInternalColNames();
            int numSelColumns = ((LateralViewJoinDesc)op.getConf()).getNumSelColumns();
            ArrayList<String> colsAfterReplacement = new ArrayList<String>();
            ArrayList<String> newColNames = new ArrayList<String>();
            for (String col : cols) {
                int index = outputCols.indexOf(col);
                if (index < 0 || index >= numSelColumns) continue;
                ExprNodeDesc transformed = colExprMap.get(col);
                Utilities.mergeUniqElems(colsAfterReplacement, transformed.getCols());
                newColNames.add(col);
            }
            ((LateralViewJoinDesc)op.getConf()).setNumSelColumns(newColNames.size());
            newColNames.addAll(outputCols.subList(numSelColumns, outputCols.size()));
            ((LateralViewJoinDesc)op.getConf()).setOutputInternalColNames(newColNames);
            ColumnPrunerProcFactory.pruneOperator(ctx, op, newColNames);
            cppCtx.getPrunedColLists().put(op, colsAfterReplacement);
            return null;
        }
    }

    public static class ColumnPrunerReduceSinkProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator op = (ReduceSinkOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            ReduceSinkDesc conf = (ReduceSinkDesc)op.getConf();
            List<String> colLists = new ArrayList<String>();
            ArrayList<ExprNodeDesc> keys = conf.getKeyCols();
            LOG.debug((Object)("Reduce Sink Operator " + op.getIdentifier() + " key:" + keys));
            for (ExprNodeDesc key : keys) {
                colLists = Utilities.mergeUniqElems(colLists, key.getCols());
            }
            for (ExprNodeDesc key : conf.getPartitionCols()) {
                colLists = Utilities.mergeUniqElems(colLists, key.getCols());
            }
            assert (op.getNumChild() == 1);
            Operator<OperatorDesc> child = op.getChildOperators().get(0);
            List<String> childCols = null;
            childCols = child instanceof CommonJoinOperator ? (cppCtx.getJoinPrunedColLists().get(child) == null ? null : cppCtx.getJoinPrunedColLists().get(child).get((byte)conf.getTag())) : cppCtx.getPrunedColList(child);
            ArrayList<ExprNodeDesc> valCols = conf.getValueCols();
            ArrayList<String> valColNames = conf.getOutputValueColumnNames();
            if (childCols != null) {
                boolean[] flags = new boolean[valCols.size()];
                for (String childCol : childCols) {
                    int index = valColNames.indexOf(Utilities.removeValueTag(childCol));
                    if (index < 0) continue;
                    flags[index] = true;
                    colLists = Utilities.mergeUniqElems(colLists, ((ExprNodeDesc)valCols.get(index)).getCols());
                }
                Collections.sort(colLists);
                ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, op, cppCtx);
                cppCtx.getPrunedColLists().put(op, colLists);
                return null;
            }
            for (ExprNodeDesc val : valCols) {
                colLists = Utilities.mergeUniqElems(colLists, val.getCols());
            }
            cppCtx.getPrunedColLists().put(op, colLists);
            return null;
        }
    }

    public static class ColumnPrunerTableScanProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator scanOp = (TableScanOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            ArrayList<String> cols = cppCtx.genColLists((Operator)nd);
            if (cols == null && !((TableScanDesc)scanOp.getConf()).isGatherStats()) {
                scanOp.setNeededColumnIDs(null);
                return null;
            }
            cols = cols == null ? new ArrayList<String>() : cols;
            cppCtx.getPrunedColLists().put((Operator)nd, cols);
            RowSchema inputRS = scanOp.getSchema();
            ColumnPrunerProcFactory.setupNeededColumns(scanOp, inputRS, cols);
            return null;
        }
    }

    public static class ColumnPrunerDefaultProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            cppCtx.getPrunedColLists().put((Operator)nd, cppCtx.genColLists((Operator)nd));
            return null;
        }
    }

    public static class ColumnPrunerPTFProc
    extends ColumnPrunerScriptProc {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            PTFOperator op = (PTFOperator)nd;
            PTFDesc conf = (PTFDesc)op.getConf();
            PartitionedTableFunctionDef funcDef = conf.getFuncDef();
            List<String> referencedColumns = funcDef.getReferencedColumns();
            if (!conf.forWindowing() && !conf.forNoop() && referencedColumns == null) {
                return super.process(nd, stack, cppCtx, nodeOutputs);
            }
            List<String> prunedCols = cppCtx.getPrunedColList(op.getChildOperators().get(0));
            if (conf.forWindowing()) {
                WindowTableFunctionDef def = (WindowTableFunctionDef)funcDef;
                prunedCols = Utilities.mergeUniqElems(this.getWindowFunctionColumns(def), prunedCols);
            } else {
                prunedCols = conf.forNoop() ? new ArrayList<String>(cppCtx.getPrunedColList(op.getChildOperators().get(0))) : referencedColumns;
            }
            List<ColumnInfo> newRS = this.prunedColumnsList(prunedCols, op.getSchema(), funcDef);
            op.getSchema().setSignature(new ArrayList<ColumnInfo>(newRS));
            ShapeDetails outputShape = funcDef.getStartOfChain().getInput().getOutputShape();
            cppCtx.getPrunedColLists().put(op, outputShape.getColumnNames());
            return null;
        }

        private List<ColumnInfo> buildPrunedRS(List<String> prunedCols, RowSchema oldRS) throws SemanticException {
            ArrayList<ColumnInfo> sig = new ArrayList<ColumnInfo>();
            HashSet<String> prunedColsSet = new HashSet<String>(prunedCols);
            for (ColumnInfo cInfo : oldRS.getSignature()) {
                if (!prunedColsSet.contains(cInfo.getInternalName())) continue;
                sig.add(cInfo);
            }
            return sig;
        }

        private List<String> getWindowFunctionColumns(WindowTableFunctionDef tDef) {
            ArrayList<String> columns = new ArrayList<String>();
            if (tDef.getWindowFunctions() != null) {
                for (WindowFunctionDef wDef : tDef.getWindowFunctions()) {
                    columns.add(wDef.getAlias());
                }
            }
            return columns;
        }

        private RowResolver buildPrunedRR(List<String> prunedCols, RowSchema oldRS) throws SemanticException {
            RowResolver resolver = new RowResolver();
            HashSet<String> prunedColsSet = new HashSet<String>(prunedCols);
            for (ColumnInfo cInfo : oldRS.getSignature()) {
                if (!prunedColsSet.contains(cInfo.getInternalName())) continue;
                resolver.put(cInfo.getTabAlias(), cInfo.getAlias(), cInfo);
            }
            return resolver;
        }

        private List<ColumnInfo> prunedColumnsList(List<String> prunedCols, RowSchema oldRS, PartitionedTableFunctionDef pDef) throws SemanticException {
            pDef.getOutputShape().setRr(null);
            pDef.getOutputShape().setColumnNames(null);
            if (pDef instanceof WindowTableFunctionDef) {
                ExprNodeDesc exprNode;
                WindowTableFunctionDef tDef = (WindowTableFunctionDef)pDef;
                if (tDef.getWindowFunctions() != null) {
                    for (WindowFunctionDef windowFunctionDef : tDef.getWindowFunctions()) {
                        if (windowFunctionDef.getArgs() == null) continue;
                        for (PTFExpressionDef arg : windowFunctionDef.getArgs()) {
                            ExprNodeDesc exprNode2 = arg.getExprNode();
                            Utilities.mergeUniqElems(prunedCols, exprNode2.getCols());
                        }
                    }
                }
                if (tDef.getPartition() != null) {
                    for (PTFExpressionDef pTFExpressionDef : tDef.getPartition().getExpressions()) {
                        exprNode = pTFExpressionDef.getExprNode();
                        Utilities.mergeUniqElems(prunedCols, exprNode.getCols());
                    }
                }
                if (tDef.getOrder() != null) {
                    for (PTFExpressionDef pTFExpressionDef : tDef.getOrder().getExpressions()) {
                        exprNode = pTFExpressionDef.getExprNode();
                        Utilities.mergeUniqElems(prunedCols, exprNode.getCols());
                    }
                }
            } else {
                pDef.getOutputShape().setRr(this.buildPrunedRR(prunedCols, oldRS));
            }
            PTFInputDef input = pDef.getInput();
            if (input instanceof PartitionedTableFunctionDef) {
                return this.prunedColumnsList(prunedCols, oldRS, (PartitionedTableFunctionDef)input);
            }
            ArrayList<String> inputColumns = this.prunedInputList(prunedCols, input);
            input.getOutputShape().setRr(this.buildPrunedRR(inputColumns, oldRS));
            input.getOutputShape().setColumnNames(inputColumns);
            return this.buildPrunedRS(prunedCols, oldRS);
        }

        private ArrayList<String> prunedInputList(List<String> prunedCols, PTFInputDef tDef) {
            ArrayList<String> prunedInputCols = new ArrayList<String>();
            StructObjectInspector OI = tDef.getOutputShape().getOI();
            for (StructField structField : OI.getAllStructFieldRefs()) {
                String fName = structField.getFieldName();
                if (!prunedCols.contains(fName)) continue;
                prunedInputCols.add(fName);
            }
            return prunedInputCols;
        }
    }

    public static class ColumnPrunerLimitProc
    extends ColumnPrunerDefaultProc {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            super.process(nd, stack, ctx, nodeOutputs);
            List<String> cols = ((ColumnPrunerProcCtx)ctx).getPrunedColLists().get(nd);
            if (null != cols) {
                ColumnPrunerProcFactory.pruneOperator(ctx, (LimitOperator)nd, cols);
            }
            return null;
        }
    }

    public static class ColumnPrunerScriptProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            Operator op = (Operator)nd;
            RowSchema inputRS = op.getSchema();
            List<String> prunedCols = cppCtx.getPrunedColList(op.getChildOperators().get(0));
            Operator<OperatorDesc> parent = op.getParentOperators().get(0);
            RowSchema parentRS = parent.getSchema();
            ArrayList<ColumnInfo> sig = parentRS.getSignature();
            ArrayList<String> colList = new ArrayList<String>();
            for (ColumnInfo cI : sig) {
                colList.add(cI.getInternalName());
            }
            if (prunedCols.size() != inputRS.getSignature().size() && !(op.getChildOperators().get(0) instanceof SelectOperator)) {
                ArrayList<ExprNodeDesc> exprs = new ArrayList<ExprNodeDesc>();
                ArrayList<String> outputs = new ArrayList<String>();
                HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
                ArrayList<ColumnInfo> outputRS = new ArrayList<ColumnInfo>();
                for (String internalName : prunedCols) {
                    ColumnInfo valueInfo = inputRS.getColumnInfo(internalName);
                    ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), valueInfo.getTabAlias(), valueInfo.getIsVirtualCol());
                    exprs.add(colDesc);
                    outputs.add(internalName);
                    ColumnInfo newCol = new ColumnInfo(internalName, valueInfo.getType(), valueInfo.getTabAlias(), valueInfo.getIsVirtualCol(), valueInfo.isHiddenVirtualCol());
                    newCol.setAlias(valueInfo.getAlias());
                    outputRS.add(newCol);
                    colExprMap.put(internalName, colDesc);
                }
                SelectDesc select = new SelectDesc(exprs, outputs, false);
                Operator<OperatorDesc> child = op.getChildOperators().get(0);
                op.removeChild(child);
                SelectOperator sel = (SelectOperator)OperatorFactory.getAndMakeChild(select, new RowSchema(outputRS), op);
                OperatorFactory.makeChild(sel, child);
                sel.setColumnExprMap(colExprMap);
            }
            cppCtx.getPrunedColLists().put(op, colList);
            return null;
        }
    }

    public static class ColumnPrunerGroupByProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            String groupingColumn;
            List<String> cols;
            GroupByOperator op = (GroupByOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            List<String> colLists = new ArrayList<String>();
            GroupByDesc conf = (GroupByDesc)op.getConf();
            ArrayList<ExprNodeDesc> keys = conf.getKeys();
            for (ExprNodeDesc key : keys) {
                colLists = Utilities.mergeUniqElems(colLists, key.getCols());
            }
            ArrayList<AggregationDesc> aggrs = conf.getAggregators();
            for (AggregationDesc aggr : aggrs) {
                ArrayList<ExprNodeDesc> params = aggr.getParameters();
                for (ExprNodeDesc param : params) {
                    colLists = Utilities.mergeUniqElems(colLists, param.getCols());
                }
            }
            int groupingSetPosition = conf.getGroupingSetPosition();
            if (groupingSetPosition >= 0 && !(cols = cppCtx.genColLists(op)).contains(groupingColumn = conf.getOutputColumnNames().get(groupingSetPosition))) {
                conf.getOutputColumnNames().remove(groupingSetPosition);
                if (op.getSchema() != null) {
                    op.getSchema().getSignature().remove(groupingSetPosition);
                }
            }
            cppCtx.getPrunedColLists().put(op, colLists);
            return null;
        }
    }

    public static class ColumnPrunerFilterProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator op = (FilterOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            ExprNodeDesc condn = ((FilterDesc)op.getConf()).getPredicate();
            List<String> cl = condn.getCols();
            List<String> filterOpPrunedColLists = Utilities.mergeUniqElems(cppCtx.genColLists(op), cl);
            List filterOpPrunedColListsOrderPreserved = ColumnPrunerProcFactory.preserveColumnOrder(op, filterOpPrunedColLists);
            cppCtx.getPrunedColLists().put(op, filterOpPrunedColListsOrderPreserved);
            ColumnPrunerProcFactory.pruneOperator(cppCtx, op, cppCtx.getPrunedColLists().get(op));
            return null;
        }
    }
}

