/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.io.DataOutputBuffer;

@Explain(displayName="Dynamic Partitioning Event Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DynamicPruningEventDesc
extends AppMasterEventDesc {
    private String targetColumnName;
    private transient TableScanOperator tableScan;
    private ExprNodeDesc partKey;

    public TableScanOperator getTableScan() {
        return this.tableScan;
    }

    public void setTableScan(TableScanOperator tableScan) {
        this.tableScan = tableScan;
    }

    @Explain(displayName="Target column")
    public String getTargetColumnName() {
        return this.targetColumnName;
    }

    public void setTargetColumnName(String columnName) {
        this.targetColumnName = columnName;
    }

    @Override
    public void writeEventHeader(DataOutputBuffer buffer) throws IOException {
        super.writeEventHeader(buffer);
        buffer.writeUTF(this.targetColumnName);
    }

    public void setPartKey(ExprNodeDesc partKey) {
        this.partKey = partKey;
    }

    @Explain(displayName="Partition key expr")
    public String getPartKeyString() {
        return this.partKey.getExprString();
    }

    public ExprNodeDesc getPartKey() {
        return this.partKey;
    }
}

