/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorDoubleMax
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorDoubleMax.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected boolean isGroupResultNull;
    protected double max;

    public VectorPTFEvaluatorDoubleMax(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DoubleColumnVector doubleColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum];
        if (doubleColVector.isRepeating) {
            if (doubleColVector.noNulls || !doubleColVector.isNull[0]) {
                if (this.isGroupResultNull) {
                    this.max = doubleColVector.vector[0];
                    this.isGroupResultNull = false;
                } else {
                    double repeatedMax = doubleColVector.vector[0];
                    if (repeatedMax < this.max) {
                        this.max = repeatedMax;
                    }
                }
            }
        } else if (doubleColVector.noNulls) {
            double[] vector = doubleColVector.vector;
            double varMax = vector[0];
            for (int i = 1; i < size; ++i) {
                double d = vector[i];
                if (!(d > varMax)) continue;
                varMax = d;
            }
            if (this.isGroupResultNull) {
                this.max = varMax;
                this.isGroupResultNull = false;
            } else if (varMax > this.max) {
                this.max = varMax;
            }
        } else {
            boolean[] batchIsNull = doubleColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (++i < size) continue;
                return;
            }
            double[] vector = doubleColVector.vector;
            double varMax = vector[i++];
            while (i < size) {
                double d;
                if (!batchIsNull[i] && (d = vector[i]) > varMax) {
                    varMax = d;
                }
                ++i;
            }
            if (this.isGroupResultNull) {
                this.max = varMax;
                this.isGroupResultNull = false;
            } else if (varMax > this.max) {
                this.max = varMax;
            }
        }
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public double getDoubleGroupResult() {
        return this.max;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.max = Double.MIN_VALUE;
    }
}

