/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.Ordering;
import java.util.List;
import org.apache.calcite.plan.RelMultipleTrait;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.util.mapping.Mappings;

public class HiveRelDistribution
implements RelDistribution {
    private static final Ordering<Iterable<Integer>> ORDERING = Ordering.natural().lexicographical();
    List<Integer> keys;
    RelDistribution.Type type;

    public HiveRelDistribution(RelDistribution.Type type, List<Integer> keys) {
        this.type = type;
        this.keys = keys;
    }

    public RelTraitDef<?> getTraitDef() {
        return RelDistributionTraitDef.INSTANCE;
    }

    public void register(RelOptPlanner planner) {
    }

    public boolean satisfies(RelTrait trait) {
        if (trait == this) {
            return true;
        }
        switch (((RelDistribution)trait).getType()) {
            case HASH_DISTRIBUTED: {
                return this.getKeys().equals(((RelDistribution)trait).getKeys());
            }
        }
        throw new RuntimeException("Other distributions are not used yet.");
    }

    public RelDistribution apply(Mappings.TargetMapping mapping) {
        if (this.keys.isEmpty()) {
            return this;
        }
        return new HiveRelDistribution(this.type, this.keys);
    }

    public List<Integer> getKeys() {
        return this.keys;
    }

    public RelDistribution.Type getType() {
        return this.type;
    }

    public boolean isTop() {
        return this.type == RelDistribution.Type.ANY;
    }

    public int compareTo(RelMultipleTrait o) {
        RelDistribution distribution = (RelDistribution)o;
        if (this.type == distribution.getType() && (this.type == RelDistribution.Type.HASH_DISTRIBUTED || this.type == RelDistribution.Type.RANGE_DISTRIBUTED)) {
            return ORDERING.compare(this.getKeys(), distribution.getKeys());
        }
        return this.type.compareTo((Enum)distribution.getType());
    }
}

