/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Database", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateDatabaseDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String databaseName;
    String locationUri;
    String comment;
    boolean ifNotExists;
    Map<String, String> dbProperties;

    public CreateDatabaseDesc() {
    }

    public CreateDatabaseDesc(String databaseName, String comment, String locationUri, boolean ifNotExists) {
        this.databaseName = databaseName;
        this.comment = comment;
        this.locationUri = locationUri;
        this.ifNotExists = ifNotExists;
        this.dbProperties = null;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public Map<String, String> getDatabaseProperties() {
        return this.dbProperties;
    }

    public void setDatabaseProperties(Map<String, String> dbProps) {
        this.dbProperties = dbProps;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getName() {
        return this.databaseName;
    }

    public void setName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Explain(displayName="locationUri")
    public String getLocationUri() {
        return this.locationUri;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }
}

