/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFParamUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

public abstract class GenericUDFAesBase
extends GenericUDF {
    protected transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[2];
    protected transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    protected final BytesWritable output = new BytesWritable();
    protected transient boolean isStr0;
    protected transient boolean isStr1;
    protected transient boolean isKeyConstant;
    protected transient Cipher cipher;
    protected transient SecretKey secretKey;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 2);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        if (this.canParam0BeStr()) {
            this.checkArgGroups(arguments, 0, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.BINARY_GROUP);
        } else {
            this.checkArgGroups(arguments, 0, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.BINARY_GROUP);
        }
        this.checkArgGroups(arguments, 1, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.BINARY_GROUP);
        this.isStr0 = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(this.inputTypes[0]) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP;
        if (this.isStr0) {
            this.obtainStringConverter(arguments, 0, this.inputTypes, this.converters);
        } else {
            GenericUDFParamUtils.obtainBinaryConverter(arguments, 0, this.inputTypes, this.converters);
        }
        this.isKeyConstant = arguments[1] instanceof ConstantObjectInspector;
        byte[] key = null;
        int keyLength = 0;
        this.isStr1 = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(this.inputTypes[1]) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP;
        if (this.isStr1) {
            if (this.isKeyConstant) {
                String keyStr = this.getConstantStringValue(arguments, 1);
                if (keyStr != null) {
                    key = keyStr.getBytes();
                    keyLength = key.length;
                }
            } else {
                this.obtainStringConverter(arguments, 1, this.inputTypes, this.converters);
            }
        } else if (this.isKeyConstant) {
            BytesWritable keyWr = GenericUDFParamUtils.getConstantBytesValue(arguments, 1);
            if (keyWr != null) {
                key = keyWr.getBytes();
                keyLength = keyWr.getLength();
            }
        } else {
            GenericUDFParamUtils.obtainBinaryConverter(arguments, 1, this.inputTypes, this.converters);
        }
        if (key != null) {
            this.secretKey = this.getSecretKey(key, keyLength);
        }
        try {
            this.cipher = Cipher.getInstance("AES");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        WritableBinaryObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        SecretKey secretKey;
        int inputLength;
        byte[] input;
        if (this.isStr0) {
            Text n = GenericUDFParamUtils.getTextValue(arguments, 0, this.converters);
            if (n == null) {
                return null;
            }
            input = n.getBytes();
            inputLength = n.getLength();
        } else {
            BytesWritable bWr = GenericUDFParamUtils.getBinaryValue(arguments, 0, this.converters);
            if (bWr == null) {
                return null;
            }
            input = bWr.getBytes();
            inputLength = bWr.getLength();
        }
        if (input == null) {
            return null;
        }
        if (this.isKeyConstant) {
            secretKey = this.secretKey;
        } else {
            int keyLength;
            byte[] key;
            if (this.isStr1) {
                Text n = GenericUDFParamUtils.getTextValue(arguments, 1, this.converters);
                if (n == null) {
                    return null;
                }
                key = n.getBytes();
                keyLength = n.getLength();
            } else {
                BytesWritable bWr = GenericUDFParamUtils.getBinaryValue(arguments, 1, this.converters);
                if (bWr == null) {
                    return null;
                }
                key = bWr.getBytes();
                keyLength = bWr.getLength();
            }
            secretKey = this.getSecretKey(key, keyLength);
        }
        if (secretKey == null) {
            return null;
        }
        byte[] res = this.aesFunction(input, inputLength, secretKey);
        if (res == null) {
            return null;
        }
        this.output.set(res, 0, res.length);
        return this.output;
    }

    protected SecretKey getSecretKey(byte[] key, int keyLength) {
        if (keyLength == 16 || keyLength == 32 || keyLength == 24) {
            return new SecretKeySpec(key, 0, keyLength, "AES");
        }
        return null;
    }

    protected byte[] aesFunction(byte[] input, int inputLength, SecretKey secretKey) {
        try {
            this.cipher.init(this.getCipherMode(), secretKey);
            byte[] res = this.cipher.doFinal(input, 0, inputLength);
            return res;
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    protected abstract int getCipherMode();

    protected abstract boolean canParam0BeStr();

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }
}

