/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.registry.impl;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperUtils.class);

    public static String setupZookeeperAuth(Configuration conf, String saslLoginContextName, String zkPrincipal, String zkKeytab) throws IOException {
        if (UserGroupInformation.isSecurityEnabled() && saslLoginContextName != null) {
            LOG.info("UGI security is enabled. Setting up ZK auth.");
            if (zkPrincipal == null || zkPrincipal.isEmpty()) {
                throw new IOException("Kerberos principal is empty");
            }
            if (zkKeytab == null || zkKeytab.isEmpty()) {
                throw new IOException("Kerberos keytab is empty");
            }
            return ZookeeperUtils.setZookeeperClientKerberosJaasConfig(saslLoginContextName, zkPrincipal, zkKeytab);
        }
        LOG.info("UGI security is not enabled, or no SASL context name. Skipping setting up ZK auth.");
        return null;
    }

    private static String setZookeeperClientKerberosJaasConfig(String saslLoginContextName, String zkPrincipal, String zkKeytab) throws IOException {
        System.setProperty("zookeeper.sasl.clientconfig", saslLoginContextName);
        String principal = SecurityUtil.getServerPrincipal((String)zkPrincipal, (String)"0.0.0.0");
        JaasConfiguration jaasConf = new JaasConfiguration(saslLoginContextName, principal, zkKeytab);
        javax.security.auth.login.Configuration.setConfiguration(jaasConf);
        return principal;
    }

    private static class JaasConfiguration
    extends javax.security.auth.login.Configuration {
        private final javax.security.auth.login.Configuration baseConfig = javax.security.auth.login.Configuration.getConfiguration();
        private final String loginContextName;
        private final String principal;
        private final String keyTabFile;

        public JaasConfiguration(String loginContextName, String principal, String keyTabFile) {
            this.loginContextName = loginContextName;
            this.principal = principal;
            this.keyTabFile = keyTabFile;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.loginContextName.equals(appName)) {
                HashMap<String, String> krbOptions = new HashMap<String, String>();
                krbOptions.put("doNotPrompt", "true");
                krbOptions.put("storeKey", "true");
                krbOptions.put("useKeyTab", "true");
                krbOptions.put("principal", this.principal);
                krbOptions.put("keyTab", this.keyTabFile);
                krbOptions.put("refreshKrb5Config", "true");
                AppConfigurationEntry zooKeeperClientEntry = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, krbOptions);
                return new AppConfigurationEntry[]{zooKeeperClientEntry};
            }
            if (this.baseConfig != null) {
                return this.baseConfig.getAppConfigurationEntry(appName);
            }
            return null;
        }
    }
}

