/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.tools.FileDump;
import org.codehaus.jettison.json.JSONException;

public class ScanData {
    static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options().addOption("help", "h", false, "Provide help");
        return new GnuParser().parse(options, args);
    }

    static void main(Configuration conf, String[] args) throws IOException, JSONException, ParseException {
        CommandLine cli = ScanData.parseCommandLine(args);
        if (cli.hasOption('h') || cli.getArgs().length == 0) {
            System.err.println("usage: java -jar orc-tools-*.jar scan [--help] <orc file>*");
            System.exit(1);
        } else {
            ArrayList<String> badFiles = new ArrayList<String>();
            for (String file : cli.getArgs()) {
                try {
                    Path path = new Path(file);
                    Reader reader = FileDump.getReader(path, conf, badFiles);
                    if (reader == null) continue;
                    RecordReader rows = reader.rows();
                    VectorizedRowBatch batch = reader.getSchema().createRowBatch();
                    long batchCount = 0L;
                    long rowCount = 0L;
                    while (rows.nextBatch(batch)) {
                        ++batchCount;
                        rowCount += (long)batch.size;
                    }
                    System.out.println("File " + path + ": " + batchCount + " batches, and " + rowCount + " rows.");
                }
                catch (Exception e) {
                    System.err.println("Unable to dump data for file: " + file);
                }
            }
        }
    }
}

