/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.json;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.orc.TypeDescription;
import org.apache.orc.tools.json.HiveType;

class UnionType
extends HiveType {
    final List<HiveType> children = new ArrayList<HiveType>();

    UnionType() {
        super(HiveType.Kind.UNION);
    }

    UnionType(HiveType left, HiveType right) {
        super(HiveType.Kind.UNION);
        this.children.add(left);
        this.children.add(right);
    }

    UnionType addType(HiveType type) {
        this.children.add(type);
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("uniontype<");
        boolean first = true;
        for (HiveType child : this.children) {
            if (!first) {
                buf.append(',');
            } else {
                first = false;
            }
            buf.append(child.toString());
        }
        buf.append(">");
        return buf.toString();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.children.equals(((UnionType)other).children);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (HiveType child : this.children) {
            result += child.hashCode() * 17;
        }
        return result;
    }

    @Override
    public boolean subsumes(HiveType other) {
        return true;
    }

    @Override
    public void merge(HiveType other) {
        if (other instanceof UnionType) {
            for (HiveType otherChild : ((UnionType)other).children) {
                this.merge(otherChild);
            }
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                HiveType child = this.children.get(i);
                if (child.subsumes(other)) {
                    child.merge(other);
                    return;
                }
                if (!other.subsumes(child)) continue;
                other.merge(child);
                this.children.set(i, other);
                return;
            }
            this.addType(other);
        }
    }

    @Override
    public void printFlat(PrintStream out, String prefix) {
        prefix = prefix + ".";
        int id = 0;
        for (HiveType child : this.children) {
            child.printFlat(out, prefix + id++);
        }
    }

    @Override
    public TypeDescription getSchema() {
        TypeDescription result = TypeDescription.createUnion();
        for (HiveType child : this.children) {
            result.addUnionChild(child.getSchema());
        }
        return result;
    }
}

